---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：92-ビルドトレース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **大規模プロジェクトでの処理時間**：定量的根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/collect-build-traces.ts` - collectBuildTraces関数、makeIgnoreFn、shouldIgnore
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.92 ビルドトレースの説明
- E-03: `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` - BuildTraceContext型、TRACE_IGNORES定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @vercel/nftを使用して依存関係をトレース | E-01 (19行目 import, 300行目 nodeFileTrace) | ○ |
| C-02 | .nft.jsonファイルを生成する | E-01 (127-132行目 出力パス定義) | ○ |
| C-03 | standaloneモードで追加ファイルをトレース | E-01 (138行目, 192-200行目) | ○ |
| C-04 | 開発用ファイルを除外する | E-01 (220行目 sharedIgnores) | ○ |
| C-05 | CI環境でimage-optimizerを除外 | E-01 (228-233行目) | ○ |
| C-06 | CI環境でsharpを除外 | E-01 (248-249行目) | ○ |
| C-07 | shouldIgnoreが再帰的に親をチェック | E-01 (44-91行目) | ○ |
| C-08 | ENOENTエラーを寛容に処理 | E-01 (306-316行目) | ○ |
| C-09 | カスタムキャッシュハンドラーの依存をトレース | E-01 (149-157行目, 178-190行目) | ○ |
| C-10 | picomatchを使用したglob除外パターン | E-01 (17行目 import, 30行目 使用) | ○ |
| C-11 | debugログをサポート | E-01 (26行目, 114行目) | ○ |
| C-12 | jest-workerファイルをstandalone時に追加 | E-01 (281-292行目) | ○ |
| C-13 | traceChild でトレーシングスパンを使用 | E-01 (121-125行目) | ○ |
| C-14 | mixedModulesオプションでトレース実行 | E-01 (303行目) | ○ |
| C-15 | 大規模プロジェクトでは数十秒〜数分かかる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス数値（C-15）は実測データに基づかない推定
  - 候補：Vercelのビルドログ / Next.jsベンチマークCI / 大規模OSSプロジェクトでの計測

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの主要ロジックは直接確認済み
- 1: 中リスク - ファイル後半部分（342行目以降）のルート別トレース処理は一部読み取り範囲外

## 6) レビュアーチェックリスト（最小）
- [ ] collectBuildTracesの全パラメータが正しく文書化されているか
- [ ] 除外パターンの一覧が最新のソースコードと一致しているか
- [ ] ルート別.nft.json生成処理の詳細が十分に記載されているか
