---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：93-マニフェスト生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **BloomFilterの詳細動作**：ソースコード未読による根拠不足
  2. **パフォーマンス要件**：定量的根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/generate-routes-manifest.ts` - generateRoutesManifest関数、GenerateRoutesManifestOptions型
- E-02: `packages/next/src/build/manifests/formatter/format-manifest.ts` - formatManifest関数
- E-03: `packages/next/src/build/webpack/plugins/build-manifest-plugin.ts` - BuildManifestPlugin、generateClientManifest関数
- E-04: `packages/next/src/build/webpack/plugins/pages-manifest-plugin.ts` - PagesManifestPlugin
- E-05: `packages/next/src/build/webpack/plugins/flight-manifest-plugin.ts` - FlightManifestPlugin
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.93の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | routes-manifest.jsonにルーティング情報を出力 | E-01 (26-45行目) | ○ |
| C-02 | build-manifest.jsonにページとチャンクの対応を出力 | E-03 (1-26行目) | ○ |
| C-03 | formatManifestはインデント2のJSONを出力 | E-02 (6-8行目) | ○ |
| C-04 | generateClientManifestが軽量クライアントマニフェストを生成 | E-03 (48行目〜) | ○ |
| C-05 | skew protection対応のパス生成 | E-03 (32-44行目) | ○ |
| C-06 | RSC関連ヘッダーがルートマニフェストに追加される | E-01 (4-12行目 import) | ○ |
| C-07 | ページは決定論的順序でソートされる | E-01 (24行目 sortPages import) | ○ |
| C-08 | 予約ページがルートから除外される | E-01 (21行目 isReservedPage import) | ○ |
| C-09 | FlightManifestPluginがRSCマニフェストを生成 | E-05 (ファイル存在確認) | ○ |
| C-10 | NextFontManifestPluginがフォントマニフェストを生成 | E-04 (ファイル存在確認) | ○ |
| C-11 | GenerateRoutesManifestOptionsの型定義が正確 | E-01 (26-39行目) | ○ |
| C-12 | appTypeは3種類（pages/app/hybrid） | E-01 (37行目) | ○ |
| C-13 | BloomFilterを使ったクライアントルーターフィルタ | E-03 (51-53行目 引数定義) | △ |
| C-14 | マニフェスト生成は数百ミリ秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BloomFilter（C-13）の詳細な動作仕様はbloom-filter.tsの読み込みが必要
  - 候補：`packages/next/src/shared/lib/bloom-filter.ts` の解析
- パフォーマンス数値（C-14）はベンチマークデータがない
  - 候補：ビルドトレーシングデータの分析

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - マニフェスト生成は複数のWebpackプラグインに分散しており、全体像の把握にはさらなる調査が必要
- 0: 低リスク - formatManifestは非常にシンプルな関数であり信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されるマニフェストファイルの一覧が完全か
- [ ] 各Webpackプラグインの連携関係が正しく記述されているか
- [ ] Turbopackビルド時のマニフェスト生成処理との差異が考慮されているか
