---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：94-DevTools（開発者ツール）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンスへの影響最小化の検証**：定量的な根拠が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` - DevOverlayコンポーネント
- E-02: `packages/next/src/next-devtools/entrypoint.ts` - エントリーポイント
- E-03: `packages/next/src/next-devtools/shared/types.ts` - DebugInfo型
- E-04: `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` - BuildErrorコンポーネント
- E-05: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` - Errorsコンポーネント
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.12-19の関連情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShadowPortal内にレンダリングされる | E-01 (28行目) | ○ |
| C-02 | showIndicatorがfalseの場合UIが非表示 | E-01 (36行目 条件分岐) | ○ |
| C-03 | PanelRouterContextでパネル遷移管理 | E-01 (41-48行目) | ○ |
| C-04 | RenderErrorでエラー集計 | E-01 (32-33行目) | ○ |
| C-05 | ErrorOverlayがビルドエラーとランタイムエラーを表示 | E-01 (50-58行目) | ○ |
| C-06 | isAppDir=trueで固定 | E-01 (32行目) | ○ |
| C-07 | entrypoint.tsがCSS importとre-exportを行う | E-02 (1-3行目) | ○ |
| C-08 | DebugInfo型はdevtoolsFrontendUrlを含む | E-03 (1-3行目) | ○ |
| C-09 | BuildErrorがターミナル風表示を行う | E-04 (3行目 Terminal import, 29行目〜) | ○ |
| C-10 | ハイドレーションエラーのPseudoHtmlDiff表示 | E-05 (7行目 import) | ○ |
| C-11 | 画面No.12-19がDevToolsに関連 | E-06 (画面マッピングCSV) | ○ |
| C-12 | ScaleUpdaterがCSS変数を制御 | E-01 (29行目) | ○ |
| C-13 | ComponentStylesがコンポーネントスタイルを注入 | E-01 (30行目) | ○ |
| C-14 | DevToolsIndicatorがNext.jsロゴボタンを表示 | E-01 (60行目) | ○ |
| C-15 | Storybookによるコンポーネント開発サポート | storybookディレクトリおよび.stories.tsxファイルの存在 | ○ |
| C-16 | ホストページのパフォーマンスへの影響最小化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス影響（C-16）の定量的検証データがない
  - 候補：Lighthouse計測 / パフォーマンステストCI

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネントの構成は直接確認済み
- 0: 低リスク - サーバーミドルウェアは独立したファイルとして確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 関連画面のマッピングが画面機能マッピングCSVと一致しているか
- [ ] サーバーミドルウェアのAPIパスが正確か
- [ ] Pages Router使用時のDevTools動作が正しく記載されているか
