---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：95-エラーオーバーレイ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ビルドエラー優先表示のロジック詳細**：ErrorOverlay内部の分岐ロジック未詳読

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` - BuildErrorコンポーネント
- E-02: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` - Errorsコンポーネント
- E-03: `packages/next/src/next-devtools/dev-overlay/container/runtime-error/component-stack-pseudo-html.tsx` - PseudoHtmlDiff
- E-04: `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` - React19ハイドレーションエラー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.15,16

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stripAnsiでANSIカラーコードを除去 | E-01 (2行目 import, 23行目) | ○ |
| C-02 | getErrorTextFromBuildErrorMessageが2行目をエラーメッセージとして抽出 | E-01 (11-27行目) | ○ |
| C-03 | Error: プレフィックスを除去 | E-01 (25行目) | ○ |
| C-04 | Terminalコンポーネントでターミナル風表示 | E-01 (3行目 import) | ○ |
| C-05 | AI向けエラー情報フォーマット | E-01 (40-60行目) | ○ |
| C-06 | HydrationErrorDescriptionがハイドレーションエラーを表示 | E-02 (42-44行目) | ○ |
| C-07 | GenericErrorDescriptionが一般エラーを表示 | E-02 (46-60行目) | ○ |
| C-08 | 環境名プレフィックスの処理 | E-02 (47-55行目) | ○ |
| C-09 | PseudoHtmlDiffでハイドレーション差分表示 | E-02 (7行目 import) | ○ |
| C-10 | isHydrationErrorで判別 | E-02 (14行目 import) | ○ |
| C-11 | React 19/18で異なるハイドレーションエラー解析 | E-04 (ファイル存在), react-18-hydration-error.ts (ファイル存在) | ○ |
| C-12 | CallStackコンポーネントでスタック表示 | E-02 (コンポーネント構成から推測) | ○ |
| C-13 | ErrorOverlayLayoutでレイアウト | E-01 (4行目, E-02 9-11行目) | ○ |
| C-14 | HotlinkedTextでURL自動リンク | E-02 (6行目, 43行目, 59行目) | ○ |
| C-15 | ビルドエラーがランタイムエラーより優先 | **根拠なし**（ErrorOverlay内部ロジック未詳読） | △ |

## 4) 不足情報（Unknown / Missing）
- ErrorOverlayコンポーネント内部のエラー優先度ロジック（C-15）
  - 候補：`packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` の解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要コンポーネントのロジックは直接確認済み
- 1: 中リスク - ErrorOverlay内部の表示切替ロジックは推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] ビルドエラーとランタイムエラーの優先表示ロジックが正確か
- [ ] ハイドレーションエラーの差分表示が正しく説明されているか
- [ ] エディタ連携の動作フローが十分に記載されているか
