---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：96-TypeScriptサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **必須コンパイラオプションの完全なリスト**：writeConfigurationDefaults.tsの後半部分が未読

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/typescript/runTypeCheck.ts` - runTypeCheck関数
- E-02: `packages/next/src/lib/typescript/getTypeScriptIntent.ts` - getTypeScriptIntent関数
- E-03: `packages/next/src/lib/typescript/writeAppTypeDeclarations.ts` - writeAppTypeDeclarations関数
- E-04: `packages/next/src/lib/typescript/writeConfigurationDefaults.ts` - getDesiredCompilerOptions関数（先頭80行）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.96の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tsconfig.jsonの存在確認でTypeScriptインテントを検出 | E-02 (12-23行目) | ○ |
| C-02 | 空のtsconfig.jsonはfirstTimeSetupとして扱う | E-02 (22行目) | ○ |
| C-03 | .ts/.tsxファイルの再帰検索 | E-02 (29-39行目) | ○ |
| C-04 | next-env.d.tsにtriple-slash directivesを生成 | E-03 (50-53行目) | ○ |
| C-05 | imageImportsEnabled時にimage-types参照を追加 | E-03 (55-57行目) | ○ |
| C-06 | App+Pages両方存在時にcompat/navigation型参照追加 | E-03 (59-63行目) | ○ |
| C-07 | 既存内容と同一なら書き込みスキップ | E-03 (85-87行目) | ○ |
| C-08 | devTypesDir配下のファイルをビルド時に除外 | E-01 (61-66行目) | ○ |
| C-09 | テストファイルパターンを除外 | E-01 (153-161行目) | ○ |
| C-10 | インクリメンタルビルド対応 | E-01 (131-149行目) | ○ |
| C-11 | composite projectは警告表示 | E-01 (132-136行目) | ○ |
| C-12 | .tsbuildinfo をcacheDirに保存 | E-01 (144行目) | ○ |
| C-13 | 最初のエラーをCompileErrorとして送出 | E-01 (205-215行目) | ○ |
| C-14 | target: ES2017を推奨 | E-04 (44-48行目) | ○ |
| C-15 | TS 5.4以上でpreserveモジュールサポート | E-04 (65行目, 77-79行目) | ○ |
| C-16 | module: esnextが推奨値 | E-04 (73行目) | ○ |
| C-17 | 必須コンパイラオプションの完全なリスト | E-04 (先頭80行のみ読取) | △ |

## 4) 不足情報（Unknown / Missing）
- writeConfigurationDefaults.tsの80行目以降（C-17）
  - 候補：同ファイルの全文読み取り

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TypeScript型チェックのコアロジックは直接確認済み
- 0: 低リスク - next-env.d.ts生成ロジックは完全に読み取り済み

## 6) レビュアーチェックリスト（最小）
- [ ] 必須コンパイラオプション（module, esModuleInterop等）の完全なリストが正確か
- [ ] TypeScript 5.4以上の新機能対応が正しく記載されているか
- [ ] debugBuildPathsフィルタの動作が正しく説明されているか
