---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-ESLintプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/eslint-plugin-next/src/index.ts` - プラグインエントリ、ルール定義、プリセット設定
- E-02: `packages/eslint-plugin-next/src/rules/` - 各ルールファイル一覧（Globで確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.97の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 21個のESLintルールを提供 | E-01 (60-83行目 rules定義), E-02 (21ファイル) | ○ |
| C-02 | 15個のwarning、6個のerror | E-01 (25-49行目) | ○ |
| C-03 | recommendedプリセットの提供 | E-01 (104-110行目) | ○ |
| C-04 | core-web-vitalsプリセットの提供 | E-01 (111-121行目) | ○ |
| C-05 | レガシー設定形式のサポート | E-01 (95-103行目) | ○ |
| C-06 | フラット設定形式のサポート | E-01 (104-121行目) | ○ |
| C-07 | core-web-vitalsはrecommendedを拡張 | E-01 (116-119行目) | ○ |
| C-08 | no-html-link-for-pagesがcore-web-vitalsでerror | E-01 (52行目) | ○ |
| C-09 | no-sync-scriptsがcore-web-vitalsでerror | E-01 (53行目) | ○ |
| C-10 | inline-script-idがerrorレベル | E-01 (43行目) | ○ |
| C-11 | no-assign-module-variableがerrorレベル | E-01 (44行目) | ○ |
| C-12 | no-document-import-in-pageがerrorレベル | E-01 (45行目) | ○ |
| C-13 | no-duplicate-headがerrorレベル | E-01 (46行目) | ○ |
| C-14 | プラグイン名は@next/eslint-plugin-next | E-01 (58行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張に根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - index.tsの全体を読み取り済みであり、ルール一覧は完全に確認できている

## 6) レビュアーチェックリスト（最小）
- [ ] 21個のルール名が全て正しくリストされているか
- [ ] 各ルールの説明が正しいか（個別ルールの実装確認が必要な場合あり）
- [ ] ESLint 9のフラット設定形式が正しく動作するか
