---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-Jest統合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/jest/jest.ts` - nextJest関数、Jest設定生成ロジック全体
- E-02: `packages/next/src/build/jest/__mocks__/` - モックファイル群
- E-03: `packages/next/src/build/jest/object-proxy.ts` - CSSモジュールProxyモック
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.98の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSSモジュールはProxyオブジェクトでモック | E-01 (126-127行目) | ○ |
| C-02 | CSS非モジュールは空スタイルモックでモック | E-01 (130行目) | ○ |
| C-03 | 画像ファイルはfileMockでモック | E-01 (133-135行目) | ○ |
| C-04 | next/fontはnextFontMockでモック | E-01 (141-143行目) | ○ |
| C-05 | server-onlyは空モジュールでモック | E-01 (145行目) | ○ |
| C-06 | SWCトランスフォーマーでトランスパイル | E-01 (163-167行目) | ○ |
| C-07 | transpilePackagesをtransformIgnorePatternsに反映 | E-01 (106-108行目, 172-182行目) | ○ |
| C-08 | .nextディレクトリを除外 | E-01 (155-156行目, 191-193行目) | ○ |
| C-09 | カスタム設定がマージされる | E-01 (150行目, 169行目, 188行目) | ○ |
| C-10 | package.jsonからESMプロジェクト判定 | E-01 (80-81行目) | ○ |
| C-11 | loadConfigでNext.js設定読み込み | E-01 (83行目) | ○ |
| C-12 | loadEnvConfigで環境変数読み込み | E-01 (87行目) | ○ |
| C-13 | installBindingsでSWC事前インストール | E-01 (100行目) | ○ |
| C-14 | package.jsonの最大5階層検索 | E-01 (23-33行目) | ○ |
| C-15 | lockfilePatchPromise待機 | E-01 (102-104行目) | ○ |
| C-16 | pnpmの.pnpmディレクトリ考慮 | E-01 (176-179行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張に根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - jest.tsの全体を読み取り済みであり、ロジックは完全に確認できている

## 6) レビュアーチェックリスト（最小）
- [ ] moduleNameMapperの設定が最新のソースコードと一致するか
- [ ] transformIgnorePatternsのpnpm対応が正しいか
- [ ] DEFAULT_TRANSPILED_PACKAGESの内容が適切か
