---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：99-Codemods

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **upgrade処理の詳細フロー**：upgrade.tsの全体が未読

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next-codemod/bin/next-codemod.ts` - CLIエントリーポイント
- E-02: `packages/next-codemod/bin/transform.ts` - runTransform関数（先頭80行）
- E-03: `packages/next-codemod/bin/shared.ts` - BadInput等の共有定義
- E-04: `packages/next-codemod/transforms/` - 変換モジュール群（Globで一覧確認）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.99の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Commander.jsによるCLI定義 | E-01 (12行目 import, 19-56行目) | ○ |
| C-02 | upgradeサブコマンドの存在 | E-01 (57-79行目) | ○ |
| C-03 | agents-mdサブコマンドの存在 | E-01 (81-102行目) | ○ |
| C-04 | transformメインコマンドの定義 | E-01 (19-48行目) | ○ |
| C-05 | --force, --dry, --print, --verboseオプション | E-01 (36-43行目) | ○ |
| C-06 | Git安全チェック | E-02 (33-35行目) | ○ |
| C-07 | codemod名の検証 | E-02 (37-46行目) | ○ |
| C-08 | インタラクティブプロンプトによる選択 | E-02 (48-80行目) | ○ |
| C-09 | globパターンの展開 | E-02 (13-19行目 expandFilePathsIfNeeded) | ○ |
| C-10 | BadInput例外クラス | E-01 (16行目 import, 72行目使用) | ○ |
| C-11 | enablePositionalOptions | E-01 (55行目) | ○ |
| C-12 | revisionのデフォルトがminor | E-01 (64行目 description) | ○ |
| C-13 | jscodeshiftで変換実行 | E-02 (22行目 jscodeshiftExecutable) | ○ |
| C-14 | upgrade処理の詳細フロー | **根拠なし**（upgrade.ts未読） | △ |

## 4) 不足情報（Unknown / Missing）
- upgrade.tsの詳細な処理フロー（C-14）
  - 候補：`packages/next-codemod/bin/upgrade.ts` の全文読み取り

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CLIのコマンド構造は直接確認済み
- 1: 中リスク - transformsディレクトリの個別変換モジュールの網羅的な確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 利用可能なcodemod一覧が最新のtransformsディレクトリと一致しているか
- [ ] upgrade処理のバージョン判定ロジックが正確か
- [ ] agents-mdコマンドの出力形式が正しいか
