---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  1. 特に根拠不足の項目はなし。全画面がソースコードの直接解析に基づく。
  2. ただし本プロジェクトはフレームワークであるため、ユーザーアプリケーション固有の画面は対象外であり、ビルトイン画面と開発ツール画面のみを網羅している点に留意が必要。
  3. create-next-appテンプレートの画面（初期ページ等）はフレームワーク利用者向けのスキャフォールドであり、フレームワーク本体の画面としては含めていない。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/pages/_error.tsx` - Pages Routerのデフォルトエラーページ
- E-02: `packages/next/src/pages/_document.tsx` - Pages Routerのドキュメントテンプレート
- E-03: `packages/next/src/pages/_app.tsx` - Pages Routerのアプリケーションラッパー
- E-04: `packages/next/src/client/components/builtin/global-not-found.tsx` - グローバル404ページ
- E-05: `packages/next/src/client/components/builtin/not-found.tsx` - セグメントレベル404ページ
- E-06: `packages/next/src/client/components/builtin/global-error.tsx` - グローバルエラーページ
- E-07: `packages/next/src/client/components/builtin/app-error.tsx` - 静的500ページ
- E-08: `packages/next/src/client/components/builtin/forbidden.tsx` - 403ページ
- E-09: `packages/next/src/client/components/builtin/unauthorized.tsx` - 401ページ
- E-10: `packages/next/src/client/components/builtin/layout.tsx` - デフォルトレイアウト
- E-11: `packages/next/src/client/components/builtin/default.tsx` - パラレルルートデフォルト
- E-12: `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` - 開発オーバーレイ
- E-13: `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` - DevToolsインジケーター
- E-14: `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` - パネルルーター（メニュー・各パネル定義）
- E-15: `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` - ビルドエラー画面
- E-16: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` - ランタイムエラー画面
- E-17: `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` - エラーオーバーレイ制御
- E-18: `packages/next/src/next-devtools/dev-overlay/menu/context.tsx` - パネル状態定義（PanelStateKind型）
- E-19: `packages/next/src/next-devtools/dev-overlay/components/overview/segment-explorer.tsx` - セグメントエクスプローラー
- E-20: `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` - HTTPアクセスエラーフォールバック共通コンポーネント
- E-21: `packages/next/src/client/components/builtin/error-styles.tsx` - エラーページ共通スタイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エラーページ (_error) はHTTPステータスコードに応じたメッセージを表示する | E-01 | ○ |
| C-02 | ドキュメント (_document) はHTML基本構造を定義しCSS/スクリプトを管理する | E-02 | ○ |
| C-03 | アプリケーションラッパー (_app) は全ページを包む共通コンポーネントである | E-03 | ○ |
| C-04 | グローバル404ページはルートレベルで404を表示しhtml/bodyを含む | E-04 | ○ |
| C-05 | 404ページ (Not Found) はHTTPAccessErrorFallbackを使用して404を表示する | E-05, E-20 | ○ |
| C-06 | グローバルエラーページはサーバー/クライアントエラーを区別して表示する | E-06, E-21 | ○ |
| C-07 | 500エラーページはビルド時生成の静的ページである | E-07 | ○ |
| C-08 | 403ページはHTTPAccessErrorFallbackで403を表示する | E-08, E-20 | ○ |
| C-09 | 401ページはHTTPAccessErrorFallbackで401を表示する | E-09, E-20 | ○ |
| C-10 | デフォルトレイアウトは最小限のhtml/body構造を提供する | E-10 | ○ |
| C-11 | パラレルルートデフォルトはnotFound()を呼び出す | E-11 | ○ |
| C-12 | 開発オーバーレイはエラー表示・インジケーター・パネルを統合するUI | E-12 | ○ |
| C-13 | DevToolsインジケーターはドラッグ可能なフローティングボタン | E-13 | ○ |
| C-14 | DevToolsメニューはIssues/Route/Bundler/Route Info/Preferencesを表示する | E-14, E-18 | ○ |
| C-15 | ビルドエラー画面はコンパイルエラーをターミナル風に表示する | E-15 | ○ |
| C-16 | ランタイムエラー画面はハイドレーション/ブロッキング/一般エラーを種別表示する | E-16 | ○ |
| C-17 | ルート情報パネルはStatic/Dynamic情報を表示する | E-14 | ○ |
| C-18 | セグメントエクスプローラーはApp Routerのセグメントツリーを表示する | E-19 | ○ |
| C-19 | ユーザー設定パネルはテーマ・位置・スケール等の設定を変更できる | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全19件の主張がソースコードから直接確認できた。
- ただし以下の点は補足的な確認が推奨される：
  - create-next-appテンプレート内のページ（初期スキャフォールドページ）はフレームワーク本体の画面ではないため除外したが、プロジェクトの範囲定義によっては含める可能性がある
  - 候補：`packages/create-next-app/templates/` 配下のテンプレートページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全画面がソースコードから直接確認済み
- 0: 低リスク - Pages Router / App Router / 開発ツールの3カテゴリで網羅的に分類
- 1: 中リスク - 本プロジェクトがフレームワークであるため「画面」の定義範囲に解釈の余地がある。エンドユーザーアプリの画面は存在せず、フレームワークが提供するビルトイン画面のみが対象となっている。

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の19画面がプロジェクトのビルトイン画面を網羅しているか
- [ ] 各画面のテンプレートファイルパスが実在するファイルを指しているか
- [ ] Pages Router / App Router / 開発ツールのカテゴリ分けが適切か
- [ ] 画面遷移図のmermaid記法が正しくレンダリングされるか
- [ ] create-next-appテンプレートの画面を含める必要があるか検討
- [ ] 開発ツールの画面遷移（メニュー -> 各パネル）の遷移条件が正確か
