# 画面遷移図

## 概要

Next.js フレームワークが提供するビルトイン画面および開発ツール画面の遷移関係を示す。
本プロジェクトはフレームワークであるため、ユーザーアプリケーションの画面遷移ではなく、
フレームワークが内部的に提供する画面間の遷移を記載する。

## Pages Router ビルトイン画面遷移

```mermaid
graph TD
    subgraph PagesRouter["Pages Router ビルトイン画面"]
        PR_APP["_app<br/>アプリケーションラッパー"]
        PR_DOC["_document<br/>ドキュメントテンプレート"]
        PR_ERROR["_error<br/>エラーページ"]
        PR_PAGE["ユーザー定義ページ"]

        PR_DOC -->|"HTML構造を提供"| PR_APP
        PR_APP -->|"ページコンポーネントをラップ"| PR_PAGE
        PR_PAGE -->|"エラー発生時<br/>（400/404/405/500）"| PR_ERROR
    end
```

## App Router ビルトイン画面遷移

```mermaid
graph TD
    subgraph AppRouter["App Router ビルトイン画面"]
        AR_LAYOUT["Default Layout<br/>デフォルトレイアウト"]
        AR_PAGE["ユーザー定義ページ"]
        AR_NOTFOUND["Not Found<br/>404ページ"]
        AR_GLOBAL_NOTFOUND["Global Not Found<br/>グローバル404ページ"]
        AR_GLOBAL_ERROR["Global Error<br/>グローバルエラーページ"]
        AR_APP_ERROR["App Error<br/>500エラーページ"]
        AR_FORBIDDEN["Forbidden<br/>403ページ"]
        AR_UNAUTHORIZED["Unauthorized<br/>401ページ"]
        AR_PARALLEL_DEFAULT["Parallel Route Default<br/>パラレルルートデフォルト"]

        AR_LAYOUT -->|"子要素をレンダリング"| AR_PAGE
        AR_PAGE -->|"notFound()呼び出し"| AR_NOTFOUND
        AR_PAGE -->|"ルート不一致"| AR_GLOBAL_NOTFOUND
        AR_PAGE -->|"キャッチされないエラー"| AR_GLOBAL_ERROR
        AR_GLOBAL_ERROR -->|"Reload pageクリック"| AR_PAGE
        AR_GLOBAL_ERROR -->|"Go backクリック"| AR_PAGE
        AR_PAGE -->|"サーバーエラー（静的500）"| AR_APP_ERROR
        AR_APP_ERROR -->|"Reload pageクリック"| AR_PAGE
        AR_PAGE -->|"forbidden()呼び出し"| AR_FORBIDDEN
        AR_PAGE -->|"unauthorized()呼び出し"| AR_UNAUTHORIZED
        AR_PARALLEL_DEFAULT -->|"notFound()を発火"| AR_NOTFOUND
    end
```

## 開発ツール画面遷移

```mermaid
graph TD
    subgraph DevTools["開発ツール"]
        DT_OVERLAY["Dev Overlay<br/>開発オーバーレイ"]
        DT_INDICATOR["DevToolsインジケーター<br/>（Next.jsロゴボタン）"]
        DT_MENU["DevToolsメニュー<br/>（Panel Selector）"]
        DT_BUILD_ERROR["ビルドエラー画面"]
        DT_RUNTIME_ERROR["ランタイムエラー画面"]
        DT_ROUTE_TYPE["ルート情報パネル<br/>（Route Type）"]
        DT_SEGMENT["セグメントエクスプローラー<br/>（Route Info）"]
        DT_PREFS["ユーザー設定パネル<br/>（Preferences）"]

        DT_OVERLAY -->|"常時表示"| DT_INDICATOR
        DT_INDICATOR -->|"クリック"| DT_MENU
        DT_MENU -->|"クリック（外部 or Escape）"| DT_INDICATOR
        DT_MENU -->|"Issues クリック"| DT_RUNTIME_ERROR
        DT_MENU -->|"Route クリック"| DT_ROUTE_TYPE
        DT_MENU -->|"Route Info クリック"| DT_SEGMENT
        DT_MENU -->|"Preferences クリック"| DT_PREFS
        DT_OVERLAY -->|"コンパイルエラー発生"| DT_BUILD_ERROR
        DT_OVERLAY -->|"ランタイムエラー発生"| DT_RUNTIME_ERROR
        DT_RUNTIME_ERROR -->|"閉じる"| DT_INDICATOR
        DT_BUILD_ERROR -->|"エラー解消"| DT_INDICATOR
        DT_ROUTE_TYPE -->|"閉じる"| DT_INDICATOR
        DT_SEGMENT -->|"閉じる"| DT_INDICATOR
        DT_PREFS -->|"閉じる"| DT_INDICATOR
    end
```

## 全体概要図

```mermaid
graph LR
    subgraph Runtime["Next.js ランタイム"]
        direction TB
        USER_PAGE["ユーザー定義ページ"]
        PAGES_BUILTIN["Pages Router<br/>ビルトイン画面群"]
        APP_BUILTIN["App Router<br/>ビルトイン画面群"]
    end

    subgraph DevMode["開発モード専用"]
        direction TB
        DEV_OVERLAY["開発オーバーレイ"]
        DEV_INDICATOR["DevToolsインジケーター"]
        DEV_PANELS["各種パネル<br/>（メニュー / エラー / 設定等）"]
    end

    USER_PAGE -->|"エラー発生"| PAGES_BUILTIN
    USER_PAGE -->|"エラー発生"| APP_BUILTIN
    USER_PAGE -.->|"開発モード時"| DEV_OVERLAY
    DEV_OVERLAY --> DEV_INDICATOR
    DEV_INDICATOR --> DEV_PANELS
```
