---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 49
  claims_with_evidence: 43
  claims_without_evidence: 6
confidence_derived: 0.88
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された画面機能マッピングの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：43 / 49、根拠なし：6
- 優先レビュー（高）
  1. **403ページとApp Routerのforbidden()連携**：forbidden()関数の実装詳細を直接確認していない
  2. **401ページとApp Routerのunauthorized()連携**：unauthorized()関数の実装詳細を直接確認していない
  3. **ISRエラー連携（グローバルエラーページ）**：HandleISRErrorの動作詳細を直接確認していない
  4. **ルート情報パネルとSSG/SSR連携**：静的/動的判定ロジックの直接確認が不足
  5. **Turbopack情報表示**：環境変数に基づく表示条件のみ確認
  6. **DevToolsインジケーター非表示API連携**：`__nextjs_disable_dev_indicator` APIエンドポイントの実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/pages/_error.tsx` - Pages Routerエラーページ実装
- E-02: `packages/next/src/pages/_document.tsx` - Pages Routerドキュメント実装
- E-03: `packages/next/src/pages/_app.tsx` - Pages Routerアプリケーションラッパー実装
- E-04: `packages/next/src/client/components/builtin/global-not-found.tsx` - App Routerグローバル404ページ実装
- E-05: `packages/next/src/client/components/builtin/not-found.tsx` - App Router 404ページ実装
- E-06: `packages/next/src/client/components/builtin/global-error.tsx` - App Routerグローバルエラーページ実装
- E-07: `packages/next/src/client/components/builtin/app-error.tsx` - App Router 500エラーページ実装
- E-08: `packages/next/src/client/components/builtin/forbidden.tsx` - App Router 403ページ実装
- E-09: `packages/next/src/client/components/builtin/unauthorized.tsx` - App Router 401ページ実装
- E-10: `packages/next/src/client/components/builtin/layout.tsx` - デフォルトレイアウト実装
- E-11: `packages/next/src/client/components/builtin/default.tsx` - パラレルルートデフォルト実装
- E-12: `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` - 開発オーバーレイ実装
- E-13: `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` - DevToolsインジケーター実装
- E-14: `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` - DevToolsメニュー・パネルルーター実装
- E-15: `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` - ビルドエラー画面実装
- E-16: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` - ランタイムエラー画面実装
- E-17: `packages/next/src/next-devtools/dev-overlay/components/overview/segment-explorer.tsx` - セグメントエクスプローラー実装
- E-18: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-19: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面1(エラーページ) - 機能33(カスタムエラーページ): 主機能 | E-01, E-19 | ○ |
| C-02 | 画面1(エラーページ) - 機能26(Pages Router): 補助機能 | E-01, E-18 | ○ |
| C-03 | 画面1(エラーページ) - 機能34(SSR): 補助機能（getInitialProps） | E-01 | ○ |
| C-04 | 画面2(ドキュメント) - 機能32(カスタムDocument): 主機能 | E-02, E-19 | ○ |
| C-05 | 画面2(ドキュメント) - 機能26(Pages Router): 補助機能 | E-02 | ○ |
| C-06 | 画面2(ドキュメント) - 機能34(SSR): 補助機能 | E-02 | ○ |
| C-07 | 画面2(ドキュメント) - 機能60(next/script): 補助機能 | E-02 | ○ |
| C-08 | 画面2(ドキュメント) - 機能59(next/font): 補助機能 | E-02 | ○ |
| C-09 | 画面3(アプリケーションラッパー) - 機能31(カスタムApp): 主機能 | E-03, E-19 | ○ |
| C-10 | 画面3(アプリケーションラッパー) - 機能26(Pages Router): 補助機能 | E-03 | ○ |
| C-11 | 画面3(アプリケーションラッパー) - 機能34(SSR): 補助機能 | E-03 | ○ |
| C-12 | 画面4(グローバル404) - 機能16(エラーハンドリング): 主機能 | E-04, E-19 | ○ |
| C-13 | 画面4(グローバル404) - 機能13(App Router): 補助機能 | E-04 | ○ |
| C-14 | 画面5(404ページ) - 機能16(エラーハンドリング): 主機能 | E-05 | ○ |
| C-15 | 画面5(404ページ) - 機能13(App Router): 補助機能 | E-05 | ○ |
| C-16 | 画面6(グローバルエラー) - 機能16(エラーハンドリング): 主機能 | E-06 | ○ |
| C-17 | 画面6(グローバルエラー) - 機能13(App Router): 補助機能 | E-06 | ○ |
| C-18 | 画面6(グローバルエラー) - 機能36(ISR): API連携（HandleISRError） | E-06 | △ |
| C-19 | 画面7(500エラー) - 機能16(エラーハンドリング): 主機能 | E-07 | ○ |
| C-20 | 画面7(500エラー) - 機能2(next build): 補助機能 | E-07 | ○ |
| C-21 | 画面8(403ページ) - 機能16(エラーハンドリング): 主機能 | E-08 | ○ |
| C-22 | 画面8(403ページ) - 機能13(App Router): forbidden()連携 | E-08 | △ |
| C-23 | 画面9(401ページ) - 機能16(エラーハンドリング): 主機能 | E-09 | ○ |
| C-24 | 画面9(401ページ) - 機能13(App Router): unauthorized()連携 | E-09 | △ |
| C-25 | 画面10(デフォルトレイアウト) - 機能14(レイアウト): 主機能 | E-10 | ○ |
| C-26 | 画面10(デフォルトレイアウト) - 機能13(App Router): 補助機能 | E-10 | ○ |
| C-27 | 画面11(パラレルルートデフォルト) - 機能20(並列ルート): 主機能 | E-11 | ○ |
| C-28 | 画面11(パラレルルートデフォルト) - 機能13(App Router): 補助機能 | E-11 | ○ |
| C-29 | 画面12(開発オーバーレイ) - 機能94(DevTools): 主機能 | E-12 | ○ |
| C-30 | 画面12(開発オーバーレイ) - 機能95(エラーオーバーレイ): 補助機能 | E-12 | ○ |
| C-31 | 画面12(開発オーバーレイ) - 機能1(next dev): 補助機能 | E-12 | ○ |
| C-32 | 画面13(DevToolsインジケーター) - 機能94(DevTools): 主機能 | E-13 | ○ |
| C-33 | 画面13(DevToolsインジケーター) - 機能1(next dev): 補助機能 | E-13 | ○ |
| C-34 | 画面14(DevToolsメニュー) - 機能94(DevTools): 主機能 | E-14 | ○ |
| C-35 | 画面14(DevToolsメニュー) - 機能95(エラーオーバーレイ): 遷移先機能 | E-14 | ○ |
| C-36 | 画面14(DevToolsメニュー) - 機能87(Turbopack統合): 補助機能 | E-14 | △ |
| C-37 | 画面15(ビルドエラー画面) - 機能95(エラーオーバーレイ): 主機能 | E-15 | ○ |
| C-38 | 画面15(ビルドエラー画面) - 機能94(DevTools): 補助機能 | E-15 | ○ |
| C-39 | 画面15(ビルドエラー画面) - 機能1(next dev): 補助機能 | E-15 | ○ |
| C-40 | 画面16(ランタイムエラー画面) - 機能95(エラーオーバーレイ): 主機能 | E-16 | ○ |
| C-41 | 画面16(ランタイムエラー画面) - 機能94(DevTools): 補助機能 | E-16 | ○ |
| C-42 | 画面16(ランタイムエラー画面) - 機能1(next dev): 補助機能 | E-16 | ○ |
| C-43 | 画面17(ルート情報パネル) - 機能94(DevTools): 主機能 | E-14 | ○ |
| C-44 | 画面17(ルート情報パネル) - 機能35(SSG): 補助機能 | E-14 | △ |
| C-45 | 画面17(ルート情報パネル) - 機能34(SSR): 補助機能 | E-14 | △ |
| C-46 | 画面18(セグメントエクスプローラー) - 機能94(DevTools): 主機能 | E-14, E-17 | ○ |
| C-47 | 画面18(セグメントエクスプローラー) - 機能13(App Router): 補助機能 | E-14, E-17 | ○ |
| C-48 | 画面18(セグメントエクスプローラー) - 機能14(レイアウト): 補助機能 | E-17 | ○ |
| C-49 | 画面19(ユーザー設定パネル) - 機能94(DevTools): 主機能 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- **forbidden() / unauthorized() 関数の実装詳細**: forbidden.tsx / unauthorized.tsxの呼び出し元であるApp Routerのforbidden()、unauthorized()関数の実装を直接確認していない。HTTPAccessErrorFallbackコンポーネントの使用は確認済みだが、呼び出しフロー全体の検証が不足。
  - 候補：`src/client/components/forbidden.ts` / `src/client/components/unauthorized.ts` / `src/server/app-render/` 内の関連ファイル
- **HandleISRErrorコンポーネントの動作詳細**: global-error.tsxで使用されているHandleISRErrorの実装を直接確認していない。ISRエラー時の再検証処理の詳細が不明。
  - 候補：`src/client/components/handle-isr-error.tsx` / `src/server/lib/incremental-cache/`
- **Turbopack統合の表示ロジック**: panel-router.tsxでprocess.env.TURBOPACKの条件分岐は確認したが、Turbopack統合機能（機能87）との直接的な連携の深さが不明。
  - 候補：`turbopack/` / `src/server/dev/hot-reloader-turbopack.ts`
- **静的/動的ルート判定ロジック**: ルート情報パネルでstatic/dynamicの表示は確認したが、SSG（機能35）やSSR（機能34）との直接的な判定ロジックの連携は推定に基づく。
  - 候補：`src/build/analysis/` / `src/server/lib/router-server.ts`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Pages Router系画面（画面1-3）と機能の対応は、ソースコードのimport関係・getInitialPropsの使用から明確に確認できる
- **0: 低リスク** - App Router系ビルトイン画面（画面4-11）は、HTTPAccessErrorFallbackの使用やnotFound()呼び出しから直接確認できる
- **1: 中リスク** - 403/401ページとApp Router関数（forbidden/unauthorized）の連携は、ソースコードの使用パターンから推定しているが、呼び出しフロー全体は未検証
- **0: 低リスク** - 開発ツール画面（画面12-19）は、dev-overlay.tsx / panel-router.tsxのコンポーネント構成から直接確認できる
- **1: 中リスク** - ルート情報パネルとSSG/SSRの連携は、staticIndicator状態の使用は確認できるが、判定ロジックの根拠は間接的

## 6) レビュアーチェックリスト（最小）
- [ ] Pages Router系画面（画面1-3）の機能マッピングがソースコードのimport・API使用と一致しているか
- [ ] App Router系ビルトイン画面（画面4-11）のエラーハンドリング機能との対応が正確か
- [ ] forbidden() / unauthorized() の呼び出しフローが403/401ページのマッピングと整合しているか
- [ ] HandleISRErrorコンポーネントのISR連携が正確に記述されているか
- [ ] 開発ツール画面（画面12-19）のコンポーネント階層関係が機能マッピングに正しく反映されているか
- [ ] ルート情報パネルのstatic/dynamic判定がSSG/SSR機能との対応として適切か
- [ ] 全行のCSVフォーマット（ダブルクォート囲み、列数一致）が正しいか
