# 画面設計書 11-パラレルルートデフォルト (Parallel Route Default)

## 概要

本ドキュメントは、Next.js App Routerのパラレルルート機構において、明示的な`default.tsx`が定義されていない場合に使用されるフォールバックコンポーネントの画面設計書である。

### 本画面の処理概要

パラレルルートデフォルト画面は、App Routerのパラレルルート（Parallel Routes）機能で、特定のスロットに対応する`default.tsx`ファイルがユーザーによって作成されていない場合に、フレームワーク内部で自動的に使用されるフォールバックコンポーネントである。

**業務上の目的・背景**：App Routerのパラレルルート機能では、複数のスロット（`@slot`ディレクトリ）を使って同一レイアウト内に複数のページを並列表示できる。しかし、あるナビゲーション先で特定のスロットに対応するページが存在しない場合、そのスロットに何を表示すべきかが問題となる。この画面は、そのような未定義スロットに対して`notFound()`を呼び出し、404エラーを発生させることで、開発者に明示的な`default.tsx`の作成を促す役割を果たす。

**画面へのアクセス方法**：この画面はユーザーが直接アクセスするものではなく、App Routerのパラレルルートで対応する`default.tsx`がユーザープロジェクト内に存在しない場合に、Next.jsフレームワークが内部的にこのコンポーネントを使用する。ビルド時にパラレルルートスロットのデフォルトファイルとして自動的に組み込まれる。

**主要な操作・処理内容**：
1. コンポーネントがレンダリングされると、即座に`notFound()`関数を呼び出す
2. `notFound()`は`NEXT_HTTP_ERROR_FALLBACK;404`というdigestを持つエラーをスローする
3. このエラーはApp Routerのエラーバウンダリによってキャッチされ、404ページが表示される

**画面遷移**：
- 遷移元: App Routerのパラレルルート機構（未定義スロットのレンダリング時）
- 遷移先: Not Found画面（404ページ）が表示される

**権限による表示制御**：権限による表示制御はない。パラレルルートのスロットに対応するページが存在しない場合に一律で動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | 並列ルート（Parallel Routes） | 主機能 | パラレルルートで明示的なdefault.tsxが未定義の場合のフォールバック処理（notFound呼び出し） |
| 13 | App Router | 補助機能 | App Routerのパラレルルート機構での未定義スロット処理 |

## 画面種別

エラーフォールバック（フレームワーク内部コンポーネント）

## URL/ルーティング

固有のURLは持たない。パラレルルートの`@slot`ディレクトリ内に`default.tsx`が存在しない場合に、`next/dist/client/components/builtin/default.js`がフォールバックとして使用される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| なし | - | - | 本コンポーネントはPropsを受け取らない |

## 表示項目

本コンポーネント自体は表示要素を持たない。`notFound()`を呼び出すことでエラーをスローし、上位のエラーバウンダリによってNot Found画面が表示される。

| 表示項目 | 説明 |
|----------|------|
| （Not Found画面に委譲） | 404エラーメッセージが上位コンポーネントにより表示される |

## イベント仕様

### 1-コンポーネントレンダリング

コンポーネントが描画されると即座に`notFound()`関数が呼び出され、HTTPAccessFallbackErrorがスローされる。このエラーはApp RouterのError Boundary機構によりキャッチされ、Not Found画面（404ページ）の表示に繋がる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベース操作は発生しない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー（内部） | `NEXT_HTTP_ERROR_FALLBACK;404` | コンポーネントレンダリング時（notFound()呼び出し時のdigest） |

## 例外処理

本コンポーネントの唯一の動作が例外（`notFound()`）のスローである。スローされたHTTPAccessFallbackErrorは、App RouterのHTTPアクセスエラーフォールバック機構によって処理され、ユーザーに404ページが表示される。

## 備考

- 本コンポーネントはNext.jsフレームワーク内部のビルトインコンポーネントであり、ユーザーが直接操作するものではない
- パスは`PARALLEL_ROUTE_DEFAULT_PATH`定数として`next/dist/client/components/builtin/default.js`にエクスポートされている
- ユーザーがパラレルルートのスロットにカスタム`default.tsx`を作成することで、このフォールバック動作を上書きできる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、`notFound()`がスローするエラーの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | not-found.ts | `packages/next/src/client/components/not-found.ts` | `notFound()`関数の実装。`NEXT_HTTP_ERROR_FALLBACK;404`というdigestを持つHTTPAccessFallbackErrorをスローする仕組み |
| 1-2 | http-access-fallback.ts | `packages/next/src/client/components/http-access-fallback/http-access-fallback.ts` | HTTPAccessFallbackError型とHTTP_ERROR_FALLBACK_ERROR_CODEの定義 |

**読解のコツ**: `notFound()`はReactコンポーネントのレンダリング中にスローされるエラーであり、Reactのエラーバウンダリ機構で捕捉される。digestプロパティがステータスコード判定に使用される。

#### Step 2: エントリーポイントを理解する

本コンポーネント自体が極めてシンプルなエントリーポイントである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | default.tsx | `packages/next/src/client/components/builtin/default.tsx` | パラレルルートデフォルトコンポーネント本体。`notFound()`をインポートして呼び出すだけの8行のファイル |

**主要処理フロー**:
1. **行1**: `notFound`関数を`../not-found`からインポート
2. **行3-4**: `PARALLEL_ROUTE_DEFAULT_PATH`定数をエクスポート（ビルド時のファイルパス解決に使用）
3. **行6-8**: `ParallelRouteDefault`コンポーネントが`notFound()`を呼び出し

#### Step 3: エラーハンドリング機構を理解する

スローされたエラーがどのように処理されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | not-found-boundary.tsx | `packages/next/src/client/components/http-access-fallback/error-boundary.tsx` | HTTPアクセスエラーバウンダリの実装。digestからステータスコードを判定し、対応するフォールバックUIを表示する |

**主要処理フロー**:
- digestの`404`部分が解析され、Not Foundフォールバックコンポーネントが表示される

### プログラム呼び出し階層図

```
ParallelRouteDefault (default.tsx)
    |
    +-- notFound() (not-found.ts)
           |
           +-- new Error(DIGEST) => HTTPAccessFallbackError
                  |
                  +-- [throw] => React Error Boundary
                         |
                         +-- HTTPAccessErrorFallback (Not Found画面表示)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

パラレルルートスロット  --> ParallelRouteDefault()      --> notFound()がエラーをスロー
（default未定義）            (builtin/default.tsx)          |
                                                           v
                                                      Error Boundary
                                                      (digest解析)
                                                           |
                                                           v
                                                      404 Not Foundページ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| default.tsx | `packages/next/src/client/components/builtin/default.tsx` | ソース | パラレルルートデフォルトコンポーネント本体 |
| not-found.ts | `packages/next/src/client/components/not-found.ts` | ソース | notFound()関数の実装 |
| http-access-fallback.ts | `packages/next/src/client/components/http-access-fallback/http-access-fallback.ts` | ソース | HTTPAccessFallbackError型定義 |
| not-found.tsx | `packages/next/src/client/components/builtin/not-found.tsx` | ソース | Not Foundフォールバック表示コンポーネント |
