# 画面設計書 12-開発オーバーレイ (Dev Overlay)

## 概要

本ドキュメントは、Next.js開発モード時にアプリケーション上に表示される統合開発支援オーバーレイの画面設計書である。エラー表示、DevToolsインジケーター、パネルルーターを含む開発ツールの最上位コンテナとして機能する。

### 本画面の処理概要

開発オーバーレイは、`next dev`による開発サーバー実行時にのみ表示される統合開発支援UIである。Shadow DOMを利用してアプリケーションのスタイルに影響を与えずに描画され、エラー情報の表示やDevTools機能へのアクセスポイントを提供する。

**業務上の目的・背景**：開発者が効率的にデバッグ・開発を行うために、ビルドエラーやランタイムエラーをリアルタイムで表示し、さらにルート情報やセグメント構造の確認、ユーザー設定の変更などの開発支援機能を一元的に提供する。本画面はフレームワーク側が自動的に注入するもので、ユーザーのアプリケーションコードに変更を加えることなく開発体験を向上させる。

**画面へのアクセス方法**：`next dev`コマンドで開発サーバーを起動すると自動的に表示される。`state.showIndicator`がtrueの場合にUI要素が描画される。

**主要な操作・処理内容**：
1. ShadowPortalを使用してShadow DOM内にUIを描画する
2. ScaleUpdaterでDevToolsのスケール設定を適用する
3. ComponentStylesでオーバーレイ用のスタイルを注入する
4. RenderErrorでランタイムエラーの収集・整理を行う
5. ErrorOverlayでビルドエラー/ランタイムエラーのオーバーレイ表示を制御する
6. PanelRouterで各種パネル（メニュー、設定、ルート情報等）の表示切替を管理する
7. DevToolsIndicatorで画面隅にフローティングボタンを表示する

**画面遷移**：
- DevToolsインジケーター（常時表示）
- コンパイルエラー発生時 -> ビルドエラー画面
- ランタイムエラー発生時 -> ランタイムエラー画面
- インジケータークリック -> DevToolsメニュー

**権限による表示制御**：開発モード（`next dev`）でのみ表示される。本番ビルドでは含まれない。`devIndicators: false`をnext.configに設定するとインジケーターを無効化できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | DevTools（開発者ツール） | 主機能 | 開発モード時のエラー表示・DevToolsインジケーター・パネルルーターを含む統合開発支援UIの表示 |
| 95 | エラーオーバーレイ | 補助機能 | ErrorOverlayコンポーネントによるエラー情報のオーバーレイ表示 |
| 1 | next dev | 補助機能 | 開発サーバー実行時にのみ表示されるオーバーレイUI |

## 画面種別

オーバーレイ（開発ツールコンテナ）

## URL/ルーティング

固有のURLは持たない。開発モードの全ページに自動的にオーバーレイされる。

## 入出力項目

本コンポーネントは外部からPropsを受け取らず、`useDevOverlayContext()`フックを通じてOverlayStateを取得する。

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| state | Context入力 | OverlayState | ビルドエラー、ランタイムエラー、表示設定等の状態 |
| dispatch | Context入力 | OverlayDispatch | 状態変更用ディスパッチ関数 |
| getSquashedHydrationErrorDetails | Context入力 | Function | ハイドレーションエラーの詳細取得関数 |

## 表示項目

| 表示項目 | コンポーネント | 説明 |
|----------|---------------|------|
| DevToolsインジケーター | DevToolsIndicator | 画面隅のNext.jsロゴボタン |
| エラーオーバーレイ | ErrorOverlay | ビルドエラー/ランタイムエラーの表示 |
| パネルルーター | PanelRouter | メニュー・設定パネル等の表示切替 |
| スケール更新 | ScaleUpdater | DevToolsスケール設定の適用（非可視） |
| コンポーネントスタイル | ComponentStyles | スタイル注入（非可視） |

## イベント仕様

### 1-state.showIndicator変更

`state.showIndicator`がtrueになると、DevToolsインジケーター、PanelRouter、ErrorOverlayが描画される。falseの場合は何も描画しない。

### 2-ビルドエラー発生

`state.buildError`がnull以外になると、ErrorOverlayコンポーネントがBuildErrorを表示する。

### 3-ランタイムエラー発生

RenderErrorコンポーネントがエラーリストを管理し、ErrorOverlayでランタイムエラー画面を表示する。

### 4-パネル表示切替

PanelRouterContextを通じて`panel`状態を管理し、'panel-selector'、'route-type'、'segment-explorer'、'preferences'の各パネルを表示切替する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベース操作は発生しない |

## メッセージ仕様

本コンポーネント自体はメッセージを表示しないが、子コンポーネント（ErrorOverlay等）がエラーメッセージを表示する。

## 例外処理

- `state.showIndicator`がfalseの場合、UI要素は描画されない
- エラー情報はRenderErrorコンポーネントで収集・管理され、ErrorOverlayで表示される

## 備考

- Shadow DOMを使用して描画されるため、ユーザーアプリケーションのCSSと干渉しない
- `RenderErrorContext`によりランタイムエラー情報が子コンポーネントに共有される
- `PanelRouterContext`によりパネル状態（現在表示中のパネル、選択インデックス、トリガーRef）が管理される
- `selectedIndex`はDevToolsメニューのキーボードナビゲーション用の状態

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | OverlayState型（行44-73）: ビルドエラー、ランタイムエラー、表示フラグ、DevTools設定等の全状態定義。DispatcherEvent型（行219-243）: 状態変更アクションの種類 |
| 1-2 | context.tsx | `packages/next/src/next-devtools/dev-overlay/menu/context.tsx` | PanelStateKind型（行8-12）: 表示可能なパネルの種類。PanelRouterContext: パネル状態の共有用コンテキスト |

**読解のコツ**: OverlayStateが巨大であるが、開発オーバーレイの表示制御に直接関わるのは`showIndicator`、`buildError`、`errors`、`isErrorOverlayOpen`などのフィールドである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dev-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` | DevOverlay関数コンポーネント（行20-71）: panelとselectedIndexのローカル状態、useDevOverlayContextからのstate/dispatch取得、ShadowPortal内のコンポーネント構成 |

**主要処理フロー**:
1. **行21**: パネル表示状態`panel`をuseStateで管理（初期値null）
2. **行22**: メニュー選択インデックス`selectedIndex`をuseStateで管理
3. **行23-24**: `useDevOverlayContext()`からstate、dispatch、getSquashedHydrationErrorDetailsを取得
4. **行28-69**: ShadowPortal内にScaleUpdater、ComponentStyles、RenderError（子にErrorOverlay、PanelRouter、DevToolsIndicator）を描画
5. **行36**: `state.showIndicator`がtrueの場合のみUI要素を描画

#### Step 3: Shadow DOMポータルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | shadow-portal.tsx | `packages/next/src/next-devtools/dev-overlay/components/shadow-portal.tsx` | Shadow DOMを作成し、その内部にReactコンポーネントをポータルレンダリングする仕組み |

#### Step 4: エラー収集・表示層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | render-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/runtime-error/render-error.tsx` | ランタイムエラーを収集・整理し、子コンポーネントに`runtimeErrors`と`totalErrorCount`を渡すrender props |
| 4-2 | error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ビルドエラーがあればBuildError、ランタイムエラーがあればErrorsコンポーネントを表示する分岐ロジック（行52-86） |

### プログラム呼び出し階層図

```
DevOverlay (dev-overlay.tsx)
    |
    +-- ShadowPortal
    |      +-- ScaleUpdater
    |      +-- ComponentStyles
    |      +-- RenderError
    |             |
    |             +-- RenderErrorContext.Provider
    |             |      +-- PanelRouterContext.Provider
    |             |             +-- ErrorOverlay
    |             |             |      +-- BuildError (ビルドエラー時)
    |             |             |      +-- Errors (ランタイムエラー時)
    |             |             +-- PanelRouter
    |             |             |      +-- MenuPanel
    |             |             |      +-- DynamicPanel (各種パネル)
    |             |             +-- DevToolsIndicator
    |             |                    +-- Draggable
    |             |                    +-- NextLogo
```

### データフロー図

```
[入力]                        [処理]                           [出力]

useDevOverlayContext()   --> DevOverlay                   --> Shadow DOM内UI
  - state                     |                               |
  - dispatch                  +-- RenderError              +-- DevToolsIndicator
  - getSquashed...            |   (エラー収集)                  (フローティングボタン)
                              |                               |
                              +-- ErrorOverlay             +-- ErrorOverlay
                              |   (エラー表示判定)              (エラーダイアログ)
                              |                               |
                              +-- PanelRouter              +-- PanelRouter
                                  (パネル切替)                  (メニュー/設定パネル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dev-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` | ソース | 開発オーバーレイ本体コンポーネント |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | OverlayState型、アクション定数、リデューサ定義 |
| context.tsx | `packages/next/src/next-devtools/dev-overlay/menu/context.tsx` | ソース | PanelRouterContext定義 |
| dev-overlay.browser.ts | `packages/next/src/next-devtools/dev-overlay.browser.ts` | ソース | useDevOverlayContextフック提供 |
| shadow-portal.tsx | `packages/next/src/next-devtools/dev-overlay/components/shadow-portal.tsx` | ソース | Shadow DOMポータルコンポーネント |
| error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ソース | エラーオーバーレイ表示制御 |
| render-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/runtime-error/render-error.tsx` | ソース | ランタイムエラー収集・整理 |
| panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | ソース | パネルルーター（各種パネルの切替制御） |
| devtools-indicator.tsx | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` | ソース | DevToolsインジケーター（フローティングボタン） |
| component-styles.tsx | `packages/next/src/next-devtools/dev-overlay/styles/component-styles.tsx` | ソース | オーバーレイ用スタイル注入 |
| scale-updater.tsx | `packages/next/src/next-devtools/dev-overlay/styles/scale-updater.tsx` | ソース | DevToolsスケール設定適用 |
