# 画面設計書 13-DevToolsインジケーター

## 概要

本ドキュメントは、Next.js開発モード時に画面隅に常時表示されるNext.jsロゴのフローティングボタン（DevToolsインジケーター）の画面設計書である。

### 本画面の処理概要

DevToolsインジケーターは、開発モード時に画面の四隅のいずれかに表示される小さなNext.jsロゴボタンである。クリックするとDevToolsメニューの開閉を行い、ドラッグ操作で四隅のいずれかに移動できる。

**業務上の目的・背景**：開発者がNext.jsの開発ツールに素早くアクセスできるよう、常時表示されるエントリーポイントを提供する。アプリケーションの表示を邪魔しないよう最小限のサイズで設計されており、不要な場合はドラッグで位置変更したり、設定画面から非表示にしたりできる。

**画面へのアクセス方法**：`next dev`コマンドで開発サーバーを起動すると自動的に表示される。開発オーバーレイ（DevOverlay）の子コンポーネントとして描画される。

**主要な操作・処理内容**：
1. Next.jsロゴボタンの表示
2. クリックでDevToolsメニュー（panel-selector）の開閉トグル
3. ドラッグ操作で画面四隅への移動（top-left / top-right / bottom-left / bottom-right）
4. 位置変更時にdevToolsPositionの状態更新と設定の永続化
5. パネルが開いている間はドラッグを無効化

**画面遷移**：
- クリック -> DevToolsメニュー（panel-selector）表示
- DevToolsメニューからクリック/Escape -> インジケーターのみ表示に戻る

**権限による表示制御**：開発モード（`next dev`）でのみ表示。`devIndicators: false`をnext.configに設定すると非表示。ユーザーが設定画面から一時的に非表示にすることも可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | DevTools（開発者ツール） | 主機能 | 画面隅のフローティングNext.jsロゴボタンの表示・ドラッグ移動処理 |
| 1 | next dev | 補助機能 | 開発サーバー実行時にのみ表示 |

## 画面種別

フローティングボタン（インジケーター）

## URL/ルーティング

固有のURLは持たない。開発モードの全ページに自動的に表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| state.devToolsPosition | Context入力 | DevToolsIndicatorPosition | インジケーターの表示位置（'top-left' / 'top-right' / 'bottom-left' / 'bottom-right'） |
| panel | Context入力 | PanelStateKind \| null | 現在表示中のパネル |
| dispatch | Context入力 | OverlayDispatch | 状態変更用ディスパッチ関数 |

## 表示項目

| 表示項目 | コンポーネント | 説明 |
|----------|---------------|------|
| Next.jsロゴボタン | NextLogo | クリックでメニュー開閉するロゴボタン |
| Toastコンテナ | Toast | インジケーター全体のポジショニング用コンテナ |
| ドラッグ機能 | Draggable | 四隅へのドラッグ移動機能 |

## イベント仕様

### 1-ロゴクリック

NextLogoの`onTriggerClick`ハンドラが発火し、`panel`状態をトグルする。
- panelが'panel-selector'の場合 -> nullに設定（メニューを閉じる）、selectedIndexを-1にリセット
- panelがそれ以外の場合 -> 'panel-selector'に設定（メニューを開く）

### 2-ドラッグ移動

Draggableコンポーネントの`setPosition`コールバックで以下を実行：
1. `ACTION_DEVTOOLS_POSITION`をディスパッチして位置状態を更新
2. `saveDevToolsConfig`で位置設定をlocalStorageに永続化
3. `updateAllPanelPositions`で全パネルの位置を同期

### 3-パネルオープン中のドラッグ無効化

`panel !== null`の場合、Draggableの`disableDrag`がtrueとなり、ロゴとパネルの位置がずれることを防止する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ドラッグ移動 | localStorage | WRITE | DevTools位置設定の永続化（saveDevToolsConfig経由） |

## メッセージ仕様

本コンポーネントはメッセージを表示しない。

## 例外処理

- `state.showIndicator`がfalseの場合、親コンポーネント（DevOverlay）によりインジケーターは描画されない
- `state.disableDevIndicator`がtrueの場合、非表示状態となる

## 備考

- INDICATOR_PADDINGは20pxで固定（画面端からの余白）
- アニメーション設定は`MENU_DURATION_MS`と`MENU_CURVE`で制御
- `useUpdateAllPanelPositions`フックにより、インジケーターの位置変更時に全パネルの位置も同期される
- ドラッグ無効化はパネル表示中のUXのずれ防止が目的

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | DevToolsIndicatorPosition型（行24-25）: 四隅の位置を表す型。DevToolsConfig型（行11-22）: 永続化される設定。ACTION_DEVTOOLS_POSITION, ACTION_DEVTOOLS_PANEL_POSITION定数 |
| 1-2 | context.tsx | `packages/next/src/next-devtools/dev-overlay/menu/context.tsx` | PanelStateKind型とPanelRouterContext: メニュー表示状態の管理 |

**読解のコツ**: `Corners`型と`DevToolsIndicatorPosition`は同一の型エイリアスである。位置文字列は`split('-', 2)`で垂直方向と水平方向に分割される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | devtools-indicator.tsx | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` | DevToolsIndicator関数コンポーネント（行23-72）: state/dispatchの取得、位置計算、Toast/Draggable/NextLogoの構成 |

**主要処理フロー**:
1. **行24**: `useDevOverlayContext()`からstate, dispatchを取得
2. **行25**: `usePanelRouterContext()`からpanel, setPanel, setSelectedIndexを取得
3. **行26**: `useUpdateAllPanelPositions()`フックを取得
4. **行27**: devToolsPositionを垂直・水平に分割
5. **行31-42**: Toastコンポーネントで位置決めスタイルを適用
6. **行44-57**: DraggableでsetPosition時にdispatch、saveDevToolsConfig、updateAllPanelPositionsを実行
7. **行59-68**: NextLogoのonTriggerClickでパネル開閉トグル

#### Step 3: ドラッグ機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | draggable.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/draggable.tsx` | Draggableコンポーネント: マウス/タッチイベントによるドラッグ処理と四隅へのスナップロジック |

#### Step 4: パネル位置同期を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | devtools-indicator.tsx | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` | useUpdateAllPanelPositions関数（行81-112）: 全パネルの位置を一括同期するロジック。STORE_KEY_SHARED_PANEL_LOCATIONとSTORAGE_KEY_PANEL_POSITION_PREFIXで始まるキーを対象に更新 |

### プログラム呼び出し階層図

```
DevToolsIndicator (devtools-indicator.tsx)
    |
    +-- useDevOverlayContext() -> state, dispatch
    +-- usePanelRouterContext() -> panel, setPanel, setSelectedIndex
    +-- useUpdateAllPanelPositions() -> updateAllPanelPositions
    |
    +-- Toast (位置決め)
           +-- Draggable (ドラッグ機能)
                  |
                  +-- setPosition callback
                  |      +-- dispatch(ACTION_DEVTOOLS_POSITION)
                  |      +-- saveDevToolsConfig()
                  |      +-- updateAllPanelPositions()
                  |             +-- dispatch(ACTION_DEVTOOLS_PANEL_POSITION) x N
                  |             +-- saveDevToolsConfig()
                  |
                  +-- NextLogo (ロゴボタン)
                         +-- onTriggerClick
                                +-- setPanel('panel-selector' | null)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

state.devToolsPosition  --> DevToolsIndicator           --> Toast位置スタイル
                              |                               |
ロゴクリック             --> onTriggerClick              --> setPanel(トグル)
                              |                               -> メニュー表示/非表示
                              |
ドラッグ移動             --> Draggable.setPosition       --> dispatch(POSITION)
                              |                           --> saveDevToolsConfig
                              |                           --> updateAllPanelPositions
                              |                               -> 全パネル位置同期
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| devtools-indicator.tsx | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` | ソース | DevToolsインジケーター本体 |
| devtools-indicator.css | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.css` | スタイル | インジケーターのCSS |
| next-logo.tsx | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/next-logo.tsx` | ソース | Next.jsロゴボタンコンポーネント |
| draggable.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/draggable.tsx` | ソース | ドラッグ移動コンポーネント |
| toast.tsx | `packages/next/src/next-devtools/dev-overlay/components/toast.tsx` | ソース | Toastコンテナコンポーネント |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | 状態型・アクション定数定義 |
| save-devtools-config.ts | `packages/next/src/next-devtools/dev-overlay/utils/save-devtools-config.ts` | ソース | DevTools設定のlocalStorage永続化 |
| utils.ts | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/utils.ts` | ソース | MENU_DURATION_MS, MENU_CURVE等のアニメーション定数 |
