# 画面設計書 14-DevToolsメニュー (Panel Selector)

## 概要

本ドキュメントは、Next.js開発モード時にDevToolsインジケーターをクリックすると表示されるメニューパネルの画面設計書である。Issues数、ルート種別（Static/Dynamic）、バンドラー情報、Route Info、Preferencesへのリンクを表示する。

### 本画面の処理概要

DevToolsメニューは、開発者がNext.jsの開発ツール機能に素早くアクセスするためのメニューパネルである。DevToolsインジケーター（Next.jsロゴ）をクリックすると表示され、各種情報の確認や他のパネルへのナビゲーションを提供する。

**業務上の目的・背景**：開発者がルートの種類（Static/Dynamic）、使用中のバンドラー（Turbopack/Webpack）、発生中のエラー数などの重要な開発情報を一箇所で確認できるようにする。また、詳細なルート情報パネルやユーザー設定パネルへの導線を提供する。

**画面へのアクセス方法**：DevToolsインジケーター（Next.jsロゴ）をクリックするとメニューが表示される。メニュー外クリックまたはEscapeキーでメニューが閉じる。

**主要な操作・処理内容**：
1. Issuesの件数表示と、クリックでエラーオーバーレイの表示/非表示トグル
2. 現在のルートがStatic/Dynamicかの表示と、クリックでRoute Typeパネルへの遷移
3. 使用中のバンドラー情報（Turbopack or Webpack/other）の表示
4. Cache Components有効時の情報表示
5. App Router使用時のRoute Infoへのリンク（セグメントエクスプローラーへの遷移）
6. Preferencesへのリンク（ユーザー設定パネルへの遷移）
7. キーボードナビゲーション（上下矢印、Home/End、Ctrl+N/P）

**画面遷移**：
- 遷移元: DevToolsインジケーターのクリック
- Issuesクリック -> エラーオーバーレイ表示（ACTION_ERROR_OVERLAY_OPEN）
- Routeクリック -> Route Typeパネル（'route-type'）
- Route Infoクリック -> セグメントエクスプローラー（'segment-explorer'）
- Preferencesクリック -> ユーザー設定パネル（'preferences'）
- 外部クリック/Escape -> メニューを閉じてインジケーターに戻る

**権限による表示制御**：App Router使用時のみRoute Info項目が表示される（`isAppRouter`フラグで制御）。Turbopack有効時はバンドラー情報が"Turbopack"と表示される。`staticIndicator`が'disabled'の場合、Routeメニュー項目は表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | DevTools（開発者ツール） | 主機能 | Issues数・ルート種別・バンドラー情報・Route Info・Preferencesへのリンクを表示するメニュー |
| 95 | エラーオーバーレイ | 遷移先機能 | Issuesクリック時にエラーオーバーレイを表示 |
| 87 | Turbopack統合 | 補助機能 | Turbopack有効時のバンドラー情報表示 |

## 画面種別

メニューパネル（ポップオーバー）

## URL/ルーティング

固有のURLは持たない。PanelRouterの`panel`状態が'panel-selector'の場合に表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| totalErrorCount | Context入力 | number | 現在のエラー総数（RenderErrorContextから取得） |
| state.staticIndicator | Context入力 | 'pending' \| 'static' \| 'dynamic' \| 'disabled' | ルートのStatic/Dynamic状態 |
| state.routerType | Context入力 | 'pages' \| 'app' | 使用中のルータータイプ |
| state.isErrorOverlayOpen | Context入力 | boolean | エラーオーバーレイの開閉状態 |
| process.env.TURBOPACK | 環境変数 | boolean | Turbopack有効フラグ |
| process.env.__NEXT_CACHE_COMPONENTS | 環境変数 | boolean | Cache Components有効フラグ |

## 表示項目

| 表示項目 | 表示条件 | 値 | 説明 |
|----------|----------|-----|------|
| Issues | totalErrorCount > 0 | `{count} issue(s) found...` | エラー件数とインジケーター |
| Route | staticIndicator !== 'disabled' | 'Static' / 'Dynamic' / LoadingIcon | ルートの種別 |
| Bundler | 常時表示 | 'Turbopack' / リンク | バンドラー情報 |
| Cache Components | __NEXT_CACHE_COMPONENTS === true | 'Enabled' | キャッシュコンポーネント状態 |
| Route Info | isAppRouter === true | ChevronRightアイコン | セグメントエクスプローラーへのリンク |
| Preferences | 常時表示 | GearIconアイコン | 設定パネルへのリンク（フッターに配置） |

## イベント仕様

### 1-Issuesクリック

エラーオーバーレイの表示をトグルする。
- `state.isErrorOverlayOpen`がtrueの場合: `ACTION_ERROR_OVERLAY_CLOSE`をディスパッチしてメニューを閉じる
- `totalErrorCount > 0`かつオーバーレイが閉じている場合: メニューを閉じ、`ACTION_ERROR_OVERLAY_OPEN`をディスパッチ

### 2-Routeクリック

`setPanel('route-type')`を呼び出し、Route Typeパネルへ遷移する。staticIndicatorが'pending'または'disabled'の場合はクリック不可。

### 3-Route Infoクリック

`setPanel('segment-explorer')`を呼び出し、セグメントエクスプローラーパネルへ遷移する。App Router使用時のみ表示。

### 4-Preferencesクリック

`setPanel('preferences')`を呼び出し、ユーザー設定パネルへ遷移する。

### 5-Bundlerリンククリック（Webpack時）

Turbopack無効時、バンドラー情報はTurbopackドキュメントページへのリンクとして表示される。クリックで外部リンクが新しいタブに開く。

### 6-外部クリック/Escapeキー

`useClickOutsideAndEscape`フックにより、メニュー外のクリックまたはEscapeキーでメニューを閉じる（`setPanel(null)`）。

### 7-キーボードナビゲーション

DevtoolMenuの`onMenuKeydown`で以下のキー操作をサポート：
- ArrowDown: 次のメニュー項目を選択
- ArrowUp: 前のメニュー項目を選択
- Home: 最初のメニュー項目を選択
- End: 最後のメニュー項目を選択
- Ctrl+N: 次のメニュー項目を選択
- Ctrl+P: 前のメニュー項目を選択
- Enter/Space: 選択中のメニュー項目を実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベース操作は発生しない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | `{count} issue(s) found. Click to view details in the dev overlay.` | Issues項目のtitle属性 |
| 情報 | `Current route is {static/dynamic}.` | Route項目のtitle属性 |
| 情報 | `Turbopack is enabled.` | Turbopack有効時のBundler項目title属性 |
| 情報 | `Learn about Turbopack and how to enable it...` | Turbopack無効時のBundler項目title属性 |
| 情報 | `Loading...` | Route情報ロード中のtitle属性 |

## 例外処理

- `staticIndicator`が'pending'の場合、LoadingIconを表示しクリック不可
- `staticIndicator`が'disabled'の場合、Route項目自体を表示しない
- `totalErrorCount`が0の場合、Issues項目を表示しない
- `isAppRouter`がfalseの場合、Route Info項目を表示しない

## 備考

- メニュー表示時にDOMフォーカスを自動設定し、キーボード操作を即座に受け付ける
- メニューの位置はDevToolsインジケーターの位置に連動する
- `useDelayedRender`フックによるアニメーション制御（exitDelay: MENU_DURATION_MS）
- メニュー項目のインデックスはクリック可能な項目のみでカウントされる（getAdjustedIndex）
- フッターセクション（Preferences）は他の項目と視覚的に分離される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | OverlayState型のstaticIndicator, routerType, isErrorOverlayOpenフィールド。ACTION_ERROR_OVERLAY_OPEN/CLOSE定数 |
| 1-2 | context.tsx | `packages/next/src/next-devtools/dev-overlay/menu/context.tsx` | PanelStateKind型: 'preferences' / 'route-type' / 'segment-explorer' / 'panel-selector' |

#### Step 2: メニュー項目定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | MenuPanelコンポーネント（行33-127）: DevtoolMenuに渡すitems配列の構成。Issues/Route/Bundler/Cache Components/Route Info/Preferencesの各項目定義 |

**主要処理フロー**:
1. **行36**: `useRenderErrorContext()`から`totalErrorCount`を取得
2. **行37**: `state.routerType === 'app'`でApp Router判定
3. **行42-62**: Issues項目 - エラーオーバーレイの開閉トグルロジック
4. **行63-80**: Route項目 - staticIndicatorに応じた表示分岐
5. **行81-101**: Bundler項目 - TURBOPACK環境変数による分岐
6. **行107-113**: Route Info項目 - App Router時のみ表示
7. **行115-123**: Preferences項目 - 常時表示、フッター配置

#### Step 3: メニューUI実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dev-overlay-menu.tsx | `packages/next/src/next-devtools/dev-overlay/menu/dev-overlay-menu.tsx` | DevtoolMenuコンポーネント（行85-292）: メニューのレイアウト、キーボードナビゲーション、位置計算。MenuItem（行26-83）: 個別メニュー項目のレンダリング。useClickOutsideAndEscape（行113-137）: メニュー外クリック・Escape処理 |

**主要処理フロー**:
- **行146-149**: useLayoutEffectでメニューにフォーカスを設定
- **行173-212**: onMenuKeydownでキーボードナビゲーション（ArrowUp/Down, Home/End, Ctrl+N/P）
- **行215-291**: メニューDOMのレンダリング（固定位置、z-index最前面）

### プログラム呼び出し階層図

```
PanelRouter (panel-router.tsx)
    |
    +-- PanelRoute name="panel-selector"
           +-- MenuPanel
                  +-- DevtoolMenu (dev-overlay-menu.tsx)
                         |
                         +-- MenuItem "Issues"
                         |      +-- onClick: ERROR_OVERLAY_OPEN/CLOSE
                         |
                         +-- MenuItem "Route"
                         |      +-- onClick: setPanel('route-type')
                         |
                         +-- MenuItem "Bundler"
                         |      +-- (Turbopack info / link)
                         |
                         +-- MenuItem "Route Info" (App Router only)
                         |      +-- onClick: setPanel('segment-explorer')
                         |
                         +-- MenuItem "Preferences" (footer)
                                +-- onClick: setPanel('preferences')
```

### データフロー図

```
[入力]                        [処理]                           [出力]

totalErrorCount          --> MenuPanel                   --> Issues メニュー項目
state.staticIndicator    --> MenuPanel                   --> Route メニュー項目
state.routerType         --> MenuPanel                   --> Route Info 表示制御
process.env.TURBOPACK    --> MenuPanel                   --> Bundler メニュー項目
                              |
ユーザークリック          --> MenuItem.onClick            --> setPanel() / dispatch()
キーボード入力           --> onMenuKeydown               --> selectedIndex更新
外部クリック/Escape      --> useClickOutsideAndEscape    --> setPanel(null)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | ソース | PanelRouter、MenuPanel、PanelRoute定義 |
| dev-overlay-menu.tsx | `packages/next/src/next-devtools/dev-overlay/menu/dev-overlay-menu.tsx` | ソース | DevtoolMenu、MenuItem、IssueCount、ChevronRight |
| context.tsx | `packages/next/src/next-devtools/dev-overlay/menu/context.tsx` | ソース | PanelRouterContext、PanelStateKind型定義 |
| panel-router.css | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.css` | スタイル | パネルルーターのCSS |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | OverlayState、アクション定数 |
| loading-icon.tsx | `packages/next/src/next-devtools/dev-overlay/icons/loading-icon.tsx` | ソース | Route情報ロード中のアイコン |
| gear-icon.tsx | `packages/next/src/next-devtools/dev-overlay/icons/gear-icon.tsx` | ソース | Preferences項目のアイコン |
