# 画面設計書 15-ビルドエラー画面

## 概要

本ドキュメントは、Next.js開発モード時にコンパイルエラーが発生した際に表示されるオーバーレイ画面の設計書である。ターミナル風のエラー出力を表示し、エラー箇所のファイルパスと行番号を示す。

### 本画面の処理概要

ビルドエラー画面は、開発サーバーでソースコードのコンパイルが失敗した場合に自動的に表示されるフルスクリーンオーバーレイである。ターミナルスタイルのエラー出力でコンパイラ/バンドラーが検出した構文エラーなどの詳細を表示する。

**業務上の目的・背景**：開発者がコンパイルエラーの内容と発生箇所を迅速に特定し、修正できるようにする。ターミナルに切り替えることなくブラウザ上でエラー詳細を確認でき、開発サイクルを短縮する。エラーが解消されると自動的にオーバーレイが閉じる。

**画面へのアクセス方法**：開発サーバーでコンパイルエラーが発生すると自動的に表示される。`state.buildError`がnull以外の値（エラーメッセージ文字列）を持つと、ErrorOverlayコンポーネントがBuildErrorを描画する。

**主要な操作・処理内容**：
1. マルチラインのビルドエラーメッセージからエラーテキストを抽出（ファイルパス:行番号:列番号の後のエラーメッセージ）
2. `stripAnsi`でANSIエスケープコードを除去してプレーンテキスト化
3. ErrorOverlayLayoutでエラーオーバーレイのレイアウトを構成（"Build Error"ラベル付き）
4. Terminalコンポーネントでターミナル風のエラー出力を表示
5. generateErrorInfo関数でAI支援用のエラー情報を構造化

**画面遷移**：
- 遷移元: 開発オーバーレイ（コンパイルエラー発生時に自動表示）
- 遷移先: エラー解消時にオーバーレイが閉じ、DevToolsインジケーターのみの状態に戻る

**権限による表示制御**：開発モード（`next dev`）専用。ビルドエラーが存在する場合は他のエラー表示より優先して表示される（ErrorOverlayの行52-61で分岐）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | エラーオーバーレイ | 主機能 | コンパイルエラー発生時のターミナル風エラー出力表示処理 |
| 94 | DevTools（開発者ツール） | 補助機能 | DevToolsオーバーレイフレームワーク内でのビルドエラー表示 |
| 1 | next dev | 補助機能 | 開発サーバーでのコンパイル結果を受けてエラー表示 |

## 画面種別

エラーオーバーレイ（フルスクリーン）

## URL/ルーティング

固有のURLは持たない。`state.buildError`がnull以外の場合にErrorOverlay内で表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| message | Props入力 | string | マルチラインのビルドエラーメッセージ（ANSIエスケープコード含む） |
| rendered | Props入力 | boolean | オーバーレイの表示状態（ビルドエラーの場合は常にtrue） |
| transitionDurationMs | Props入力 | number | トランジション時間（ミリ秒） |
| isTurbopack | Props入力 | boolean | Turbopack使用フラグ |
| versionInfo | Props入力 | VersionInfo | Next.jsバージョン情報 |
| errorCount | Props入力 | number | エラー総数 |

## 表示項目

| 表示項目 | コンポーネント | 説明 |
|----------|---------------|------|
| エラータイプラベル | ErrorOverlayLayout | "Build Error"と表示 |
| エラーメッセージ | ErrorOverlayLayout | ANSIを除去したエラーの1行目（または"Failed to compile"） |
| ターミナル出力 | Terminal | マルチラインのビルドエラー出力をターミナルスタイルで表示 |
| AI支援情報生成ボタン | ErrorOverlayLayout | generateErrorInfoで構造化されたエラー情報を提供 |

## イベント仕様

### 1-コンポーネント描画

ビルドエラーメッセージを受け取り、以下を実行：
1. `getErrorTextFromBuildErrorMessage`でメッセージの2行目からエラーテキストを抽出
2. `stripAnsi`でANSIエスケープコードを除去
3. "Error: "プレフィックスを除去
4. 抽出されたテキスト（またはフォールバック"Failed to compile"）をerrorMessageとして表示
5. Terminalコンポーネントに元のmessage全体を渡して表示

### 2-generateErrorInfo呼び出し

AI支援機能用にエラー情報を構造化して返す：
1. Error Type: "Build Error"
2. Error Message: フォーマット済みメッセージ
3. Build Output: ANSI除去したビルド出力全体
4. Next.jsバージョンとバンドラー情報を付加

### 3-閉じる操作

`onClose`は`noop`（空関数）に設定されており、ビルドエラー画面はユーザーが手動で閉じることはできない。エラーが解消された場合に`state.buildError`がnullになり、自動的に非表示となる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベース操作は発生しない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラータイプ | "Build Error" | 常時表示 |
| エラーメッセージ | エラーの1行目からANSI除去・"Error: "除去したテキスト | メッセージが存在する場合 |
| フォールバック | "Failed to compile" | エラーテキストが抽出できない場合 |

## 例外処理

- エラーメッセージが空または解析できない場合、"Failed to compile"がフォールバックメッセージとして表示される
- `stripAnsi`でANSIエスケープコードの除去に失敗した場合の処理は内部ライブラリに委譲

## 備考

- ビルドエラーはランタイムエラーよりも優先して表示される（ErrorOverlayの行52-61）
- `rendered`プロパティはビルドエラーの場合は常にtrue（アニメーション状態に依存しない強制表示）
- ビルドエラーメッセージのフォーマットは `{ファイルパス}:{行番号}:{列番号}\n{エラーメッセージ}\n{コードフレーム}` の構造
- AI支援情報にはNext.jsバージョンとバンドラー名が含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | OverlayStateのbuildErrorフィールド（行47）: string \| null。ACTION_BUILD_OK/ACTION_BUILD_ERRORアクション |
| 1-2 | error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ErrorBaseProps型（行16-22）: ビルドエラー表示に必要なプロパティ定義 |

**読解のコツ**: `buildError`はstring型で、ANSIエスケープコードを含むマルチラインのコンパイラ出力がそのまま格納される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ErrorOverlayコンポーネント（行24-87）: buildError !== nullの場合にBuildErrorコンポーネントを表示する分岐（行52-61） |

**主要処理フロー**:
1. **行37**: isTurbopackフラグをprocess.env.TURBOPACKから取得
2. **行44-50**: commonPropsをまとめる
3. **行52-61**: buildError !== nullの場合、BuildErrorに`rendered`をtrue固定で渡して表示

#### Step 3: ビルドエラー表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` | BuildErrorコンポーネント（行29-77）: エラーメッセージの解析、ErrorOverlayLayout構成、Terminal表示 |

**主要処理フロー**:
1. **行11-27**: `getErrorTextFromBuildErrorMessage` - メッセージの2行目（lines[1]）からANSI除去、"Error: "プレフィックス除去
2. **行33**: onCloseはnoop（手動閉じ不可）
3. **行35-37**: formattedMessage = 抽出テキスト || 'Failed to compile'
4. **行40-63**: generateErrorInfo - AI支援用のエラー情報構造化
5. **行66-76**: ErrorOverlayLayout + Terminal で表示

### プログラム呼び出し階層図

```
ErrorOverlay (error-overlay.tsx)
    |
    +-- [buildError !== null の場合]
           +-- BuildError (build-error.tsx)
                  |
                  +-- getErrorTextFromBuildErrorMessage()
                  |      +-- stripAnsi()
                  |
                  +-- ErrorOverlayLayout
                  |      errorType="Build Error"
                  |      errorMessage={formattedMessage}
                  |      onClose={noop}
                  |      rendered={true} (強制表示)
                  |
                  +-- Terminal
                         content={message} (元のANSI付きメッセージ)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

state.buildError         --> ErrorOverlay判定            --> BuildErrorコンポーネント
(ANSIエスケープ付き          |                               |
 マルチラインメッセージ)      +-- getErrorText...         --> errorMessage
                              |  (2行目抽出+ANSI除去)        ("Build Error"ラベル付き)
                              |                               |
                              +-- Terminal                --> ターミナル風エラー出力
                                   (元のメッセージ表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` | ソース | BuildErrorコンポーネント本体 |
| error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ソース | エラーオーバーレイ表示制御（ビルドエラー優先分岐） |
| error-overlay-layout.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay-layout/error-overlay-layout.tsx` | ソース | エラーオーバーレイのレイアウトコンポーネント |
| terminal.tsx | `packages/next/src/next-devtools/dev-overlay/components/terminal.tsx` | ソース | ターミナルスタイルのエラー出力コンポーネント |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | ACTION_BUILD_ERROR、OverlayState定義 |
| strip-ansi (compiled) | `packages/next/src/compiled/strip-ansi` | ライブラリ | ANSIエスケープコード除去 |
