# 画面設計書 16-ランタイムエラー画面

## 概要

本ドキュメントは、Next.js開発モード時に実行時エラーが発生した際に表示されるオーバーレイ画面の設計書である。ハイドレーションエラー、ブロッキングルートエラー、一般的なランタイムエラーを種別に応じたUIで表示し、コードフレームとコールスタックを含む。

### 本画面の処理概要

ランタイムエラー画面は、開発モードでJavaScript実行時に発生したエラーを表示するオーバーレイ画面である。エラーの種類に応じて異なるUI（ハイドレーション差分、ブロッキングルートの解説、一般エラーメッセージ）を表示し、コードフレームとスタックトレースによりエラー発生箇所を特定できる。

**業務上の目的・背景**：開発中に発生する様々な種類のランタイムエラーを、その種類に応じた適切な形式で表示することで、開発者のデバッグ効率を向上させる。特にハイドレーションエラーではサーバー/クライアントの差分を視覚的に表示し、ブロッキングルートエラーでは具体的な修正方法を提案する。

**画面へのアクセス方法**：ランタイムエラーが発生すると自動的に表示される。DevToolsメニューの"Issues"クリックでも表示可能（ACTION_ERROR_OVERLAY_OPEN）。エラー間のページネーション機能でエラーを切り替えられる。

**主要な操作・処理内容**：
1. エラーの種類判定（ハイドレーション/ブロッキングルート/動的メタデータ/一般）
2. エラー種別に応じたエラーメッセージ・説明の表示
3. コードフレーム（ソースコードの該当箇所）の表示
4. スタックトレースの表示
5. 複数エラー間のページネーション
6. AI支援用エラー情報の構造化（generateErrorInfo）
7. サーバーエラーの場合は手動閉じ不可

**画面遷移**：
- 遷移元: 開発オーバーレイ（ランタイムエラー発生時）/ DevToolsメニューのIssuesクリック
- 遷移先: 閉じるボタンでDevToolsインジケーターのみ表示に戻る（サーバーエラー以外）

**権限による表示制御**：開発モード（`next dev`）専用。サーバーエラー（'server'/'edge-server'ソース）の場合は閉じるボタンが無効化される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | エラーオーバーレイ | 主機能 | ハイドレーションエラー・ブロッキングルートエラー・一般ランタイムエラーの種別に応じたUI表示処理 |
| 94 | DevTools（開発者ツール） | 補助機能 | DevToolsオーバーレイフレームワーク内でのランタイムエラー表示 |
| 1 | next dev | 補助機能 | 開発モード時のランタイムエラー検出と表示 |

## 画面種別

エラーオーバーレイ（フルスクリーン、ページネーション付き）

## URL/ルーティング

固有のURLは持たない。`state.isErrorOverlayOpen`がtrueかつランタイムエラーが存在する場合に表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| runtimeErrors | Props入力 | ReadyRuntimeError[] | 処理済みランタイムエラーの配列 |
| debugInfo | Props入力 | DebugInfo | デバッグ情報 |
| onClose | Props入力 | () => void | 閉じるコールバック（ACTION_ERROR_OVERLAY_CLOSE） |
| getSquashedHydrationErrorDetails | Props入力 | Function | ハイドレーションエラー詳細取得関数 |
| rendered | Props入力 | boolean | アニメーション表示状態 |
| versionInfo | Props入力 | VersionInfo | Next.jsバージョン情報 |

## 表示項目

| 表示項目 | 表示条件 | コンポーネント | 説明 |
|----------|----------|---------------|------|
| エラータイプラベル | 常時 | ErrorOverlayLayout | "Runtime Error"/"Recoverable Error"/"Console Error"/"Blocking Route"/"Ambiguous Metadata" |
| エラーメッセージ | 常時 | HydrationErrorDescription/GenericErrorDescription/BlockingPageLoadErrorDescription | エラー種別に応じた説明 |
| ハイドレーション差分 | ハイドレーションエラー時 | PseudoHtmlDiff | サーバー/クライアントのHTML差分表示 |
| ハイドレーションノート | ハイドレーションエラー時 | - | エラーに関する補足情報 |
| ブロッキングルート解説 | ブロッキングルートエラー時 | BlockingPageLoadErrorDescription | 修正方法の提案を含む詳細解説 |
| コードフレーム | 常時 | RuntimeError | エラー発生箇所のソースコード表示 |
| スタックトレース | 常時 | RuntimeError | コールスタック表示 |
| ページネーション | エラー2件以上 | ErrorOverlayLayout | エラー間の切り替えUI |

## イベント仕様

### 1-エラー種別判定

`useErrorDetails`フックでエラーの種別を判定する：
1. **ハイドレーションエラー**: `isHydrationError(error)`がtrueの場合。warningメッセージ、notes、reactOutputComponentDiffを抽出
2. **ブロッキングルートエラー**: エラーメッセージに`/blocking-route`が含まれる場合。variant（navigation/runtime）とrefinement（generateViewport等）を判定
3. **動的メタデータエラー**: エラーメッセージに`/next-prerender-dynamic-metadata`が含まれる場合
4. **一般エラー**: 上記に該当しない場合

### 2-ページネーション操作

`useActiveRuntimeError`フックでアクティブなエラーのインデックスを管理。`setActiveIndex`でエラーを切り替える。

### 3-閉じる操作

`onClose`コールバックで`ACTION_ERROR_OVERLAY_CLOSE`をディスパッチ。ただしサーバーエラー（'server'/'edge-server'）の場合はonCloseがundefinedとなり閉じるボタンが無効化される。

### 4-generateErrorInfo

AI支援用にエラー情報を構造化：
1. Error Type（エラータイプ）
2. Error Message（環境名プレフィックスを除去）
3. スタックトレース（ignoredでないフレームのみ）
4. Code Frame（ANSIを除去したコードフレーム）
5. Next.jsバージョンとバンドラー情報

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベース操作は発生しない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラータイプ | "Runtime {ErrorName}" | 一般的なランタイムエラー |
| エラータイプ | "Recoverable {ErrorName}" | 回復可能なエラー |
| エラータイプ | "Console {ErrorName}" | コンソールエラー |
| エラータイプ | "Blocking Route" | ブロッキングルートエラー |
| エラータイプ | "Ambiguous Metadata" | 動的メタデータエラー |
| 修正提案 | Suspenseの使用やuse cacheへの移動等 | ブロッキングルート/動的メタデータエラー時 |
| リンク | 各エラー種別のNext.jsドキュメントリンク | ブロッキングルート/動的メタデータエラー時 |

## 例外処理

- `isLoading`がtrueの場合、Overlay+OverlayBackdropのみ表示（ローディング状態）
- `activeError`がnullの場合、何も表示しない
- サーバーエラーの場合、閉じるボタンを無効化（ページリロードが必要）
- environmentNameが含まれるエラーの場合、表示メッセージからプレフィックスを除去

## 備考

- エラーの重複排除は`useErrorOverlayReducer`内の`pushErrorFilterDuplicates`で行われる
- ハイドレーションエラーのリンク先は`NEXTJS_HYDRATION_ERROR_LINK`
- ブロッキングルートエラーには'navigation'と'runtime'の2バリアントがあり、さらに'generateViewport'/'generateMetadata'のrefinementがある
- `useFrames`フックでエラーのスタックフレームをパース・解析する
- `firstFrame`は最初のユーザーコード（ignored=falseかつoriginalCodeFrame/originalStackFrame付き）のフレーム

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | OverlayStateのerrors, isErrorOverlayOpenフィールド。SupportedErrorEvent型参照 |
| 1-2 | errors.tsx | `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` | ErrorDetails型（行455-481）: 'empty'/'hydration'/'blocking-route'/'dynamic-metadata'の判別構造。ReadyRuntimeError型のtype: 'runtime'/'recoverable'/'console' |

**読解のコツ**: ErrorDetailsのtype判定がUIの分岐の鍵。`useErrorDetails`フックの返り値に基づいてswitch文で描画内容が変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ErrorOverlayコンポーネント（行24-87）: buildErrorがない場合、runtimeErrorsが存在しisErrorOverlayOpen時にErrorsコンポーネントを表示（行76-86） |

#### Step 3: ランタイムエラー表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | errors.tsx | `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` | Errorsコンポーネント（行584-788）: エラー種別判定、メッセージ表示分岐、ErrorOverlayLayout構成。useErrorDetails（行487-511）: エラー種別判定ロジック |

**主要処理フロー**:
1. **行593-601**: `useActiveRuntimeError`でアクティブエラーとインデックスを管理
2. **行604**: `useFrames`でスタックフレームをパース
3. **行606-615**: `firstFrame`でユーザーコードの最初のフレームを特定
4. **行701-760**: switch文でerrorDetails.typeに基づきメッセージコンポーネントを分岐
5. **行762-787**: ErrorOverlayLayoutにerrorType、errorMessage、pagination情報、RuntimeErrorを描画

#### Step 4: エラー種別判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | errors.tsx | `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` | getHydrationErrorDetails（行513-543）: ハイドレーションエラー判定。getBlockingRouteErrorDetails（行545-582）: blocking-route/dynamic-metadata/dynamic-viewport判定 |

### プログラム呼び出し階層図

```
ErrorOverlay (error-overlay.tsx)
    |
    +-- [runtimeErrors.length > 0 && isErrorOverlayOpen]
           +-- Errors (errors.tsx)
                  |
                  +-- useActiveRuntimeError()
                  |      +-- useErrorDetails()
                  |             +-- getHydrationErrorDetails()
                  |             +-- getBlockingRouteErrorDetails()
                  |
                  +-- useFrames() -> frames
                  +-- generateErrorInfo()
                  |
                  +-- ErrorOverlayLayout
                  |      +-- [hydration] HydrationErrorDescription + PseudoHtmlDiff
                  |      +-- [blocking-route] BlockingPageLoadErrorDescription
                  |      +-- [dynamic-metadata] DynamicMetadataErrorDescription
                  |      +-- [empty] GenericErrorDescription
                  |
                  +-- RuntimeError (コードフレーム+スタック)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

runtimeErrors            --> useActiveRuntimeError       --> activeError, activeIdx
                              |
activeError.error        --> useErrorDetails             --> ErrorDetails型
                              |                               (hydration/blocking/etc)
                              |
                         --> switch(errorDetails.type)   --> エラーメッセージUI
                              |
                         --> useFrames()                 --> コードフレーム
                         --> RuntimeError                --> スタックトレース
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| errors.tsx | `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` | ソース | Errorsコンポーネント本体、エラー種別判定 |
| error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ソース | エラーオーバーレイ表示制御 |
| error-overlay-layout.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay-layout/error-overlay-layout.tsx` | ソース | エラーオーバーレイレイアウト |
| runtime-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/runtime-error.tsx` | ソース | コードフレーム・スタックトレース表示 |
| component-stack-pseudo-html.tsx | `packages/next/src/next-devtools/dev-overlay/container/runtime-error/component-stack-pseudo-html.tsx` | ソース | ハイドレーション差分表示 |
| hot-linked-text.tsx | `packages/next/src/next-devtools/dev-overlay/components/hot-linked-text.tsx` | ソース | URLをリンクに変換するテキストコンポーネント |
| get-error-by-type.ts | `packages/next/src/next-devtools/dev-overlay/utils/get-error-by-type.ts` | ソース | ReadyRuntimeError型、useFramesフック |
| react-19-hydration-error.ts | `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` | ソース | ハイドレーションエラー判定・情報抽出 |
| use-active-runtime-error.ts | `packages/next/src/next-devtools/dev-overlay/hooks/use-active-runtime-error.ts` | ソース | アクティブエラー管理フック |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | OverlayState、アクション定数 |
