# 画面設計書 17-ルート情報パネル (Route Type)

## 概要

本ドキュメントは、Next.js開発モード時に現在のルートがStatic/Dynamicかを詳細表示するパネルの画面設計書である。ルートタイプの説明とLearn Moreリンクを提供する。

### 本画面の処理概要

ルート情報パネルは、DevToolsメニューの"Route"項目をクリックすると表示される詳細情報パネルである。現在のページのルートがStaticかDynamicかに応じた説明文を表示し、Next.jsドキュメントへのリンクを提供する。

**業務上の目的・背景**：開発者が現在のルートのレンダリング方式（Static/Dynamic）を理解し、パフォーマンス最適化の判断を行えるようにする。Static Rendering（ビルド時プレレンダリング）とDynamic Rendering（リクエスト時レンダリング）の違いを説明し、ルートがどちらに分類されているかを示す。

**画面へのアクセス方法**：DevToolsメニューの"Route"項目（Static/Dynamicの表示がある行）をクリックすると表示される。PanelRouterで`panel`状態が'route-type'の場合に描画される。

**主要な操作・処理内容**：
1. 現在のルートがStatic/Dynamicかに応じたタイトル表示（"Static Route"または"Dynamic Route"）
2. ルートタイプに応じた説明文の表示（パス情報を含む）
3. App Router/Pages Routerに応じた異なる説明内容
4. "Learn More"リンクで対応するNext.jsドキュメントへ遷移

**画面遷移**：
- 遷移元: DevToolsメニューのRoute項目クリック
- 遷移先: 閉じる操作でDevToolsインジケーターに戻る / "Learn More"クリックでNext.jsドキュメント（外部リンク）

**権限による表示制御**：`state.staticIndicator`が'disabled'または'pending'の場合はパネルが存在しない。staticIndicatorの値（'static'/'dynamic'）によって表示内容が切り替わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | DevTools（開発者ツール） | 主機能 | 現在のルートがStatic/Dynamicかの詳細表示とLearn Moreリンクの提供 |
| 35 | 静的サイト生成（SSG） | 補助機能 | Staticルートの判定情報を表示 |
| 34 | サーバーサイドレンダリング（SSR） | 補助機能 | Dynamicルートの判定情報を表示 |

## 画面種別

情報パネル（DynamicPanel、固定サイズ）

## URL/ルーティング

固有のURLは持たない。PanelRouterの`panel`状態が'route-type'の場合に表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| state.staticIndicator | Context入力 | 'static' \| 'dynamic' | ルートのStatic/Dynamic状態 |
| state.routerType | Context入力 | 'pages' \| 'app' | 使用中のルータータイプ |
| state.scale | Context入力 | number | DevToolsスケール値 |

## 表示項目

### Staticルート表示

| 表示項目 | 説明 |
|----------|------|
| ヘッダー | "Static Route" |
| パス情報 | `window.location.pathname`が"static"としてプレレンダリングされることの説明 |
| Static Rendering説明 | ビルド時またはdata revalidation後にレンダリングされること |
| ユースケース | パーソナライズされないデータ（静的ブログ、商品ページなど）に適すること |
| Learn Moreリンク | App Router: `.../server-components#static-rendering-default` / Pages Router: `.../static-site-generation` |

### Dynamicルート表示

| 表示項目 | 説明 |
|----------|------|
| ヘッダー | "Dynamic Route" |
| パス情報 | `window.location.pathname`がリクエスト時にレンダリングされることの説明 |
| Dynamic Rendering説明 | ユーザーごとにカスタマイズされるデータやリクエスト時にのみわかる情報に適すること |
| 動的化の理由（App Router） | Dynamic APIやfetch `{ cache: 'no-store' }` の検出で動的化されること |
| 動的化の理由（Pages Router） | getServerSidePropsのエクスポートで動的化されること |
| Learn Moreリンク | App Router: `.../server-components#dynamic-rendering` / Pages Router: `.../server-side-rendering` |

## イベント仕様

### 1-パネル表示

PanelRouterの`PanelRoute name="route-type"`内でDynamicPanelとして描画される。サイズはstaticIndicatorの値に応じて変わる。
- Static: 高さ 300/scale、幅 400/scale
- Dynamic: 高さ 325/scale、幅 400/scale

### 2-Learn Moreクリック

InfoFooterコンポーネントの`<a>`タグで外部リンクを新しいタブに開く。リンク先はrouterTypeとstaticIndicatorに応じて`learnMoreLink`オブジェクトから取得。

### 3-外部クリックで閉じる

DynamicPanelの`closeOnClickOutside`がtrueに設定されており、パネル外クリックで閉じる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベース操作は発生しない |

## メッセージ仕様

本パネルの表示内容は全て情報提供用であり、ユーザーへの操作要求メッセージはない。

## 例外処理

- `staticIndicator`が'disabled'または'pending'の場合、パネルは描画されない（panel-router.tsxの行189-190の条件）
- `window.location.pathname`の取得に失敗する環境は想定されていない（クライアントサイド専用）

## 備考

- パネルのサイズは`sharePanelSizeGlobally: false`で個別管理
- `closeOnClickOutside: true`でパネル外クリックによる閉じ動作を有効化
- learnMoreLinkオブジェクトはApp Router/Pages Routerの各Static/Dynamicに対応する4つのURLを持つ
- DevToolsHeaderコンポーネントがパネルのタイトル表示を担当
- `key={state.staticIndicator}`により、Static/Dynamic切り替わり時にコンポーネントが再マウントされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | OverlayStateのstaticIndicator（行54）: 'pending'/'static'/'dynamic'/'disabled'。routerType（行58）: 'pages'/'app' |
| 1-2 | route-info.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/route-info.tsx` | learnMoreLinkオブジェクト（行102-115）: ルーター種別とルートタイプに応じた4つのドキュメントURL |

#### Step 2: パネルルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | PanelRoute name="route-type"（行189-221）: staticIndicatorが'disabled'/'pending'でない場合のみ描画。DynamicPanelのサイズ設定、DevToolsHeaderとRouteInfoBody + InfoFooterの構成 |

**主要処理フロー**:
1. **行189-190**: staticIndicator !== 'disabled' && !== 'pending' ガード
2. **行193**: `key={state.staticIndicator}`で値変更時に再マウント
3. **行196-200**: サイズ計算（static: 300/scale、dynamic: 325/scale）
4. **行204-207**: DevToolsHeaderでタイトル表示（"Static Route"/"Dynamic Route"）
5. **行210-218**: RouteInfoBody + InfoFooter

#### Step 3: ルート情報表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | route-info.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/route-info.tsx` | RouteInfoBody（行117-130）: isStaticRouteに応じてStaticRouteContentまたはDynamicRouteContentを描画。StaticRouteContent（行3-39）: Staticルートの説明。DynamicRouteContent（行41-100）: Dynamicルートの説明（App/Pages Routerで内容が異なる） |

### プログラム呼び出し階層図

```
PanelRouter (panel-router.tsx)
    |
    +-- PanelRoute name="route-type"
           +-- DynamicPanel (fixed size, closeOnClickOutside)
                  |
                  +-- DevToolsHeader title="Static/Dynamic Route"
                  +-- div.panel-content
                         +-- RouteInfoBody (route-info.tsx)
                         |      +-- StaticRouteContent (staticの場合)
                         |      +-- DynamicRouteContent (dynamicの場合)
                         |
                         +-- InfoFooter (panel-router.tsx)
                                +-- <a> Learn More (learnMoreLink[routerType][staticIndicator])
```

### データフロー図

```
[入力]                        [処理]                           [出力]

state.staticIndicator   --> PanelRouter条件分岐          --> route-typeパネル表示
state.routerType        --> RouteInfoBody                --> Static/Dynamic説明文
                              |
window.location.pathname --> StaticRouteContent          --> パス情報表示
                              / DynamicRouteContent
                              |
learnMoreLink           --> InfoFooter                   --> Learn Moreリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | ソース | PanelRoute "route-type"のルーティング・DynamicPanel構成 |
| route-info.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/route-info.tsx` | ソース | RouteInfoBody、StaticRouteContent、DynamicRouteContent、learnMoreLink |
| dev-tools-header.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/dev-tools-header.tsx` | ソース | DevToolsHeaderコンポーネント |
| dynamic-panel.tsx | `packages/next/src/next-devtools/dev-overlay/panel/dynamic-panel.tsx` | ソース | DynamicPanelコンポーネント（サイズ・位置管理） |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | OverlayState、staticIndicator定義 |
