# 画面設計書 18-セグメントエクスプローラー (Route Info)

## 概要

本ドキュメントは、Next.js開発モード時に現在のページのApp Routerセグメントツリーをビジュアルに表示するパネルの画面設計書である。各セグメントのファイル（layout, page, error, loading等）をツリー構造で表示し、バウンダリの切り替えが可能。

### 本画面の処理概要

セグメントエクスプローラーは、App Router使用時にのみ表示されるパネルで、現在のページのルートセグメント構造をツリー形式でビジュアル表示する。各セグメントに含まれるファイル（layout, template, page, error, loading, not-found等）をピル形式で表示し、クリックでエディターで開くことができる。

**業務上の目的・背景**：App Routerのネストされたレイアウト構造やセグメント分割を視覚的に理解できるようにする。開発者が現在のページでどのレイアウト・テンプレート・エラーバウンダリが有効かを確認し、ルート構造のデバッグを効率的に行える。ビルトインのデフォルトファイルが使用されている場合はその旨を示し、カスタマイズの指針を提供する。

**画面へのアクセス方法**：DevToolsメニューの"Route Info"項目（App Router使用時のみ表示）をクリックするとパネルが表示される。PanelRouterで`panel`状態が'segment-explorer'の場合に描画される。

**主要な操作・処理内容**：
1. 現在のページのセグメントツリーを`useSegmentTree()`フックで取得
2. ツリーをレベル別に再帰的にレンダリング（PageSegmentTreeLayerPresentation）
3. 各レベルでファイルノードとフォルダノードを分離・ソート
4. ファイルをピル形式（FilePill）で表示（layout > template > page > boundaries > othersの優先順）
5. ビルトインファイルとユーザー定義ファイルを視覚的に区別
6. ファイルピルクリックでエディターを開く（`__nextjs_launch-editor`エンドポイント呼び出し）
7. バウンダリの切り替え（SegmentBoundaryTrigger）
8. グローバルエラーバウンダリ未定義時のサジェスション表示（SegmentSuggestion）
9. バウンダリオーバーライドの一括リセット（Clear Segment Overrides）
10. パネルのリサイズとドラッグ移動

**画面遷移**：
- 遷移元: DevToolsメニューのRoute Infoクリック
- 遷移先: 閉じるボタンでDevToolsインジケーターに戻る

**権限による表示制御**：App Router使用時のみ表示（`isAppRouter && ...`の条件）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | DevTools（開発者ツール） | 主機能 | App Routerセグメントツリーのビジュアル表示処理 |
| 13 | App Router | 補助機能 | App Routerのセグメント構造データを取得して表示 |
| 14 | レイアウト（Layouts） | 補助機能 | 各セグメントのlayout・page・error・loading等のファイルツリー表示 |

## 画面種別

情報パネル（DynamicPanel、リサイズ可能・ドラッグ可能）

## URL/ルーティング

固有のURLは持たない。PanelRouterの`panel`状態が'segment-explorer'の場合に表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| page | Props入力 | string | 現在のページパス（state.page） |
| tree | Hook出力 | SegmentTrieNode | useSegmentTree()から取得するセグメントツリー |

## 表示項目

| 表示項目 | コンポーネント | 説明 |
|----------|---------------|------|
| ページルートバー | PageRouteBar | 現在のページパスをバーで表示（矢印アイコン付き） |
| セグメントツリー | PageSegmentTreeLayerPresentation | 再帰的なツリー構造表示 |
| フォルダ名 | span.segment-explorer-filename--path | セグメント名（ルートレベルは"app"） |
| ファイルピル | FilePill | layout/template/page等のファイルをピル形式で表示 |
| ビルトイン情報アイコン | InfoIcon | ビルトインファイルの場合に表示 |
| コードアイコン | CodeIcon | ユーザー定義ファイルの場合に表示 |
| バウンダリトリガー | SegmentBoundaryTrigger | バウンダリ切り替えUI |
| サジェスション | SegmentSuggestion | global-error未定義時の提案表示 |
| フッター | SegmentExplorerFooter | Clear Segment Overridesボタン（オーバーライド数バッジ付き） |
| ツールチップ | Tooltip | ビルトインファイルの説明ホバーテキスト |

## イベント仕様

### 1-ファイルピルクリック

FilePillのonClickで`openInEditor`関数を呼び出し、`/__nextjs_launch-editor`エンドポイントにfetchリクエストを送信。パラメータとしてfile（ファイルパス）とisAppRelativePath=1を送信する。

### 2-Clear Segment Overridesクリック

SegmentExplorerFooterのボタンクリックで`handleGlobalReset`を呼び出し、`traverseTreeAndResetBoundaries`でツリー全体のバウンダリオーバーライドをnullにリセットする。

### 3-パネルリサイズ

DynamicPanelの`sizeConfig.kind: 'resizable'`により、パネルの端をドラッグしてサイズ変更可能。最小サイズ200/scale x 250/scale、最大サイズ90vh x 90vw。

### 4-パネルドラッグ

DynamicPanelの`draggable: true`により、パネルヘッダーをドラッグして位置移動可能。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイルピルクリック | - | HTTP GET | `/__nextjs_launch-editor`でエディターを起動（DB操作なし） |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| ツールチップ | `The default Next.js {type} is being shown. You can customize this page by adding your own {fileName} file to the app/ directory.` | ビルトインファイルホバー時 |
| ボタン | "Clear Segment Overrides" | フッターに常時表示（バウンダリオーバーライドがある場合のみ有効化） |

## 例外処理

- App Router以外（Pages Router）では本パネルは表示されない
- ツリーが空の場合、セグメントツリーエリアは空になる
- ビルトインファイル（BUILTIN_PREFIXで始まるパス）はツールチップで説明を表示

## 備考

- `sharePanelSizeGlobally: false`、`sharePanelPositionGlobally: false`でサイズ・位置を個別管理
- ファイルのソート優先順: layout(1) > template(2) > page(3) > boundaries(4) > others(5)
- フォルダにファイルが含まれない場合、セグメント名が次のレベルとマージされる（"folder1 / folder2"形式）
- `countActiveBoundaries`でバウンダリオーバーライドの数をカウントし、フッターバッジに表示
- `GLOBAL_ERROR_BOUNDARY_TYPE = 'global-error'`でグローバルエラーバウンダリの存在を確認

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | segment-explorer-trie.ts | `packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.ts` | SegmentTrieNode型: セグメントツリーのノード構造。useSegmentTree()フック: ツリーデータの取得 |
| 1-2 | segment-explorer-path.ts | `packages/next/src/server/app-render/segment-explorer-path.ts` | BUILTIN_PREFIX、isBoundaryFile、isBuiltinBoundaryFile、normalizeBoundaryFilename、getBoundaryOriginFileType関数: ファイル種別判定ユーティリティ |

**読解のコツ**: SegmentTrieNodeは再帰的なツリー構造で、各ノードにvalue（ファイル情報）とchildren（子ノードMap）がある。ファイルノードはvalue.typeとvalue.pagePathを持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | PanelRoute name="segment-explorer"（行223-245）: isAppRouter条件、DynamicPanelのリサイズ・ドラッグ設定、PageSegmentTree呼び出し |

#### Step 3: ツリー表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | segment-explorer.tsx | `packages/next/src/next-devtools/dev-overlay/components/overview/segment-explorer.tsx` | PageSegmentTree（行133-172）: ツリー取得・グローバルリセット・フッター構成。PageSegmentTreeLayerPresentation（行176-442）: 再帰的ツリーレンダリング。ファイル/フォルダ分離、ソート、FilePill表示、バウンダリ管理 |

**主要処理フロー**:
1. **行134**: `useSegmentTree()`でツリー取得
2. **行137-139**: `countActiveBoundaries`でオーバーライド数カウント
3. **行142-144**: `handleGlobalReset`でツリー全体リセット
4. **行155**: PageRouteBarで現在パス表示
5. **行164**: PageSegmentTreeLayerPresentationで再帰レンダリング開始
6. **行214-252**: ソート（layout>template>page>boundaries>others、ファイル優先）
7. **行260-272**: ファイルノードとフォルダノードの分離
8. **行355-407**: FilePill表示（ビルトイン判定、ツールチップ付き）
9. **行420-439**: フォルダの再帰レンダリング（空フォルダはマージ）

### プログラム呼び出し階層図

```
PanelRouter (panel-router.tsx)
    |
    +-- PanelRoute name="segment-explorer" [isAppRouter only]
           +-- DynamicPanel (resizable, draggable)
                  |
                  +-- DevToolsHeader title="Route Info"
                  +-- PageSegmentTree (segment-explorer.tsx)
                         |
                         +-- useSegmentTree() -> tree
                         +-- countActiveBoundaries(tree) -> badge count
                         +-- PageRouteBar
                         +-- PageSegmentTreeLayerPresentation (recursive)
                         |      +-- FilePill (each file)
                         |      |      +-- openInEditor (click)
                         |      +-- SegmentBoundaryTrigger
                         |      +-- SegmentSuggestion (if missing global-error)
                         |      +-- Tooltip (builtin files)
                         |
                         +-- SegmentExplorerFooter
                                +-- Clear Segment Overrides button
                                       +-- traverseTreeAndResetBoundaries()
```

### データフロー図

```
[入力]                        [処理]                           [出力]

useSegmentTree()         --> PageSegmentTree             --> ツリー構造UI
state.page              --> PageRouteBar                --> パス表示バー
                              |
SegmentTrieNode          --> PageSegmentTreeLayer...    --> ファイルピル一覧
                              (再帰レンダリング)              フォルダ構造
                              |
FilePillクリック          --> openInEditor()              --> エディター起動
                              (/__nextjs_launch-editor)
                              |
Clear Overridesクリック   --> traverseTree...()          --> 全バウンダリリセット
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| segment-explorer.tsx | `packages/next/src/next-devtools/dev-overlay/components/overview/segment-explorer.tsx` | ソース | PageSegmentTree、PageSegmentTreeLayerPresentation、FilePill等 |
| segment-explorer.css | `packages/next/src/next-devtools/dev-overlay/components/overview/segment-explorer.css` | スタイル | セグメントエクスプローラーのCSS |
| segment-explorer-trie.ts | `packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.ts` | ソース | SegmentTrieNode型、useSegmentTreeフック |
| segment-explorer-path.ts | `packages/next/src/server/app-render/segment-explorer-path.ts` | ソース | ファイル種別判定ユーティリティ |
| segment-boundary-trigger.tsx | `packages/next/src/next-devtools/dev-overlay/components/overview/segment-boundary-trigger.tsx` | ソース | バウンダリ切り替えUIコンポーネント |
| segment-suggestion.tsx | `packages/next/src/next-devtools/dev-overlay/components/overview/segment-suggestion.tsx` | ソース | グローバルエラー未定義時のサジェスション |
| tooltip.tsx | `packages/next/src/next-devtools/dev-overlay/components/tooltip/tooltip.tsx` | ソース | ツールチップコンポーネント |
| panel-router.tsx | `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx` | ソース | PanelRoute "segment-explorer"のルーティング |
| dynamic-panel.tsx | `packages/next/src/next-devtools/dev-overlay/panel/dynamic-panel.tsx` | ソース | DynamicPanelコンポーネント |
