---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-パラレルルートデフォルト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/client/components/builtin/default.tsx`（ソースコード）
- E-02: `packages/next/src/client/components/not-found.ts`（ソースコード）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パラレルルートで明示的なdefault.tsxが未定義の場合にフォールバックとして使用される | E-01, E-03 | ○ |
| C-02 | コンポーネントはnotFound()を呼び出す | E-01 (行7) | ○ |
| C-03 | notFound()はNEXT_HTTP_ERROR_FALLBACK;404というdigestを持つエラーをスローする | E-02 (行21-27) | ○ |
| C-04 | PARALLEL_ROUTE_DEFAULT_PATHが定数としてエクスポートされている | E-01 (行3-4) | ○ |
| C-05 | パスはnext/dist/client/components/builtin/default.js | E-01 (行4) | ○ |
| C-06 | Propsを受け取らないコンポーネントである | E-01 (行6) | ○ |
| C-07 | 関連機能No.20 並列ルートが主機能 | E-04 | ○ |
| C-08 | 関連機能No.13 App Routerが補助機能 | E-04 | ○ |
| C-09 | notFoundはHTTPAccessFallbackErrorをスローする | E-02 (行24-25) | ○ |
| C-10 | 画面遷移: Not Found画面へ遷移 | E-05 | ○ |
| C-11 | コンポーネントは8行のファイルで構成されている | E-01 | ○ |
| C-12 | notFoundは../not-foundからインポートされている | E-01 (行1) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。本コンポーネントは極めてシンプルであり、すべての主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本コンポーネントは8行で構成される非常にシンプルなフォールバックであり、誤解の余地が少ない

## 6) レビュアーチェックリスト（最小）
- [ ] default.tsxの実装がnotFound()を呼び出すだけであることを確認
- [ ] PARALLEL_ROUTE_DEFAULT_PATHの値が正しいことを確認
- [ ] 画面遷移図との整合性を確認
