---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-開発オーバーレイ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ShadowPortalの内部実装詳細**：shadow-portal.tsxの実装は直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/menu/context.tsx`（ソースコード）
- E-04: `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx`（ソースコード）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Shadow DOMを利用してアプリケーションのスタイルに影響を与えずに描画 | E-01 (行28: ShadowPortal) | ○ |
| C-02 | panelとselectedIndexをローカル状態で管理 | E-01 (行21-22) | ○ |
| C-03 | useDevOverlayContextからstate, dispatch, getSquashedHydrationErrorDetailsを取得 | E-01 (行23-24) | ○ |
| C-04 | state.showIndicatorがtrueの場合にUI要素を描画 | E-01 (行36) | ○ |
| C-05 | RenderErrorContext.Providerでランタイムエラー情報を共有 | E-01 (行38-40) | ○ |
| C-06 | PanelRouterContextでパネル状態を共有 | E-01 (行41-48) | ○ |
| C-07 | ErrorOverlayでビルドエラーとランタイムエラーを表示 | E-04 (行52-86) | ○ |
| C-08 | PanelRouterで各種パネルの表示切替 | E-01 (行59) | ○ |
| C-09 | DevToolsIndicatorを描画 | E-01 (行60) | ○ |
| C-10 | ScaleUpdaterでスケール設定を適用 | E-01 (行29) | ○ |
| C-11 | ComponentStylesでスタイルを注入 | E-01 (行30) | ○ |
| C-12 | PanelStateKindは4種類のパネル | E-03 (行8-12) | ○ |
| C-13 | OverlayStateにbuildError, errors, showIndicator等のフィールドがある | E-02 (行44-73) | ○ |
| C-14 | 開発モードでのみ表示される | E-05, E-06 | ○ |
| C-15 | devIndicators: falseでインジケーター無効化 | E-02 (行260-261) | ○ |
| C-16 | RenderErrorはrender propsパターンでruntimeErrorsとtotalErrorCountを提供 | E-01 (行32-67) | ○ |
| C-17 | triggerRefはHTMLButtonElement用のRef | E-01 (行26), E-03 (行17) | ○ |
| C-18 | ShadowPortalの内部でShadow DOMを作成しReactポータルレンダリング | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ShadowPortalの内部実装（shadow-portal.tsx）は直接読み込んでいないため、Shadow DOMの作成方法の詳細は推測に基づく
  - 候補：`packages/next/src/next-devtools/dev-overlay/components/shadow-portal.tsx`を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ShadowPortalの内部実装詳細以外は全てソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DevOverlayコンポーネントの構成が実際のソースコードと一致することを確認
- [ ] ShadowPortalのShadow DOM実装詳細を確認
- [ ] 画面遷移図との整合性を確認
- [ ] 関連機能マッピングとの整合性を確認
