---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-DevToolsインジケーター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Draggableコンポーネントの四隅スナップ動作詳細**：draggable.tsxは直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/menu/context.tsx`（ソースコード）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面隅に常時表示されるNext.jsロゴのフローティングボタン | E-01, E-04 | ○ |
| C-02 | クリックでDevToolsメニューの開閉をトグル | E-01 (行60-68) | ○ |
| C-03 | ドラッグで四隅に移動可能 | E-01 (行44-57) | ○ |
| C-04 | INDICATOR_PADDINGは20px | E-01 (行21) | ○ |
| C-05 | panel !== nullの場合ドラッグ無効化 | E-01 (行46) | ○ |
| C-06 | useDevOverlayContextからstate, dispatchを取得 | E-01 (行24) | ○ |
| C-07 | usePanelRouterContextからpanel, setPanel, setSelectedIndexを取得 | E-01 (行25) | ○ |
| C-08 | devToolsPositionをsplit('-', 2)で垂直・水平に分割 | E-01 (行27) | ○ |
| C-09 | ドラッグ移動時にACTION_DEVTOOLS_POSITIONをディスパッチ | E-01 (行50-53) | ○ |
| C-10 | saveDevToolsConfigで設定を永続化 | E-01 (行54) | ○ |
| C-11 | updateAllPanelPositionsで全パネル位置を同期 | E-01 (行56, 行81-112) | ○ |
| C-12 | panel 'panel-selector'のトグル動作 | E-01 (行61-62) | ○ |
| C-13 | メニューを閉じる際にselectedIndexを-1にリセット | E-01 (行64-65) | ○ |
| C-14 | 関連機能No.94 DevToolsが主機能 | E-05 | ○ |
| C-15 | 関連機能No.1 next devが補助機能 | E-05 | ○ |
| C-16 | Draggableが四隅へのスナップロジックを持つ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Draggableコンポーネント（draggable.tsx）の内部実装を直接確認していないため、四隅スナップの具体的なロジックは推測
  - 候補：`packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/draggable.tsx`を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な動作ロジックはdevtools-indicator.tsxから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DevToolsIndicatorコンポーネントの構成が実際のソースコードと一致することを確認
- [ ] Draggableの四隅スナップ動作を確認
- [ ] 画面遷移図との整合性を確認
