---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-DevToolsメニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/menu/dev-overlay-menu.tsx`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/menu/context.tsx`（ソースコード）
- E-04: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DevToolsインジケータークリックでメニュー表示 | E-07 | ○ |
| C-02 | Issues項目でエラーオーバーレイを開閉トグル | E-01 (行42-62) | ○ |
| C-03 | totalErrorCount > 0の場合のみIssues表示 | E-01 (行42) | ○ |
| C-04 | isErrorOverlayOpen時にクリックでCLOSEディスパッチ | E-01 (行47-53) | ○ |
| C-05 | Route項目でstaticIndicatorに応じた表示分岐 | E-01 (行63-80) | ○ |
| C-06 | staticIndicator 'disabled'時はRoute非表示 | E-01 (行63-64) | ○ |
| C-07 | staticIndicator 'pending'時はLoadingIcon表示 | E-01 (行66-69) | ○ |
| C-08 | RouteクリックでsetPanel('route-type') | E-01 (行76) | ○ |
| C-09 | Turbopack有効時はTurbopack表示 | E-01 (行81-86) | ○ |
| C-10 | Turbopack無効時はドキュメントリンク表示 | E-01 (行87-101) | ○ |
| C-11 | App Router時のみRoute Info表示 | E-01 (行107) | ○ |
| C-12 | Route InfoクリックでsetPanel('segment-explorer') | E-01 (行110) | ○ |
| C-13 | PreferencesクリックでsetPanel('preferences') | E-01 (行118) | ○ |
| C-14 | Preferencesはfooter: trueで配置 | E-01 (行119) | ○ |
| C-15 | キーボードナビゲーション対応（ArrowUp/Down, Home/End） | E-02 (行173-212) | ○ |
| C-16 | Ctrl+N/Pによるナビゲーション | E-02 (行196-209) | ○ |
| C-17 | useClickOutsideAndEscapeで外部クリック/Escape処理 | E-02 (行113-137) | ○ |
| C-18 | メニュー表示時にDOMフォーカス自動設定 | E-02 (行147) | ○ |
| C-19 | Cache Components項目は__NEXT_CACHE_COMPONENTS有効時表示 | E-01 (行102-106) | ○ |
| C-20 | メニュー位置はdevToolsPositionに連動 | E-02 (行109, 行151-168) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに基づいており誤解の余地が少ない

## 6) レビュアーチェックリスト（最小）
- [ ] MenuPanelのitems配列の構成が正確であることを確認
- [ ] キーボードナビゲーションの動作が正しいことを確認
- [ ] 画面遷移図との整合性を確認
- [ ] 各条件分岐の表示制御が正確であることを確認
