---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ビルドエラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンパイルエラー発生時に自動表示 | E-02 (行52), E-06 | ○ |
| C-02 | ターミナル風エラー出力をTerminalコンポーネントで表示 | E-01 (行74) | ○ |
| C-03 | "Build Error"ラベルで表示 | E-01 (行67) | ○ |
| C-04 | メッセージの2行目からエラーテキストを抽出 | E-01 (行11-27, 行23: lines[1]) | ○ |
| C-05 | stripAnsiでANSIエスケープコード除去 | E-01 (行2, 行23) | ○ |
| C-06 | "Error: "プレフィックスを除去 | E-01 (行26) | ○ |
| C-07 | フォールバックメッセージは"Failed to compile" | E-01 (行36) | ○ |
| C-08 | onCloseはnoop（手動で閉じられない） | E-01 (行33, 行69) | ○ |
| C-09 | renderedはtrue固定（強制表示） | E-02 (行58) | ○ |
| C-10 | ビルドエラーはランタイムエラーより優先表示 | E-02 (行52-61) | ○ |
| C-11 | generateErrorInfoでAI支援用情報を構造化 | E-01 (行40-63) | ○ |
| C-12 | エラー情報にNext.jsバージョンとバンドラー名を含む | E-01 (行60) | ○ |
| C-13 | state.buildErrorがnullになると自動非表示 | E-02 (行52), E-03 (ACTION_BUILD_OK, 行372) | ○ |
| C-14 | 関連機能No.95 エラーオーバーレイが主機能 | E-05 | ○ |
| C-15 | メッセージフォーマット: ファイルパス:行:列 + エラー + コードフレーム | E-01 (行13-21, コメント参照) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BuildErrorコンポーネントは明瞭なロジックで構成されている

## 6) レビュアーチェックリスト（最小）
- [ ] getErrorTextFromBuildErrorMessageのメッセージ解析ロジックが正確であることを確認
- [ ] ErrorOverlayのビルドエラー優先分岐が正しいことを確認
- [ ] generateErrorInfoの出力フォーマットを確認
