---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：16-ランタイムエラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **useActiveRuntimeErrorフックの内部実装**：フック自体は直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ランタイムエラー発生時にオーバーレイ自動表示 | E-02, E-06 | ○ |
| C-02 | エラー種別: hydration/blocking-route/dynamic-metadata/empty | E-01 (行455-481) | ○ |
| C-03 | ハイドレーションエラー判定にisHydrationError使用 | E-01 (行528) | ○ |
| C-04 | ブロッキングルートは/blocking-routeメッセージ含有で判定 | E-01 (行546) | ○ |
| C-05 | 動的メタデータは/next-prerender-dynamic-metadataで判定 | E-01 (行558-559) | ○ |
| C-06 | ブロッキングルートにnavigation/runtimeバリアント | E-01 (行472-476) | ○ |
| C-07 | getErrorTypeLabelでエラータイプラベル生成 | E-01 (行435-453) | ○ |
| C-08 | "Blocking Route"/"Ambiguous Metadata"ラベル | E-01 (行440-445) | ○ |
| C-09 | "Recoverable"/"Console"/"Runtime"プレフィックス | E-01 (行446-452) | ○ |
| C-10 | サーバーエラー時にonCloseがundefined（閉じ不可） | E-01 (行767) | ○ |
| C-11 | getErrorSourceで'server'/'edge-server'判定 | E-01 (行694-696) | ○ |
| C-12 | PseudoHtmlDiffでハイドレーション差分表示 | E-01 (行733-739) | ○ |
| C-13 | HydrationErrorDescriptionでハイドレーションメッセージ表示 | E-01 (行703-704) | ○ |
| C-14 | BlockingPageLoadErrorDescriptionで修正提案表示 | E-01 (行743-748) | ○ |
| C-15 | Suspenseフォールバック付きRuntimeError表示 | E-01 (行779-785) | ○ |
| C-16 | generateErrorInfoでスタックトレースとコードフレーム構造化 | E-01 (行617-678) | ○ |
| C-17 | environmentNameプレフィックス除去 | E-01 (行628-635) | ○ |
| C-18 | isLoading時はOverlay+OverlayBackdropのみ | E-01 (行680-687) | ○ |
| C-19 | activeErrorがnullなら何も表示しない | E-01 (行689-691) | ○ |
| C-20 | useFramesでスタックフレームをパース | E-01 (行604) | ○ |
| C-21 | firstFrameはignored=falseかつoriginalCodeFrame付き | E-01 (行606-615) | ○ |
| C-22 | useActiveRuntimeErrorでページネーション管理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `useActiveRuntimeError`フック（use-active-runtime-error.ts）の内部実装は直接確認していない。エラーインデックス管理の詳細は推測に基づく
  - 候補：`packages/next/src/next-devtools/dev-overlay/hooks/use-active-runtime-error.ts`を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エラー種別判定と表示分岐のロジックはerrors.tsx内で完結しており、直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] エラー種別判定の分岐条件が正確であることを確認
- [ ] ブロッキングルートエラーのバリアント・refinementの組み合わせを確認
- [ ] サーバーエラー時の閉じるボタン無効化を確認
- [ ] generateErrorInfoの出力形式を確認
- [ ] useActiveRuntimeErrorのページネーション動作を確認
