---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-ルート情報パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/route-info.tsx`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DevToolsメニューのRoute項目クリックで表示 | E-06, E-01 (行76) | ○ |
| C-02 | staticIndicatorが'disabled'/'pending'でない場合のみ描画 | E-01 (行189-190) | ○ |
| C-03 | Staticルート時の高さ300/scale、Dynamic時325/scale | E-01 (行197-200) | ○ |
| C-04 | 幅は400/scale | E-01 (行201) | ○ |
| C-05 | DevToolsHeaderで"Static Route"/"Dynamic Route"タイトル | E-01 (行206) | ○ |
| C-06 | RouteInfoBodyでisStaticRouteに基づく表示分岐 | E-02 (行117-130) | ○ |
| C-07 | StaticRouteContentでwindow.location.pathname使用 | E-02 (行11) | ○ |
| C-08 | data revalidationリンク含むStatic説明 | E-02 (行18-29) | ○ |
| C-09 | DynamicRouteContentでApp/Pages Router分岐 | E-02 (行58-97) | ○ |
| C-10 | Pages RouterでgetServerSideProps説明 | E-02 (行61-71) | ○ |
| C-11 | App RouterでDynamic API/fetchオプション説明 | E-02 (行73-97) | ○ |
| C-12 | learnMoreLinkオブジェクトに4つのURL | E-02 (行102-115) | ○ |
| C-13 | InfoFooterにLearn Moreリンク | E-01 (行250-263) | ○ |
| C-14 | closeOnClickOutside: true | E-01 (行203) | ○ |
| C-15 | key={state.staticIndicator}で再マウント | E-01 (行193) | ○ |
| C-16 | sharePanelSizeGlobally: false | E-01 (行194) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] StaticRouteContent/DynamicRouteContentの表示内容が正確であることを確認
- [ ] learnMoreLinkの4つのURLが有効であることを確認
- [ ] パネルサイズ計算が正しいことを確認
