---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：18-セグメントエクスプローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **SegmentBoundaryTriggerの動作詳細**：segment-boundary-trigger.tsxは直接未確認
  2. **useSegmentTree()フックの内部実装**：segment-explorer-trie.tsは直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/components/overview/segment-explorer.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx`（ソースコード）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | App Router使用時のみ表示 | E-02 (行223) | ○ |
| C-02 | DynamicPanelでリサイズ可能・ドラッグ可能 | E-02 (行225-239) | ○ |
| C-03 | useSegmentTree()でツリーデータ取得 | E-01 (行134) | ○ |
| C-04 | countActiveBoundariesでオーバーライド数カウント | E-01 (行39-61, 行137-139) | ○ |
| C-05 | traverseTreeAndResetBoundariesでリセット | E-01 (行25-37, 行142-144) | ○ |
| C-06 | PageRouteBarでパスと矢印アイコン表示 | E-01 (行63-70) | ○ |
| C-07 | ファイルソート優先順: layout>template>page>boundaries>others | E-01 (行227-234) | ○ |
| C-08 | FilePillクリックでopenInEditor呼び出し | E-01 (行123-125) | ○ |
| C-09 | openInEditorが/__nextjs_launch-editorにfetch | E-01 (行444-456) | ○ |
| C-10 | ビルトインファイルはInfoIcon、ユーザー定義はCodeIcon | E-01 (行128) | ○ |
| C-11 | ビルトインファイルのツールチップメッセージ | E-01 (行379-381) | ○ |
| C-12 | 空フォルダはセグメント名がマージされる | E-01 (行428-430) | ○ |
| C-13 | ルートレベルは"app"フォルダ名 | E-01 (行255) | ○ |
| C-14 | GLOBAL_ERROR_BOUNDARY_TYPE = 'global-error' | E-01 (行174) | ○ |
| C-15 | SegmentSuggestionでグローバルエラー未定義時の提案 | E-01 (行348-353) | ○ |
| C-16 | Clear Segment Overridesボタンとバッジ | E-01 (行72-100) | ○ |
| C-17 | 最小サイズ200/scale x 250/scale | E-02 (行233-234) | ○ |
| C-18 | 初期サイズ375/scale x 400/scale | E-02 (行235-238) | ○ |
| C-19 | SegmentBoundaryTriggerのバウンダリ切り替え動作 | **根拠なし** | △ |
| C-20 | useSegmentTree()の内部データ取得メカニズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SegmentBoundaryTriggerの内部実装（segment-boundary-trigger.tsx）を直接確認していない
  - 候補：`packages/next/src/next-devtools/dev-overlay/components/overview/segment-boundary-trigger.tsx`
- useSegmentTree()フックの内部実装（segment-explorer-trie.ts）を直接確認していない
  - 候補：`packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.ts`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - バウンダリ切り替え機能の動作詳細が未確認。ツリーデータの取得メカニズムも推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] SegmentBoundaryTriggerのバウンダリ切り替え動作を確認
- [ ] useSegmentTree()のデータ取得メカニズムを確認
- [ ] ファイルソートの優先順が正確であることを確認
- [ ] openInEditorのエンドポイントパラメータを確認
- [ ] SegmentSuggestionの表示条件を確認
