---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：19-ユーザー設定パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **ShortcutRecorderの内部動作**：shortcut-recorder.tsxは直接未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/user-preferences.tsx`（ソースコード）
- E-02: `packages/next/src/next-devtools/dev-overlay/menu/panel-router.tsx`（ソースコード）
- E-03: `packages/next/src/next-devtools/dev-overlay/shared.ts`（ソースコード）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DevToolsメニューのPreferencesクリックで表示 | E-06, E-02 (行118) | ○ |
| C-02 | テーマ選択: System/Light/Dark | E-01 (行88-90) | ○ |
| C-03 | テーマ変更でShadow DOMポータルのクラス切り替え | E-01 (行39-57) | ○ |
| C-04 | 位置選択: Bottom Left/Bottom Right/Top Left/Top Right | E-01 (行107-110) | ○ |
| C-05 | サイズ選択: NEXT_DEV_TOOLS_SCALE定義の3段階 | E-01 (行121-129), E-03 (行29-33) | ○ |
| C-06 | Hide Dev Toolsボタンでセッション/1日非表示 | E-01 (行134-151) | ○ |
| C-07 | hide()でACTION_DEV_INDICATOR_SETディスパッチ | E-02 (行295-296) | ○ |
| C-08 | hide()で/__nextjs_disable_dev_indicatorにPOST | E-02 (行300-302) | ○ |
| C-09 | ShortcutRecorderでキーボードショートカット記録 | E-01 (行161-165) | ○ |
| C-10 | setHideShortcutでsaveDevToolsConfig呼び出し | E-02 (行291-292) | ○ |
| C-11 | devIndicators: false設定の案内テキスト | E-01 (行169-177) | ○ |
| C-12 | Restart Dev Serverボタン | E-01 (行188-199) | ○ |
| C-13 | restartServer({ invalidateFileSystemCache: false }) | E-01 (行194) | ○ |
| C-14 | Reset Bundler Cacheは永続キャッシュ有効時のみ表示 | E-01 (行202) | ○ |
| C-15 | restartServer({ invalidateFileSystemCache: true }) | E-01 (行218) | ○ |
| C-16 | isPending中はボタン無効化 | E-01 (行195, 行219) | ○ |
| C-17 | パネルサイズ固定: 高さ500/scale、幅480+32 | E-02 (行178-180) | ○ |
| C-18 | closeOnClickOutside: true | E-02 (行182) | ○ |
| C-19 | saveDevToolsConfigで各設定を永続化 | E-01 (行44, 行50, 行55, 行61-63, 行69) | ○ |
| C-20 | useRestartServerからrestartServer, isPendingを取得 | E-01 (行36) | ○ |
| C-21 | テーマアイコンがSystem/Dark/Lightに応じて切り替わる | E-01 (行84, 行246-257) | ○ |
| C-22 | ShortcutRecorderがvalue.split('+')でキー配列を渡す | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ShortcutRecorderコンポーネント（shortcut-recorder.tsx）の内部実装を直接確認していない。キー入力の記録方式や`+`区切り文字列の処理詳細は推測に基づく
  - 候補：`packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/dev-tools-info/shortcut-recorder.tsx`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な設定機能のロジックはuser-preferences.tsxとpanel-router.tsxから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] テーマ切り替えのShadow DOMクラス操作が正確であることを確認
- [ ] 位置変更時にupdateAllPanelPositionsが正しく呼ばれることを確認
- [ ] ShortcutRecorderの内部動作を確認
- [ ] /__nextjs_disable_dev_indicatorのサーバーサイド処理を確認
- [ ] useRestartServerの再起動メカニズムを確認
- [ ] NEXT_DEV_TOOLS_SCALEの値が正確であることを確認
