---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **IT-035（Dev Server - Hot Reload）**：HMR WebSocketプロトコルの詳細は実装コードの深い部分にあり、テスト手順の網羅性が確認困難
  2. **IT-043（MCP Server）**：MCP機能は比較的新しく、テストケースの期待結果が概括的
  3. **IT-050（Trace / OpenTelemetry統合）**：OpenTelemetry統合の詳細仕様は外部依存が大きく、テスト期待値の妥当性を要確認
  4. **IT-033（Build - Static Generation）**：静的生成パスの網羅性はプロジェクト固有のページ構成に依存
  5. **IT-044（Instrumentation Hook）**：instrumentation APIの具体的な振る舞いはランタイム環境に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/route-modules/app-route/module.ts` - App Route Handler実装
- E-02: `packages/next/src/server/route-modules/pages-api/module.ts` - Pages API Route実装
- E-03: `packages/next/src/server/api-utils/index.ts` - API ユーティリティ（redirect, sendError, clearPreviewData等）
- E-04: `packages/next/src/server/lib/router-server.ts` - Router Server実装
- E-05: `packages/next/src/server/lib/router-utils/resolve-routes.ts` - ルーティング解決
- E-06: `packages/next/src/server/app-render/app-render.tsx` - App Router レンダリング
- E-07: `packages/next/src/server/app-render/action-handler.ts` - Server Actions ハンドラ
- E-08: `packages/next/src/server/app-render/csrf-protection.ts` - CSRF保護
- E-09: `packages/next/src/server/lib/incremental-cache/index.ts` - Incremental Cache
- E-10: `packages/next/src/server/lib/incremental-cache/file-system-cache.ts` - ファイルシステムキャッシュ
- E-11: `packages/next/src/server/lib/patch-fetch.ts` - Fetch パッチ
- E-12: `packages/next/src/server/lib/dedupe-fetch.ts` - Fetch重複排除
- E-13: `packages/next/src/server/image-optimizer.ts` - 画像最適化
- E-14: `packages/next/src/server/web/sandbox/sandbox.ts` - Edge Runtime サンドボックス
- E-15: `packages/next/src/server/lib/router-utils/proxy-request.ts` - プロキシリクエスト
- E-16: `packages/next/src/server/base-server.ts` - Base Server実装
- E-17: `packages/next/src/server/next-server.ts` - Next Server実装
- E-18: `packages/next/src/server/send-payload.ts` - レスポンス送信
- E-19: `packages/next/src/server/load-components.ts` - コンポーネントロード
- E-20: `packages/next/src/server/lib/router-utils/block-cross-site.ts` - クロスサイトブロッキング
- E-21: `packages/next/src/server/after/after-context.ts` - After API実装
- E-22: `packages/next/src/server/app-render/encryption.ts` - Server Action暗号化
- E-23: `packages/next/src/build/index.ts` - ビルドプロセス
- E-24: `packages/next/src/server/app-render/create-component-tree.tsx` - コンポーネントツリー構築
- E-25: `packages/next/src/server/app-render/dynamic-rendering.ts` - 動的レンダリング
- E-26: `packages/next/src/server/mcp/` - MCPサーバー
- E-27: `packages/next/src/server/instrumentation/` - Instrumentation Hook
- E-28: `packages/next/src/server/dev/hot-reloader-turbopack.ts` - Hot Reloader
- E-29: `packages/next/src/server/lib/cache-handlers/` - キャッシュハンドラ
- E-30: `packages/next/src/server/response-cache/` - レスポンスキャッシュ
- E-31: `packages/next/src/client/components/app-router-headers.ts` - RSCヘッダ定数定義
- E-32: `packages/next/src/server/config.ts` - 設定読み込み
- E-33: `packages/next/src/server/lib/trace/tracer.ts` - トレーシング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: App Route Handler（GET）が正常にレスポンスを返す | E-01 | ○ |
| C-02 | IT-002: App Route Handler（POST）がリクエストボディを処理 | E-01 | ○ |
| C-03 | IT-003: Pages API Routeがリクエストを処理 | E-02, E-03 | ○ |
| C-04 | IT-004: Pages APIエラーハンドリング | E-03 | ○ |
| C-05 | IT-005: APIルートリダイレクト | E-03 | ○ |
| C-06 | IT-006: Router Serverのルーティング解決 | E-04, E-05 | ○ |
| C-07 | IT-007: ミドルウェア実行 | E-05, E-14 | ○ |
| C-08 | IT-008: リライト/リダイレクト処理 | E-05 | ○ |
| C-09 | IT-009: RSCレンダリング | E-06, E-31 | ○ |
| C-10 | IT-010: Server Actions実行 | E-07 | ○ |
| C-11 | IT-011: CSRF保護 | E-08 | ○ |
| C-12 | IT-012: コンポーネントツリー構築 | E-24 | ○ |
| C-13 | IT-013: マニフェスト読み込み | E-19 | ○ |
| C-14 | IT-014: レスポンス送信 | E-18 | ○ |
| C-15 | IT-015: Edge Runtime Sandbox実行 | E-14 | ○ |
| C-16 | IT-016: プロキシリクエスト | E-15 | ○ |
| C-17 | IT-017: Incremental Cache取得 | E-09 | ○ |
| C-18 | IT-018: Incremental Cache保存 | E-09, E-29 | ○ |
| C-19 | IT-019: File System Cache | E-10 | ○ |
| C-20 | IT-020: タグベースrevalidate | E-09 | ○ |
| C-21 | IT-021: Fetch Cache | E-11 | ○ |
| C-22 | IT-022: Dedupe Fetch | E-12 | ○ |
| C-23 | IT-023: Image Optimizer画像最適化 | E-13 | ○ |
| C-24 | IT-024: リモート画像ドメイン検証 | E-13 | ○ |
| C-25 | IT-025: On-Demand Revalidation | E-03, E-09 | ○ |
| C-26 | IT-026: Preview Mode | E-03 | ○ |
| C-27 | IT-027: Cross-Site Request Blocking | E-20 | ○ |
| C-28 | IT-028: After API非同期後処理 | E-21 | ○ |
| C-29 | IT-029: Server Action暗号化 | E-22 | ○ |
| C-30 | IT-030: Base Serverリクエストルーティング | E-16 | ○ |
| C-31 | IT-031: i18nルーティング | E-16 | ○ |
| C-32 | IT-032: ビルドマニフェスト生成 | E-23 | ○ |
| C-33 | IT-033: Static Generation | E-23 | △ |
| C-34 | IT-034: Custom Routes | E-23 | ○ |
| C-35 | IT-035: Dev Server Hot Reload | E-28 | △ |
| C-36 | IT-036: Prefetch | E-06, E-31 | ○ |
| C-37 | IT-037: Segment Prefetch | E-06, E-31 | ○ |
| C-38 | IT-038: Static File Serving | E-04 | ○ |
| C-39 | IT-039: 404ページ | E-16, E-17 | ○ |
| C-40 | IT-040: 500エラー | E-06 | ○ |
| C-41 | IT-041: Metadata生成 | E-06 | ○ |
| C-42 | IT-042: Loading/Suspense | E-06 | ○ |
| C-43 | IT-043: MCP Server | E-26 | △ |
| C-44 | IT-044: Instrumentation Hook | E-27 | △ |
| C-45 | IT-045: Dynamic Rendering | E-25 | ○ |
| C-46 | IT-046: Response Cache | E-30 | ○ |
| C-47 | IT-047: Redirect | E-06 | ○ |
| C-48 | IT-048: notFound() | E-06 | ○ |
| C-49 | IT-049: Config Loading | E-32 | ○ |
| C-50 | IT-050: Trace / OpenTelemetry統合 | E-33 | △ |

## 4) 不足情報（Unknown / Missing）
- **IT-033（Static Generation）**：静的生成の完全なパス（getStaticPaths、generateStaticParams）の全パターンは、プロジェクト固有のページ構成に依存するため、汎用テストケースとしての網羅性に限界がある
  - 候補：個別プロジェクトのページ一覧 / generateStaticParams実装 / fallback設定
- **IT-035（Dev Server Hot Reload）**：HMRのWebSocketプロトコル詳細やTurbopackとWebpackの差異についてはhot-reloaderの実装が複雑で、テスト手順が概括的
  - 候補：hot-reloader-turbopack.ts詳細解析 / HMR_MESSAGE_SENT_TO_BROWSER定義 / WebSocketイベント仕様
- **IT-043（MCP Server）**：MCPサーバーは比較的新しい機能であり、ツール定義の詳細やプロトコル仕様についてはさらなる確認が必要
  - 候補：mcp/tools/ディレクトリ内の各ツール実装 / MCPプロトコル仕様書
- **IT-044（Instrumentation Hook）**：instrumentation APIのregister/onRequestErrorの具体的な呼び出しタイミングやエラーハンドリングの詳細はランタイム環境（Node.js / Edge）に依存
  - 候補：instrumentation/utils.ts / instrumentation/types.ts の詳細
- **IT-050（Trace / OpenTelemetry統合）**：OpenTelemetryスパンの具体的な属性値やスパン名はtracer.tsとconstants.tsに定義されているが、外部OpenTelemetry SDKとの統合テストの期待値は外部仕様に依存
  - 候補：OpenTelemetry SDK仕様 / trace/constants.ts のスパン名定義一覧

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**：該当なし
- **リスク1（中）**：
  - IT-033：Static Generationのテスト手順はプロジェクト構成に強く依存し、汎用テストケースでは不十分な可能性
  - IT-035：HMRの安定性テストはタイミングに依存し、非決定的な結果になりうる
  - IT-043：MCP機能の成熟度が他機能と比較して低い可能性
- **リスク0（低）**：
  - IT-001〜IT-005：API連携テストケースは安定した実装に基づいており、リスクは低い
  - IT-017〜IT-022：キャッシュ連携テストケースは明確なインターフェースに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] テスト種別の分類（API連携/コンポーネント間連携/キャッシュ連携/ビルド連携/外部サービス連携）が適切か
- [ ] 各テストケースの前提条件が実行可能な記述になっているか
- [ ] テスト手順が再現可能な粒度で記述されているか
- [ ] 期待結果が検証可能な具体的な記述になっているか
- [ ] 優先度の設定が機能の重要度と一致しているか
- [ ] IT-033、IT-035、IT-043、IT-044、IT-050のテストケースについて、プロジェクト固有の情報を補完する必要があるか確認
- [ ] Next.jsの最新バージョンの変更点（特にApp Router関連）がテストケースに反映されているか
