---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 44
  claims_with_evidence: 42
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：通知一覧

## 本レポートについて

### 目的
本レポートは、生成された通知一覧ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：42 / 44、根拠なし：2
- 優先レビュー（高）
  1. **C-39（Toastメッセージ）**：Toastコンポーネントの存在は確認できるが、実際にどのような通知で使用されるかの具体的な利用箇所の網羅性が不十分
  2. **C-44（DevIndicator状態通知）**：enum定義は確認できるが、具体的な送信内容の詳細が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/server/lib/app-info-log.ts` - サーバー起動時のログ出力関数（logStartInfo, logExperimentalInfo, getEnvInfo）
- E-02: `packages/next/src/telemetry/storage.ts` - テレメトリ収集通知（notify関数、TELEMETRY_KEY_NOTIFY_DATE）
- E-03: `packages/next/src/lib/turbopack-warning.ts` - Turbopack設定検証・警告（validateTurboNextConfig）
- E-04: `packages/next/src/lib/import-next-warning.ts` - nextモジュール直接インポート警告
- E-05: `packages/next/src/lib/verify-partytown-setup.ts` - Partytown依存検証・警告
- E-06: `packages/next/src/server/dev/hot-reloader-types.ts` - HMRメッセージ型定義（HMR_MESSAGE_SENT_TO_BROWSER enum、各メッセージインターフェース）
- E-07: `packages/next/src/server/dev/messages.ts` - HMRメッセージ定数（FAST_REFRESH_RUNTIME_RELOAD）
- E-08: `packages/next/src/build/output/store.ts` - コンパイル状態管理・コンソール出力（OutputState、storeサブスクリプション）
- E-09: `packages/next/src/build/output/log.ts` - ログ出力ユーティリティ（prefixes、各ログ関数定義）
- E-10: `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` - ビルドエラーオーバーレイUIコンポーネント
- E-11: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` - ランタイムエラーオーバーレイUIコンポーネント群（Errors, HydrationErrorDescription, BlockingPageLoadErrorDescription, DynamicMetadataErrorDescription）
- E-12: `packages/next/src/next-devtools/dev-overlay/components/version-staleness-info/version-staleness-info.tsx` - バージョン古さ表示コンポーネント
- E-13: `packages/next/src/next-devtools/shared/version-staleness.ts` - バージョン古さ判定ロジック（getStaleness）
- E-14: `packages/next/src/server/dev/parse-version-info.ts` - バージョン情報パース（VersionInfo, parseVersionInfo）
- E-15: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` - Toastコンポーネント
- E-16: `packages/next/src/client/components/app-router-announcer.tsx` - App Routerルートアナウンサー
- E-17: `packages/next/src/client/route-announcer.tsx` - Pages Routerルートアナウンサー
- E-18: `packages/next/src/server/dev/hot-reloader-webpack.ts` - WebpackベースHMRサーバー実装
- E-19: `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` - DevOverlayメインコンポーネント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サーバー起動情報通知（バージョン、URL、ポート、環境情報） | E-01 | ○ |
| C-02 | 実験的機能情報通知 | E-01 | ○ |
| C-03 | テレメトリ収集通知（初回のみ） | E-02 | ○ |
| C-04 | Turbopack未対応設定警告 | E-03 | ○ |
| C-05 | Webpack設定存在・Turbopack未設定エラー | E-03 | ○ |
| C-06 | nextモジュール直接インポート警告 | E-04 | ○ |
| C-07 | Partytown依存パッケージ不足エラー | E-05 | ○ |
| C-08 | Partytownライブラリコピー失敗警告 | E-05 | ○ |
| C-09 | ページ追加通知（HMR） | E-06 | ○ |
| C-10 | ページ削除通知（HMR） | E-06 | ○ |
| C-11 | ページリロード通知（HMR） | E-06, E-18 | ○ |
| C-12 | サーバーコンポーネント変更通知（HMR） | E-06 | ○ |
| C-13 | ミドルウェア変更通知（HMR） | E-06 | ○ |
| C-14 | クライアント変更通知（HMR） | E-06 | ○ |
| C-15 | サーバーのみ変更通知（HMR） | E-06 | ○ |
| C-16 | ビルド中通知（HMR） | E-06 | ○ |
| C-17 | ビルド同期通知（HMR） | E-06 | ○ |
| C-18 | ビルド完了通知（HMR） | E-06 | ○ |
| C-19 | サーバーエラー通知（HMR） | E-06 | ○ |
| C-20 | ブラウザ表示エラー通知（HMR） | E-06, E-07 | ○ |
| C-21 | DevPagesManifest更新通知（HMR） | E-06 | ○ |
| C-22 | Turbopack接続通知（HMR） | E-06 | ○ |
| C-23 | ISRマニフェスト通知（HMR） | E-06 | ○ |
| C-24 | キャッシュインジケーター通知（HMR） | E-06 | ○ |
| C-25 | DevToolsコンフィグ通知（HMR） | E-06 | ○ |
| C-26 | Turbopackメッセージ通知（HMR） | E-06 | ○ |
| C-27 | Reactデバッグチャンク通知（HMR） | E-06, E-07 | ○ |
| C-28 | Fast Refreshフルリロード通知 | E-07 | ○ |
| C-29 | コンパイル中通知（コンソール） | E-08 | ○ |
| C-30 | コンパイルエラー通知（コンソール） | E-08 | ○ |
| C-31 | コンパイル警告通知（コンソール） | E-08 | ○ |
| C-32 | 型チェック中通知（コンソール） | E-08 | ○ |
| C-33 | ビルドエラーオーバーレイ | E-10 | ○ |
| C-34 | ランタイムエラーオーバーレイ | E-11 | ○ |
| C-35 | ハイドレーションエラー通知 | E-11 | ○ |
| C-36 | ブロッキングルートエラー通知 | E-11 | ○ |
| C-37 | 動的メタデータエラー通知 | E-11 | ○ |
| C-38 | バージョン古さ通知 | E-12, E-13, E-14 | ○ |
| C-39 | Toastメッセージ | E-15 | △ |
| C-40 | App Routerルートアナウンサー | E-16 | ○ |
| C-41 | Pages Routerルートアナウンサー | E-17 | ○ |
| C-42 | エラー状態リクエスト通知（HMR） | E-06 | ○ |
| C-43 | ページメタデータリクエスト通知（HMR） | E-06 | ○ |
| C-44 | DevIndicator状態通知（HMR） | E-06 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-39（Toastメッセージ）**: Toastコンポーネント自体は存在を確認できたが、どのタイミングでどのようなメッセージが表示されるかの網羅的な調査が不十分。Dev Overlay内部での利用パターンを追加調査する必要がある。
  - 候補：`packages/next/src/next-devtools/dev-overlay/container/` 配下のコンポーネント / エラーハンドリングフロー全体 / Dev Overlayのstate管理
- **C-44（DevIndicator状態通知）**: HMR_MESSAGE_SENT_TO_BROWSER.DEV_INDICATORのenum定義は確認できたが、対応するメッセージインターフェースの定義が見当たらず、具体的な送信データ構造が不明確。
  - 候補：`packages/next/src/server/dev/dev-indicator-server-state.ts` / `packages/next/src/next-devtools/server/dev-indicator-middleware.ts`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: C-01 ~ C-08（CLI/サーバー起動通知）- ソースコードで直接確認済みのconsole出力
- **0（低リスク）**: C-09 ~ C-28, C-42 ~ C-43（HMRメッセージ）- 型定義ファイルで明確に定義されたenumに基づく
- **0（低リスク）**: C-29 ~ C-32（コンソール通知）- store.tsのサブスクリプションロジックで直接確認済み
- **0（低リスク）**: C-33 ~ C-38（Dev Overlayエラー表示）- Reactコンポーネントとして実装を直接確認済み
- **0（低リスク）**: C-40 ~ C-41（ルートアナウンサー）- コンポーネント実装を直接確認済み
- **1（中リスク）**: C-39（Toastメッセージ）- コンポーネント存在は確認したが利用箇所の網羅性に不安あり
- **1（中リスク）**: C-44（DevIndicator状態通知）- enum定義のみ確認、メッセージインターフェース未確認

## 6) レビュアーチェックリスト（最小）
- [ ] HMRメッセージ一覧（C-09 ~ C-28, C-42 ~ C-44）がhot-reloader-types.tsのenum定義と一致しているか確認
- [ ] CLI通知（C-01 ~ C-08）の説明が実際のソースコードのconsole出力と一致しているか確認
- [ ] Dev Overlayエラー通知（C-33 ~ C-38）の分類が実際のエラーハンドリングロジックと整合しているか確認
- [ ] Toastメッセージ（C-39）の利用箇所をDev Overlay全体で追加調査し、具体的な通知シナリオを特定
- [ ] 他のパッケージ（create-next-app, eslint-plugin-next, font等）に通知機能がないか確認
- [ ] ビルド時（production build）の通知・警告が網羅されているか確認（packages/next/src/build/index.tsなど）
