# 通知設計書 1-サーバー起動情報通知

## 概要

本ドキュメントは、Next.jsサーバー起動時にコンソールへ出力される起動情報通知の設計を記載する。

### 本通知の処理概要

Next.jsの開発サーバーまたはプロダクションサーバーが起動した際に、サーバーの基本情報をコンソールに出力する通知である。

**業務上の目的・背景**：開発者がNext.jsサーバーを起動した際に、バージョン情報、アクセスURL、ネットワークURL、デバッガポート、環境ファイルの読み込み状況を即座に確認できるようにすることで、開発環境の状態把握を効率化する。サーバーが正常に起動したかどうかの最初のフィードバックとして機能し、設定ミスやポート競合などの問題を早期に発見するための重要な情報源となる。

**通知の送信タイミング**：サーバープロセスの起動直後、設定ファイルの読み込みよりも前の段階で出力される。`start-server.ts`の`startServer`関数内で、`getRequestHandlers`による設定読み込みの前に`logStartInfo`が呼び出される。ビルド時にも`build/index.ts`から呼び出される。

**通知の受信者**：CLIでNext.jsを起動した開発者。ターミナル/コンソールを通じて情報を受け取る。

**通知内容の概要**：Next.jsバージョン番号（`process.env.__NEXT_VERSION`）、使用バンドラー（Turbopack/Rspack/webpack）、ローカルアクセスURL、ネットワークURL、Node.jsデバッガポート番号、読み込まれた環境ファイル（`.env`等）のパス一覧。

**期待されるアクション**：開発者は表示されたURLにアクセスしてアプリケーションの動作確認を行う。ネットワークURLを使って他デバイスからのテストも可能。デバッガポートが表示された場合はデバッガの接続に利用する。

## 通知種別

コンソール出力（標準出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

サーバープロセスを起動したターミナルの標準出力に対して無条件に出力される。受信者の選択ロジックは存在しない。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | Next.jsサーバープロセス |
| 出力先 | `console.log`（標準出力） |
| 形式 | ANSIカラー付きテキスト |

### 本文テンプレート

```
▲ Next.js {version} ({bundler})
- Local:         {appUrl}
- Network:       {networkUrl}
- Debugger port: {debugPort}
- Environments: {envFilePaths}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| version | Next.jsバージョン | `process.env.__NEXT_VERSION` | Yes |
| bundler | バンドラー名 | `process.env.TURBOPACK`, `process.env.NEXT_RSPACK` | No（開発モード時のみ） |
| appUrl | ローカルURL | `startServer`の引数 | No |
| networkUrl | ネットワークURL | `startServer`の引数 | No |
| debugPort | デバッガポート | `process.debugPort` | No（デバッガ接続時のみ） |
| envFilePaths | 環境ファイルパス | `@next/env`の`loadEnvConfig`結果 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー起動 | `startServer`関数の実行 | 無条件 | 開発・本番いずれのモードでも出力される |
| ビルド実行 | `build/index.ts`のビルド処理開始 | 無条件 | ビルド時はappUrl, networkUrlがnull |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 起動時には常に出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サーバー起動] --> B[環境ファイル情報取得 getEnvInfo]
    B --> C[logStartInfo呼び出し]
    C --> D[バージョン・バンドラー情報出力]
    D --> E{appUrlあり?}
    E -->|Yes| F[ローカルURL出力]
    E -->|No| G{networkUrlあり?}
    F --> G
    G -->|Yes| H[ネットワークURL出力]
    G -->|No| I{inspectorUrl?}
    H --> I
    I -->|Yes| J[デバッガポート出力]
    I -->|No| K{envInfoあり?}
    J --> K
    K -->|Yes| L[環境ファイルパス出力]
    K -->|No| M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 環境ファイル読み込み失敗 | `.env`ファイルが不正な形式 | `loadEnvConfig`内部でハンドルされ、通知自体は出力される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（起動時に1回のみ出力） |

### 配信時間帯

制限なし。サーバー起動時に即座に出力される。

## セキュリティ考慮事項

- ネットワークURLにはホスト名またはIPアドレスが含まれるが、ローカル環境のコンソール出力であるためリスクは低い
- デバッガポート情報はセキュリティ上のリスクとなり得るが、デバッグ目的の開発環境のみで使用される
- 環境ファイルのパスのみが出力され、環境変数の値は出力されない

## 備考

- `logStartInfo`は設定読み込み前に呼び出されるため、即座にフィードバックを提供する設計となっている
- バンドラー情報は開発モード（`logBundler: true`）のときのみ表示される
- `Log.bootstrap`関数はprefixなしで`console.log`を直接使用する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ出力のための基盤モジュールを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | log.ts | `packages/next/src/build/output/log.ts` | `bootstrap`関数（行45-47）が`console.log`を直接呼ぶことを確認。`prefixes`オブジェクト（行4-12）で各種記号を定義 |

**読解のコツ**: `bootstrap`は他のログ関数と異なり、prefix記号なしで出力する特殊なログ関数である。

#### Step 2: エントリーポイントを理解する

サーバー起動時の呼び出し元を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | start-server.ts | `packages/next/src/server/lib/start-server.ts` | 行362で`logStartInfo`を呼び出し。行359で`getEnvInfo`による環境ファイル情報取得 |

**主要処理フロー**:
1. **行359**: `getEnvInfo(dir)`で環境ファイル情報を取得
2. **行362-367**: `logStartInfo`に`networkUrl`, `appUrl`, `envInfo`, `logBundler`を渡して呼び出し
3. **行380**: `Log.event`で"Ready in X"を出力

#### Step 3: 通知出力の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | app-info-log.ts | `packages/next/src/server/lib/app-info-log.ts` | `logStartInfo`関数（行15-64）。バンドラー判定（行30-36）、各情報の条件付き出力（行48-63） |
| 3-2 | app-info-log.ts | `packages/next/src/server/lib/app-info-log.ts` | `getEnvInfo`関数（行119-122）。`loadEnvConfig`で環境ファイルを検出 |

**主要処理フロー**:
- **行29-37**: `logBundler`がtrueの場合、`TURBOPACK`/`NEXT_RSPACK`環境変数でバンドラー名を決定
- **行43-47**: `Log.bootstrap`でバージョン情報を太字紫色で出力
- **行48-50**: `appUrl`が存在すればローカルURL出力
- **行51-53**: `networkUrl`が存在すればネットワークURL出力
- **行54-62**: `inspector.url()`が存在すればデバッガポート出力
- **行63**: `envInfo`が存在すれば環境ファイルパス出力

### プログラム呼び出し階層図

```
startServer (start-server.ts:362)
    │
    ├─ getEnvInfo(dir) (app-info-log.ts:119)
    │      └─ loadEnvConfig() (@next/env)
    │
    └─ logStartInfo({...}) (app-info-log.ts:15)
           ├─ Log.bootstrap() (log.ts:45) - バージョン出力
           ├─ Log.bootstrap() - ローカルURL出力
           ├─ Log.bootstrap() - ネットワークURL出力
           ├─ Log.bootstrap() - デバッガポート出力
           └─ Log.bootstrap() - 環境ファイル出力
```

### データフロー図

```
[入力]                      [処理]                        [出力]

process.env.__NEXT_VERSION ──┐
process.env.TURBOPACK ───────┤
process.env.NEXT_RSPACK ─────┤
appUrl ──────────────────────┼── logStartInfo() ───▶ console.log (stdout)
networkUrl ──────────────────┤
inspector.url() ─────────────┤
loadEnvConfig(dir) ──────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| app-info-log.ts | `packages/next/src/server/lib/app-info-log.ts` | ソース | 起動情報ログ出力の実装 |
| start-server.ts | `packages/next/src/server/lib/start-server.ts` | ソース | サーバー起動の呼び出し元 |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
| index.ts | `packages/next/src/build/index.ts` | ソース | ビルド時の呼び出し元 |
| picocolors | `packages/next/src/lib/picocolors.ts` | ソース | ANSIカラー装飾ユーティリティ |
