# 通知設計書 10-ページ削除通知

## 概要

本ドキュメントは、ページが削除された際にブラウザへWebSocket経由で送信されるremovedPageメッセージの設計を記載する。

### 本通知の処理概要

開発サーバーのHMR（Hot Module Replacement）システムにおいて、ページファイルが削除されたことを検出し、ブラウザクライアントへWebSocket経由で通知する。

**業務上の目的・背景**：Next.jsの開発サーバーでは、ファイルシステムの変更をリアルタイムに検出してブラウザに反映する。ページが削除された際に、ブラウザ側のルーティング情報を更新し、削除されたページへのナビゲーション時に適切なエラー（404等）を表示できるようにすることが目的である。ページ追加通知（No.9）と対になる機能であり、Hot Module Replacementの一環として開発体験の向上に寄与する。

**通知の送信タイミング**：Turbopackの場合はエントリーポイント処理ループ内でルート変更を検出した際に送信される（`hot-reloader-turbopack.ts`行737-742）。Webpackの場合はクライアントコンパイル完了時にchunkNames差分で検出される（`hot-reloader-webpack.ts`行1600-1607）。

**通知の受信者**：開発サーバーにWebSocket接続しているすべてのブラウザクライアント。

**通知内容の概要**：削除されたページのルートパス（例：`/about`、`/blog/[slug]`）。

**期待されるアクション**：ブラウザ側のHMRクライアントがルーティングテーブルを更新し、削除されたページへのアクセス時に適切な404レスポンスを返すようにする。Pages Routerの場合は開発用ページマニフェストの更新も併せて行われる。

## 通知種別

WebSocket（HMRメッセージ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket push） |
| 優先度 | 高 |
| リトライ | なし（WebSocket接続が切断された場合はページリロードで復旧） |

### 送信先決定ロジック

開発サーバーにWebSocket接続しているすべてのブラウザクライアントに対してブロードキャスト送信される。`hotReloader.send()`メソッドで全クライアントに送信。

## 通知テンプレート

### WebSocketメッセージの場合

| 項目 | 内容 |
|-----|------|
| プロトコル | WebSocket |
| 形式 | JSON |
| メッセージタイプ | `removedPage` |

### メッセージ構造

```json
{
  "type": "removedPage",
  "data": ["/route-path"]
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| data[0] | 削除されたページのルートパス | Turbopack: removedRoutes / Webpack: getRouteFromEntrypoint(removedPage) | Yes（nullの場合あり） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Turbopackルート変更 | エントリーポイント処理でremovedRoutes検出 | removedRoutesが非空 | hot-reloader-turbopack.ts行737-742 |
| Webpackコンパイル完了 | クライアントコンパイル完了時のchunkNames差分 | removedPagesが非空 | hot-reloader-webpack.ts行1600-1607 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 削除ルートなし | ルート変更検出の結果、削除がない場合 |
| 初回コンパイル | Webpackの場合、prevChunkNamesが未設定の初回は差分計算をスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイルシステム変更検出] --> B{バンドラー}
    B -->|Turbopack| C[エントリーポイント処理]
    B -->|Webpack| D[クライアントコンパイル完了]
    C --> E[removedRoutes計算]
    D --> F[chunkNames差分計算]
    E --> G{removedRoutes非空?}
    F --> H{removedPages非空?}
    G -->|Yes| I[各routeについてsend実行]
    H -->|Yes| J[各pageについてsend実行]
    G -->|No| K[終了]
    H -->|No| K
    I --> L[WebSocket経由でブラウザへ送信]
    J --> L
    L --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| WebSocket切断 | ブラウザ側の接続が切れた場合 | 次回接続時にsyncメッセージで状態同期 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（変更検出のたびに送信） |

### 配信時間帯

制限なし。開発サーバー稼働中は常に有効。

## セキュリティ考慮事項

- ルートパス情報のみが送信され、ファイルシステムの絶対パスやソースコードは含まれない
- WebSocket接続はlocalhostに限定されるのが一般的
- 開発環境でのみ使用される機能であり、プロダクション環境には影響しない

## 備考

- `HMR_MESSAGE_SENT_TO_BROWSER.REMOVED_PAGE`はenum値`'removedPage'`として定義（hot-reloader-types.ts行21）
- メッセージの`data`フィールドは配列形式で、要素は1つのルートパス（またはnull）
- `RemovedPageMessage`インターフェースで型定義されている（hot-reloader-types.ts行100-103）
- ページ追加通知（No.9）と同一のトリガーメカニズムで、addedRoutesとremovedRoutesが同時に処理される
- Turbopackではページ追加/削除時にDEV_PAGES_MANIFEST_UPDATEメッセージも併せて送信される
- Webpackでは`diff(prevChunkNames, chunkNames)`で削除ページのSet差分を取得（引数の順序がNo.9と逆）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | `HMR_MESSAGE_SENT_TO_BROWSER.REMOVED_PAGE`（行21）のenum定義 |
| 1-2 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | `RemovedPageMessage`インターフェース（行100-103）。typeとdata[page]の構造 |

**読解のコツ**: `RemovedPageMessage`は`AddedPageMessage`（No.9）と全く同じデータ構造を持つ。typeのみが異なる。

#### Step 2: エントリーポイントを理解する（Turbopack）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hot-reloader-turbopack.ts | `packages/next/src/server/dev/hot-reloader-turbopack.ts` | 行737-742の削除ルート送信ロジック |

**主要処理フロー**:
1. **行718**: `addedRoutes.length > 0 || removedRoutes.length > 0`の判定（No.9と共通）
2. **行737-742**: `removedRoutes`をループし、各ルートについて`REMOVED_PAGE`メッセージを送信

#### Step 3: エントリーポイントを理解する（Webpack）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hot-reloader-webpack.ts | `packages/next/src/server/dev/hot-reloader-webpack.ts` | 行1600-1607の削除ページ送信ロジック |

**主要処理フロー**:
- **行1588**: `diff(prevChunkNames, chunkNames)`で削除ページを取得（引数順序がaddedPagesと逆）
- **行1600**: `removedPages.size > 0`の判定
- **行1601-1607**: 削除ページをループし、`getRouteFromEntrypoint`でルートパスに変換後に送信

#### Step 4: メッセージ送信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | `NextJsHotReloaderInterface`のsendメソッド（行233） |

### プログラム呼び出し階層図

```
[Turbopack]
handleEntrypoints() (hot-reloader-turbopack.ts)
    │
    ├─ addedRoutes / removedRoutes 計算
    │
    ├─ hotReloader.send({ type: DEV_PAGES_MANIFEST_UPDATE }) (行720-727)
    │
    └─ for (route of removedRoutes) (行737)
           └─ hotReloader.send({ type: REMOVED_PAGE, data: [route] }) (行738-741)

[Webpack]
onClientDone(stats) (hot-reloader-webpack.ts)
    │
    ├─ compilation.namedChunks → chunkNames (行1578-1582)
    │
    ├─ diff(prevChunkNames, chunkNames) → removedPages (行1588)
    │
    └─ for (removedPage of removedPages) (行1601)
           ├─ getRouteFromEntrypoint(removedPage) → page (行1602)
           └─ this.send({ type: REMOVED_PAGE, data: [page] }) (行1603-1606)
```

### データフロー図

```
[入力]                              [処理]                         [出力]

[Turbopack]
entrypoints変更 ──▶ removedRoutes計算 ──▶ hotReloader.send() ──▶ WebSocket → ブラウザ

[Webpack]
prevChunkNames ──────┐
                     ├──▶ diff() ──▶ getRouteFromEntrypoint() ──▶ this.send() ──▶ WebSocket → ブラウザ
compilation.namedChunks ┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | ソース | HMRメッセージ型定義・enum定義 |
| hot-reloader-turbopack.ts | `packages/next/src/server/dev/hot-reloader-turbopack.ts` | ソース | Turbopack版HMR実装 |
| hot-reloader-webpack.ts | `packages/next/src/server/dev/hot-reloader-webpack.ts` | ソース | Webpack版HMR実装 |
