# 通知設計書 14-クライアント変更通知

## 概要

本ドキュメントは、Next.js開発サーバーにおける「クライアント変更通知」（HMR_MESSAGE_SENT_TO_BROWSER.CLIENT_CHANGES）の設計を記述する。この通知は、クライアントサイドコードの変更を検出した際にブラウザへWebSocket経由で通知する。

### 本通知の処理概要

この通知は、Pages RouterのHTMLエンドポイント（クライアントサイドバンドル）に変更が検出された際に、開発サーバーからブラウザへHMRメッセージとして送信される仕組みである。

**業務上の目的・背景**：Next.jsのPages Routerにおいて、ページのクライアントサイドコード（htmlEndpoint）が変更された場合に、ブラウザに通知を送る必要がある。通常はTurbopackのHMR機構により自動的にモジュールが更新されるが、エラーページ表示中の場合はフルリロードが必要となる。この通知により、クライアントサイドの変更がエラーページ表示中でも適切に反映される。

**通知の送信タイミング**：Pages Routerのページに対するhtmlEndpointのchangeサブスクリプションが変更を検出した場合。

**通知の受信者**：WebSocket接続を確立しているすべてのブラウザクライアント。

**通知内容の概要**：メッセージタイプ`clientChanges`のみが含まれるシンプルなメッセージ。

**期待されるアクション**：エラーページ（`/_error`）表示中のクライアントはフルリロードを実行する。通常ページではTurbopackのHMR機構が変更を適用するため、この通知自体による追加のアクションは不要。

## 通知種別

WebSocket（アプリ内通知） - ブラウザへのHMRメッセージ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket push） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

Turbopackモードでは`sendHmr`関数を通じて全クライアントのメッセージキューに追加される。

## 通知テンプレート

### メール通知の場合

該当なし

### 本文テンプレート

```json
{
  "type": "clientChanges"
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | メッセージタイプ識別子 | HMR_MESSAGE_SENT_TO_BROWSER.CLIENT_CHANGES定数 (`clientChanges`) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ファイル変更 | Pages RouterページのhtmlEndpoint変更 | changeサブスクリプションで変更が通知された場合 | turbopack-utils.ts handleRouteType pageケースのclientKeyサブスクリプション（283-298行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| WebSocket未接続 | ブラウザがWebSocket接続を確立していない場合 |
| コンパイルエラー中 | sendEnqueuedMessagesのエラーチェックにより保留 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Pages Routerページのクライアントコード変更] --> B[Turbopack htmlEndpoint changeサブスクリプション]
    B --> C[ClientChangesMessage生成]
    C --> D[sendHmr経由で全クライアントのキューに追加]
    D --> E[sendEnqueuedMessagesでJSON送信]
    E --> F{エラーページ表示中?}
    F -->|Yes| G[performFullReload実行]
    F -->|No| H[何もしない TurbopackのHMRで処理済み]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| エラーページ表示中のランタイムエラー | /_errorページ表示中にランタイムエラーが既存 | REACT_REFRESH_FULL_RELOAD_FROM_ERROR警告を出力しperformFullReload実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

開発サーバー稼働中は常時送信可能

## セキュリティ考慮事項

- 開発環境専用
- メッセージに機密情報は含まれない

## 備考

- ClientChangesMessageはMiddlewareChangesMessageと同様にtypeフィールドのみの最小構造
- turbopack-utils.tsのコメントに「This is used in `../server/dev/turbopack-utils.ts`」と記載されている通り、サーバー側のturbopack-utils.tsでメッセージが生成される
- App RouterのprocessMessage（hot-reloader-app.tsx 537-541行目）ではCLIENT_CHANGESの処理をpage-bootstrap.tsに委譲
- page-bootstrap.tsでは、エラーページ表示中かどうかを`window.next.router.pathname === '/_error'`で判定する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | 119-121行目: ClientChangesMessage型定義。typeフィールドのみ |
| 1-2 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | 25行目: CLIENT_CHANGES = `clientChanges` |

#### Step 2: サーバー側送信ロジック

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | turbopack-utils.ts | `packages/next/src/server/dev/turbopack-utils.ts` | 283-298行目: Pages Routerページのclientキーに対するhtmlEndpointのchangeサブスクリプション |

**主要処理フロー**:
- **287-289行目**: createMessage関数がCLIENT_CHANGESメッセージを返す
- **293-297行目**: エラー発生時はRELOAD_PAGEにフォールバック

#### Step 3: クライアント側受信処理

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page-bootstrap.ts | `packages/next/src/client/page-bootstrap.ts` | 58-69行目: CLIENT_CHANGESメッセージ受信処理。エラーページ表示中のみリロード実行 |

### プログラム呼び出し階層図

```
[サーバー側]
turbopack-utils.ts: handleRouteType() [pageケース]
    |
    +-- subscribeToChanges(clientKey, false, route.htmlEndpoint, ...)
            |
            +-- createMessage() -> { type: CLIENT_CHANGES }
                    |
                    +-- sendHmr()
                            +-- sendEnqueuedMessages() -> WebSocket送信

[クライアント側]
page-bootstrap.ts: addMessageListener()
    |
    +-- case CLIENT_CHANGES:
            +-- window.next.router.pathname === '/_error' チェック
            +-- [エラーページの場合] performFullReload(null)
```

### データフロー図

```
[入力]                         [処理]                      [出力]

Pages Routerページ         Turbopack
クライアントコード変更 ---> htmlEndpoint検出
                            |
                            v
                     ClientChangesMessage生成
                     { type: "clientChanges" }
                            |
                            v
                     WebSocket JSON送信 ---------> page-bootstrap.ts
                                                   |
                                                   v
                                            エラーページ判定
                                            /_error ? reload : noop
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | ソース | ClientChangesMessage型定義 |
| turbopack-utils.ts | `packages/next/src/server/dev/turbopack-utils.ts` | ソース | htmlEndpointサブスクリプション登録 |
| hot-reloader-turbopack.ts | `packages/next/src/server/dev/hot-reloader-turbopack.ts` | ソース | WebSocket送信インフラ |
| page-bootstrap.ts | `packages/next/src/client/page-bootstrap.ts` | ソース | クライアント側CLIENT_CHANGES処理 |
| hot-reloader-app.tsx | `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` | ソース | App Router側メッセージルーティング（page-bootstrap.tsに委譲） |
| hot-reloader-pages.ts | `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` | ソース | Pages Router側メッセージルーティング（page-bootstrap.tsに委譲） |
