# 通知設計書 16-ビルド中通知

## 概要

本ドキュメントは、Next.js開発サーバーにおける「ビルド中通知」（HMR_MESSAGE_SENT_TO_BROWSER.BUILDING）の設計を記述する。この通知は、コンパイルが開始された際にブラウザへWebSocket経由でbuildingメッセージを送信し、ブラウザ側でビルドインジケーターを表示させる。

### 本通知の処理概要

この通知は、開発サーバーでコンパイルが開始された際に、ブラウザへ「現在コンパイル中」であることを伝達するHMRメッセージである。

**業務上の目的・背景**：開発者がコードを変更した際に、コンパイルが進行中であることを視覚的に伝える必要がある。この通知によりブラウザ側でビルドインジケーターが表示され、開発者はコンパイルの進行状況を認識できる。これにより、変更直後のページ操作で古いコードが表示されることへの混乱を防ぐ。

**通知の送信タイミング**：(1) Turbopackモードでは、`project.updateInfoSubscribe`からupdateTypeが`start`のメッセージを受信した場合。(2) Webpackモードでは、クライアントコンパイラのinvalidフック（再コンパイル開始）が発火した場合。

**通知の受信者**：WebSocket接続を確立しているすべてのブラウザクライアント。

**通知内容の概要**：メッセージタイプ`building`のみが含まれるシンプルなメッセージ。

**期待されるアクション**：ブラウザはビルドインジケーターを表示し、コンソールに「[Fast Refresh] rebuilding」を出力する（Webpackモード時）。Turbopackモードでは100ms遅延後にコンソール出力する（ノイジーなnoop HMR更新を抑制するため）。

## 通知種別

WebSocket（アプリ内通知） - ブラウザへのHMRメッセージ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket push） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

Turbopackモードでは`hotReloader.send()`により全クライアントに直接JSON送信される。Webpackモードでは`WebpackHotMiddleware.publish()`により全クライアントに送信される。

## 通知テンプレート

### メール通知の場合

該当なし

### 本文テンプレート

```json
{
  "type": "building"
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | メッセージタイプ識別子 | HMR_MESSAGE_SENT_TO_BROWSER.BUILDING定数 (`building`) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンパイル開始 | Turbopack updateInfoSubscribe `start`イベント | 常に送信 | hot-reloader-turbopack.ts handleProjectUpdates内（1481行目） |
| コンパイル開始 | Webpack clientコンパイラinvalidフック | サーバーコンパイラにエラーがないこと、closed状態でないこと | hot-middleware.ts onClientInvalid（106-111行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Webpackサーバーエラー | Webpackモードでサーバーコンパイラにエラーがある場合は送信しない |
| closed状態 | WebpackHotMiddlewareがclose()された場合は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンパイル開始検出] --> B{バンドラー種別}
    B -->|Turbopack| C[updateInfoSubscribe start受信]
    B -->|Webpack| D[clientコンパイラinvalidフック発火]
    C --> E[hotReloader.send BuildingMessage]
    D --> F{サーバーエラー有?}
    F -->|Yes| G[送信スキップ]
    F -->|No| H[publish BuildingMessage]
    E --> I[クライアント側処理]
    H --> I
    I --> J[ビルドインジケーター表示]
    I --> K[コンソール出力 - Fast Refresh rebuilding]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| WebSocket送信失敗 | クライアント接続切断 | 送信スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

開発サーバー稼働中は常時送信可能

## セキュリティ考慮事項

- 開発環境専用
- メッセージに機密情報は含まれない

## 備考

- TurbopackモードではBUILDINGメッセージが頻繁に生成されるため（キャッシュ済みコンパイルを含む）、クライアント側ではTurbopackHmrクラスが100ms遅延（TURBOPACK_HMR_START_DELAY_MS）を設けてノイジーなnoop更新のメッセージを抑制する
- Webpackモードでは`onClientInvalid`内で直接console.log('[Fast Refresh] rebuilding')が出力される
- ビルドインジケーター表示は`dispatcher.buildingIndicatorShow()`で行われ、BUILTまたはSYNC受信時に`dispatcher.buildingIndicatorHide()`で非表示になる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | 63-65行目: BuildingMessage型定義。typeフィールドのみ |
| 1-2 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | 29行目: BUILDING = `building` |

#### Step 2: サーバー側送信ロジック

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hot-reloader-turbopack.ts | `packages/next/src/server/dev/hot-reloader-turbopack.ts` | 1477-1482行目: handleProjectUpdates内でupdateType `start`時にBUILDINGを送信 |
| 2-2 | hot-middleware.ts | `packages/next/src/server/dev/hot-middleware.ts` | 106-111行目: onClientInvalid内でBUILDINGを送信 |

**主要処理フロー（Turbopack）**:
1. **1478行目**: project.updateInfoSubscribe(30)からメッセージを受信
2. **1479-1482行目**: updateTypeが`start`の場合、BUILDINGメッセージを全クライアントに送信

**主要処理フロー（Webpack）**:
1. **89-91行目**: クライアントコンパイラのinvalidフックにタップ
2. **106-111行目**: サーバーエラーがなければBUILDINGメッセージをpublish

#### Step 3: クライアント側受信処理

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hot-reloader-app.tsx | `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` | 286-297行目: App RouterでのBUILDING処理。ビルドインジケーター表示、TurbopackHmr.onBuilding()呼び出し |
| 3-2 | hot-reloader-pages.ts | `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` | 282-292行目: Pages RouterでのBUILDING処理 |
| 3-3 | turbopack-hot-reloader-common.ts | `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` | 54-67行目: TurbopackHmr.onBuilding()。100ms遅延でコンソール出力 |

### プログラム呼び出し階層図

```
[サーバー側 - Turbopack]
hot-reloader-turbopack.ts: handleProjectUpdates()
    |
    +-- project.updateInfoSubscribe(30)
            |
            +-- updateType === 'start'
                    |
                    +-- hotReloader.send({ type: BUILDING })
                            +-- JSON.stringify() -> 全クライアントにWebSocket送信

[サーバー側 - Webpack]
hot-middleware.ts: WebpackHotMiddleware
    |
    +-- compilers[0].hooks.invalid.tap(onClientInvalid)
            |
            +-- publish({ type: BUILDING })
                    +-- JSON.stringify() -> 全クライアントにWebSocket送信

[クライアント側]
hot-reloader-app.tsx / hot-reloader-pages.ts: processMessage()
    |
    +-- case BUILDING:
            +-- dispatcher.buildingIndicatorShow()
            +-- [Turbopack] turbopackHmr.onBuilding()
            |       +-- 100ms遅延後 console.log('[Fast Refresh] rebuilding')
            +-- [Webpack] console.log('[Fast Refresh] rebuilding')
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コード変更             バンドラー                       ブラウザ
                  ---> コンパイル開始検出
                       |
                       v
                  BuildingMessage生成
                  { type: "building" }
                       |
                       v
                  WebSocket JSON送信 ----------> processMessage()
                                                 |
                                                 v
                                          ビルドインジケーター表示
                                          コンソール出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | ソース | BuildingMessage型定義 |
| hot-reloader-turbopack.ts | `packages/next/src/server/dev/hot-reloader-turbopack.ts` | ソース | Turbopackモードでの送信ロジック |
| hot-middleware.ts | `packages/next/src/server/dev/hot-middleware.ts` | ソース | Webpackモードでの送信ロジック |
| hot-reloader-app.tsx | `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` | ソース | App Routerクライアント側処理 |
| hot-reloader-pages.ts | `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` | ソース | Pages Routerクライアント側処理 |
| turbopack-hot-reloader-common.ts | `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` | ソース | TurbopackHmr.onBuilding()の遅延ロジック |
