# 通知設計書 2-実験的機能情報通知

## 概要

本ドキュメントは、Next.jsサーバー起動時に有効化されている実験的機能の一覧をコンソールに出力する通知の設計を記載する。

### 本通知の処理概要

Next.jsの設定ファイルで有効化されている実験的（experimental）機能の一覧と、Cache Components の有効状態をコンソールに出力する通知である。

**業務上の目的・背景**：Next.jsには多数の実験的機能が存在し、開発者がどの機能を有効化しているかを起動時に明示することで、意図しない機能の有効化や、非推奨機能の使用に気付く機会を提供する。実験的機能は安定性が保証されないため、どの機能が有効かを明確にすることは運用上重要である。

**通知の送信タイミング**：サーバー起動後、`getRequestHandlers`による設定読み込みが完了した後に出力される。`logStartInfo`（No.1の通知）の後に呼び出される。ビルド時にも`build/index.ts`から同様に呼び出される。

**通知の受信者**：CLIでNext.jsを起動した開発者。ターミナル/コンソールを通じて情報を受け取る。

**通知内容の概要**：Cache Componentsの有効状態、有効化されている実験的機能のキー名・値・理由。無効な実験的キーが指定されている場合は取り消し線付きで警告表示される。

**期待されるアクション**：開発者は表示された実験的機能の一覧を確認し、意図しない機能が有効になっていないかを検証する。無効なキーが表示された場合は設定ファイルを修正する。

## 通知種別

コンソール出力（標準出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

サーバープロセスを起動したターミナルの標準出力に対して、実験的機能が1つ以上有効化されている場合、またはCache Componentsが有効な場合に出力される。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | Next.jsサーバープロセス |
| 出力先 | `console.log`（標準出力） |
| 形式 | ANSIカラー付きテキスト |

### 本文テンプレート

```
- Cache Components enabled
- Experiments (use with caution):
  ✓ {experimentKey}
  ⨯ {experimentKey}
  · {experimentKey}: {value}
  ? {invalidKey} (invalid experimental key)
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cacheComponents | Cache Components有効フラグ | `initResult.cacheComponents` | No |
| experimentalFeatures | 実験的機能リスト | `initResult.experimentalFeatures` | No |
| experimentalFeatures[].key | 実験的機能キー名 | `ConfiguredExperimentalFeature.key` | Yes（機能ごと） |
| experimentalFeatures[].value | 機能の設定値 | `ConfiguredExperimentalFeature.value` | Yes（機能ごと） |
| experimentalFeatures[].reason | 有効化の理由 | `ConfiguredExperimentalFeature.reason` | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー起動 | `getRequestHandlers`完了後 | 開発モード時のみ | `start-server.ts`行469-473 |
| ビルド実行 | ビルド処理中 | 無条件 | `build/index.ts`行1170-1173 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 実験的機能なし かつ Cache Components無効 | 両方とも空/falseの場合、Experimentsセクション自体が出力されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[設定読み込み完了] --> B[logExperimentalInfo呼び出し]
    B --> C{cacheComponents?}
    C -->|true| D[Cache Components enabled出力]
    C -->|false| E{experimentalFeatures?}
    D --> E
    E -->|あり| F[Experiments見出し出力]
    F --> G[各機能をループ]
    G --> H{experimentalSchemaに存在?}
    H -->|Yes| I[値に応じた記号で出力]
    H -->|No| J[取り消し線で無効キー出力]
    I --> G
    J --> G
    E -->|なし| K[空行出力]
    G --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効な実験的キー | `experimentalSchema`に存在しないキーが指定された場合 | 取り消し線付きで"(invalid experimental key)"を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（起動時に1回のみ出力） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- 実験的機能のキー名と値のみが出力される。機密情報は含まれない。
- 実験的機能の設定値が文字列やオブジェクトの場合はJSON文字列化されて出力される。

## 備考

- 出力記号の意味：`✓`=boolean true、`⨯`=boolean false、`·`=number/string値
- `logExperimentalInfo`の末尾で`Log.info('')`が呼ばれ、ブートストラップ情報の後に空行が挿入される
- `experimentalSchema`はNext.jsの設定スキーマで定義された有効な実験的キーの集合

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.ts | `packages/next/src/server/config.ts` | `ConfiguredExperimentalFeature`型の定義。key, value, reasonフィールド |
| 1-2 | config-schema.ts | `packages/next/src/server/config-schema.ts` | `experimentalSchema`オブジェクトで有効な実験的キーを定義 |

**読解のコツ**: `ConfiguredExperimentalFeature`は`app-info-log.ts`でre-exportされている（行9）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | start-server.ts | `packages/next/src/server/lib/start-server.ts` | 行469-473で開発モード時に`logExperimentalInfo`を呼び出し |
| 2-2 | index.ts | `packages/next/src/build/index.ts` | 行1170-1173でビルド時に`logExperimentalInfo`を呼び出し |

**主要処理フロー**:
1. **行450-462**: `getRequestHandlers`で設定読み込み。`initResult`に実験的機能情報が含まれる
2. **行469**: 開発モード判定
3. **行470-473**: `logExperimentalInfo`に`experimentalFeatures`と`cacheComponents`を渡す

#### Step 3: 通知出力の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | app-info-log.ts | `packages/next/src/server/lib/app-info-log.ts` | `logExperimentalInfo`関数（行70-114）。各機能の出力ロジック |

**主要処理フロー**:
- **行77-79**: `cacheComponents`がtrueなら"Cache Components enabled"出力
- **行81-82**: 実験的機能が1つ以上あれば見出し出力
- **行83-109**: 各機能をループし、`experimentalSchema`での有効性チェック後に出力
- **行89-94**: 値の型に応じた記号決定（boolean→`✓`/`⨯`、その他→`·`）
- **行104-107**: 無効なキーは取り消し線付きで出力
- **行113**: 空行を挿入して視覚的区切り

### プログラム呼び出し階層図

```
startServer (start-server.ts:470)
    │
    └─ logExperimentalInfo({...}) (app-info-log.ts:70)
           ├─ Log.bootstrap() - "Cache Components enabled"
           ├─ Log.bootstrap() - "Experiments (use with caution):"
           ├─ [loop] experimentalFeatures
           │      ├─ experimentalSchema.hasOwnProperty(key) チェック
           │      ├─ Log.bootstrap() - "✓/⨯/· {key}{suffix}{reason}"
           │      └─ Log.bootstrap() - "? {key} (invalid)"
           └─ Log.info('') - 空行
```

### データフロー図

```
[入力]                             [処理]                           [出力]

initResult.experimentalFeatures ──┐
                                  ├── logExperimentalInfo() ───▶ console.log (stdout)
initResult.cacheComponents ───────┘
                                        │
experimentalSchema ────────────────────┘ (有効性検証)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| app-info-log.ts | `packages/next/src/server/lib/app-info-log.ts` | ソース | 実験的機能ログ出力の実装 |
| start-server.ts | `packages/next/src/server/lib/start-server.ts` | ソース | 開発サーバーからの呼び出し元 |
| index.ts | `packages/next/src/build/index.ts` | ソース | ビルド時の呼び出し元 |
| config-schema.ts | `packages/next/src/server/config-schema.ts` | ソース | experimentalSchemaの定義 |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
| picocolors | `packages/next/src/lib/picocolors.ts` | ソース | ANSIカラー装飾ユーティリティ |
