# 通知設計書 32-型チェック中通知

## 概要

本ドキュメントは、Next.js開発サーバーにおける型チェック中通知の設計について記載する。バンドル処理が完了した後にTypeScriptの型チェックが進行中であることをコンソールに出力する通知機能である。

### 本通知の処理概要

型チェック中通知は、コンパイル（バンドル）が完了したものの、TypeScriptの型チェックがまだ進行中である状態を開発者に伝える機能である。

**業務上の目的・背景**：Next.jsではTypeScriptの型チェックをバンドル処理と並行して実行する。バンドルが先に完了した場合、ページは既に表示可能な状態であるが、型エラーがまだ検出されていない可能性がある。この通知により、開発者はバンドルは完了しているが型チェックがまだ進行中であることを認識でき、型エラーが後から報告される可能性があることを理解できる。

**通知の送信タイミング**：`OutputState`の`typeChecking`フラグが`true`の場合、すなわちバンドル完了後に型チェックが未完了の状態で送信される。コンパイルが完了し、エラーも警告もないが、型チェックがまだ進行中のタイミングである。

**通知の受信者**：開発サーバーを起動しているターミナルを監視している開発者。コンソール出力（`console.log`）を通じてメッセージが表示される。

**通知内容の概要**：「bundled {トリガーパス}{所要時間}{モジュール数}, type checking...」という形式のメッセージが出力される。トリガーパスはコンパイルを起動したルート、所要時間はコンパイル開始からの経過時間、モジュール数はバンドルされたモジュールの総数を示す。

**期待されるアクション**：開発者はバンドルが完了したことを確認し、ページへのアクセスが可能であることを認識する。型チェック完了を待って、型エラーが報告されないかを確認する。

## 通知種別

コンソール出力（サーバーサイドターミナル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（storeサブスクリプション内で即時出力） |
| 優先度 | 低 |
| リトライ | 無し（コンソール出力のため） |

### 送信先決定ロジック

開発サーバープロセスの標準出力（`console.log`）に直接出力される。`Log.info()`を使用するため、`console.log`メソッドが呼ばれる。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stdout（console.log） |
| プレフィックス | ` `（白色太字スペース） |
| 形式 | テキスト |

### 本文テンプレート

```
  bundled {trigger} in {time}{modules}, type checking...
```

具体例：
```
  bundled /dashboard in 1.2s (150 modules), type checking...
  bundled /api/users in 450ms (80 modules), type checking...
```

### 添付ファイル

該当なし（コンソール出力のため添付ファイルは存在しない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| trigger | コンパイルをトリガーしたルートパス | formatTrigger(state.trigger) | Yes |
| timeMessage | コンパイル所要時間 | Date.now() - startTime | No（startTimeが0の場合は空文字） |
| modulesMessage | バンドルされたモジュール数 | state.totalModulesCount | No（0の場合は空文字） |
| typeChecking | 型チェック進行中フラグ | OutputState.typeChecking | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| storeサブスクリプション | OutputState変更 | `state.typeChecking === true` | バンドル完了後、型チェックが進行中の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| logging === false | `state.logging`がfalseの場合、すべてのログ出力が抑止される |
| state.bootstrap === true | ブートストラップ中は出力されない |
| state.loading === true | コンパイル中（loading状態）では出力されない |
| state.errors !== null | エラーが存在する場合はエラー出力が優先される |
| state.warnings !== null | 警告が存在する場合は警告出力が優先される |
| stateが変更されていない | `hasStoreChanged()`がfalseを返す場合、重複出力を防ぐ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OutputState変更] --> B{logging有効?}
    B -->|No| Z[出力なし]
    B -->|Yes| C{state変更あり?}
    C -->|No| Z
    C -->|Yes| D{bootstrap中?}
    D -->|Yes| Z
    D -->|No| E{loading中?}
    E -->|Yes| F[loading処理]
    E -->|No| G{errors存在?}
    G -->|Yes| H[エラー出力]
    G -->|No| I[timeMessage計算]
    I --> J[modulesMessage計算]
    J --> K{warnings存在?}
    K -->|Yes| L[警告出力]
    K -->|No| M{typeChecking?}
    M -->|Yes| N[Log.info で型チェック中通知出力]
    M -->|No| O[コンパイル完了処理]
    N --> P[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない。インメモリのstoreのみを参照する）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンソール出力失敗 | 標準出力がリダイレクトされている等の理由で出力に失敗 | Node.jsランタイムレベルのエラーとなり、通常は発生しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（開発サーバー稼働中は常時出力可能）

## セキュリティ考慮事項

- コンソール出力はローカル開発環境のみで使用されるため、個人情報漏洩のリスクは低い
- トリガーパスにはルートパスが含まれるが、ローカル環境の開発用パスであるため問題はない

## 備考

- 所要時間が2秒を超える場合は秒単位（例: `in 1.2s`）、2秒以下の場合はミリ秒単位（例: `in 450ms`）で表示される
- `formatTrigger()`関数により、動的サイトマップルート（例: `/sitemap.xml[__metadata_id__]`）は簡略化されて表示される（例: `/sitemap.xml/[id]`）
- 型チェック中通知の後、型チェックが完了すると別のstate更新が行われ、正常完了またはエラーが出力される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンパイル状態を管理するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | store.ts | `packages/next/src/build/output/store.ts` | `OutputState`型定義（8-34行目）。特に`loading: false`時の`typeChecking: boolean`フィールドに注目 |

**読解のコツ**: `typeChecking`フィールドは`loading: false`かつ`bootstrap: false`の場合のみ存在する。これはバンドル処理が完了した状態を意味する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | store.ts | `packages/next/src/build/output/store.ts` | `store.subscribe()`（84行目）。状態変更監視のコールバック全体の流れを把握する |

**主要処理フロー**:
1. **144-152行目**: `timeMessage`の計算。`startTime`が設定されている場合、経過時間を計算する
2. **154-157行目**: `modulesMessage`の計算。`totalModulesCount`が存在する場合にモジュール数を文字列化
3. **167-172行目**: `state.typeChecking`がtrueの場合、`Log.info()`で型チェック中メッセージを出力

#### Step 3: ログ出力ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | log.ts | `packages/next/src/build/output/log.ts` | `info()`関数（65-67行目）。`prefixedLog('info', ...)`を呼び出す |

**主要処理フロー**:
- **65行目**: `info()`は`prefixedLog('info', ...message)`を呼び出す
- **9行目**: infoプレフィックスは`white(bold(' '))`（白太字スペース）

#### Step 4: トリガー名のフォーマットを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | store.ts | `packages/next/src/build/output/store.ts` | `formatTrigger()`関数（36-47行目）。動的メタデータルートの簡略化処理 |

### プログラム呼び出し階層図

```
store.subscribe() [store.ts:84]
    |
    +-- hasStoreChanged() [store.ts:62]
    |
    +-- formatTrigger() [store.ts:36]
    |
    +-- Log.info() [log.ts:65]
    |      +-- prefixedLog('info', ...) [log.ts:20]
    |             +-- console.log() [Node.js built-in]
```

### データフロー図

```
[入力]                      [処理]                              [出力]

コンパイラ完了           store.subscribe()                    コンソール
(typeChecking=true) --> timeMessage計算                  --> console.log()
                        modulesMessage計算                    " bundled /path in Xms (N modules), type checking..."
                        Log.info() 呼び出し
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| store.ts | `packages/next/src/build/output/store.ts` | ソース | OutputStateの定義とstoreサブスクリプション。型チェック中通知の判定と出力ロジック |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | コンソール出力ユーティリティ。プレフィックス付きログ出力 |
