# 通知設計書 33-ビルドエラーオーバーレイ

## 概要

本ドキュメントは、Next.js開発サーバーにおけるビルドエラーオーバーレイの設計について記載する。ビルドエラー発生時にブラウザ上にエラー詳細をオーバーレイ表示する通知機能である。

### 本通知の処理概要

ビルドエラーオーバーレイは、コンパイル時にシンタックスエラーや設定エラーなどのビルドエラーが発生した場合、ブラウザ画面上にオーバーレイダイアログとしてエラーの詳細情報を表示する機能である。

**業務上の目的・背景**：開発中にビルドエラーが発生した場合、開発者がターミナルを確認しなくても、ブラウザ上で即座にエラー内容を把握できるようにすることが目的である。これにより、ターミナルとブラウザ間の切り替え頻度を削減し、エラー修正のサイクルを高速化する。

**通知の送信タイミング**：開発サーバーのコンパイル処理でビルドエラーが発生し、`OverlayState.buildError`が非nullに設定された場合に表示される。WebSocket経由でブラウザにエラーメッセージが送信され、Dev Overlayコンポーネントが描画される。

**通知の受信者**：開発中のアプリケーションをブラウザで表示している開発者。Dev Overlayはブラウザ上のReactコンポーネントとして描画される。

**通知内容の概要**：エラーの種別（Build Error）、エラーメッセージ（ファイルパス、行番号、カラム番号、エラー説明）、コードフレーム（エラー箇所周辺のソースコード）がTerminalコンポーネントを通じて表示される。また、Next.jsのバージョン情報とバンドラー名も含まれる。

**期待されるアクション**：開発者はオーバーレイに表示されたエラー情報（ファイルパス、行番号、エラーメッセージ）を確認し、該当するソースコードを修正する。修正後、HMRによりコンパイルが再実行され、エラーが解消されればオーバーレイは自動的に閉じられる。

## 通知種別

ブラウザUI / Dev Overlay（オーバーレイダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket経由でエラーメッセージ受信後、Reactコンポーネントで描画） |
| 優先度 | 高（ビルドエラーはランタイムエラーに優先して表示される） |
| リトライ | 無し（WebSocket接続が確立されている限り表示される） |

### 送信先決定ロジック

WebSocket接続中の全ブラウザクライアントに対してエラーメッセージがブロードキャストされる。クライアント側のDev Overlay内の`ErrorOverlay`コンポーネントが`state.buildError`を監視し、非nullの場合に`BuildError`コンポーネントを描画する。

## 通知テンプレート

### ブラウザUI表示の場合

| 項目 | 内容 |
|-----|------|
| ヘッダーラベル | Build Error |
| エラーメッセージ | エラーテキスト（ANSIエスケープコード除去済み） |
| コードフレーム | Terminalコンポーネントでソースコード表示 |
| 形式 | HTMLオーバーレイ |

### 本文テンプレート

```
[Build Error]
{errorText}

--- Terminal ---
{filePath}:{lineNumber}:{columnNumber}
{errorDescription}
> {errorLine}
  {errorPointer}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | ビルドエラーの全文メッセージ | OverlayState.buildError | Yes |
| formattedMessage | ANSIコード除去後のエラーテキスト | getErrorTextFromBuildErrorMessage(message) | Yes |
| versionInfo.installed | インストール済みNext.jsバージョン | OverlayState.versionInfo | Yes |
| __NEXT_BUNDLER | バンドラー名（Webpack/Turbopack） | process.env.__NEXT_BUNDLER | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| WebSocketメッセージ | コンパイルエラー発生 | state.buildError !== null | コンパイラがエラーを報告し、OverlayStateが更新された場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| state.buildError === null | ビルドエラーがない場合はオーバーレイは表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンパイルエラー発生] --> B[WebSocket経由でエラーメッセージ送信]
    B --> C[クライアント: OverlayState.buildError更新]
    C --> D[ErrorOverlayコンポーネント描画判定]
    D --> E{buildError !== null?}
    E -->|Yes| F[BuildErrorコンポーネント描画]
    E -->|No| G[表示なし]
    F --> H[getErrorTextFromBuildErrorMessageでメッセージ整形]
    H --> I[ErrorOverlayLayoutで全体レイアウト構築]
    I --> J[Terminalコンポーネントでコードフレーム表示]
    J --> K[ブラウザにオーバーレイ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| WebSocket切断 | ブラウザとサーバー間の接続が切断 | 再接続後にエラー状態が再送される |
| メッセージパース失敗 | エラーメッセージのフォーマットが想定外 | formattedMessageがフォールバック値「Failed to compile」を使用（build-error.tsx 36行目） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（WebSocket接続レベルでの再接続は別途管理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（開発サーバー稼働中は常時表示可能）

## セキュリティ考慮事項

- ビルドエラーにはファイルパスやソースコードの断片が含まれるが、開発環境のみで使用されるため問題はない
- Dev Overlayは本番ビルドには含まれない
- `generateErrorInfo()`で生成されるエラー情報はAIアシスタントへの問い合わせに使用される可能性があるが、ローカル開発環境の情報に限定される

## 備考

- `BuildError`コンポーネントは`onClose`にnoop関数を設定しており、ビルドエラーは手動で閉じることができない（エラー修正によるコンパイル成功でのみ解消される）
- `rendered`プロパティは強制的にtrueに設定され、アニメーションなしで即座に表示される
- `getErrorTextFromBuildErrorMessage()`は複数行メッセージの2行目（エラー説明行）を抽出し、先頭の「Error: 」プレフィックスを除去する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オーバーレイの状態管理に使われるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | `ErrorBaseProps`インターフェース（16-22行目）と`ErrorOverlay`コンポーネントのprops定義。`OverlayState`の`buildError`フィールドに注目 |

**読解のコツ**: `ErrorOverlay`は`state.buildError !== null`と`runtimeErrors.length > 0`の2つの分岐で表示内容を切り替える。ビルドエラーが優先される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | `ErrorOverlay`コンポーネント（24-87行目）。52行目の`state.buildError !== null`チェックがビルドエラー表示のトリガー |

**主要処理フロー**:
1. **37行目**: `isTurbopack`フラグの判定
2. **40-42行目**: `useDelayedRender`フックでアニメーション制御
3. **52行目**: `state.buildError !== null`のチェック
4. **54-60行目**: `BuildError`コンポーネントの描画（`rendered`は強制true）

#### Step 3: BuildErrorコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` | `BuildError`コンポーネント（29-77行目）。メッセージの整形ロジックとレイアウト構築 |

**主要処理フロー**:
- **11-27行目**: `getErrorTextFromBuildErrorMessage()`でエラーメッセージの2行目を抽出
- **33行目**: `onClose`にnoop関数（閉じるボタン無効化）
- **35-37行目**: `formattedMessage`の計算。フォールバック値は「Failed to compile」
- **40-63行目**: `generateErrorInfo()`でAIアシスタント用のエラー情報生成
- **66-76行目**: `ErrorOverlayLayout`と`Terminal`でUI構築

#### Step 4: レイアウトコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | error-overlay-layout.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay-layout/error-overlay-layout.tsx` | `ErrorOverlayLayout`コンポーネント（58-180行目）。ダイアログ全体のレイアウト構造 |

### プログラム呼び出し階層図

```
ErrorOverlay [error-overlay.tsx:24]
    |
    +-- useDelayedRender() [hooks]
    |
    +-- BuildError [build-error.tsx:29]
           |
           +-- getErrorTextFromBuildErrorMessage() [build-error.tsx:11]
           |      +-- stripAnsi() [compiled module]
           |
           +-- generateErrorInfo() [build-error.tsx:40]
           |
           +-- ErrorOverlayLayout [error-overlay-layout.tsx:58]
           |      +-- ErrorOverlayNav
           |      +-- ErrorOverlayDialog
           |      +-- ErrorTypeLabel
           |      +-- ErrorMessage
           |      +-- ErrorOverlayToolbar
           |
           +-- Terminal [terminal component]
```

### データフロー図

```
[入力]                       [処理]                              [出力]

WebSocket                  OverlayState更新                    ブラウザ
(buildError msg)  ------>  ErrorOverlay判定            ------>  オーバーレイ
                           BuildError描画                       ダイアログ
                           getErrorTextFromBuildErrorMessage    (エラー詳細 +
                           ErrorOverlayLayout                    コードフレーム)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build-error.tsx | `packages/next/src/next-devtools/dev-overlay/container/build-error.tsx` | ソース | BuildErrorコンポーネント。エラーメッセージ整形とUI構築 |
| error-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` | ソース | ErrorOverlayコンポーネント。ビルドエラーとランタイムエラーの振り分け |
| error-overlay-layout.tsx | `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay-layout/error-overlay-layout.tsx` | ソース | オーバーレイダイアログの全体レイアウト |
