# 通知設計書 39-Toastメッセージ

## 概要

本ドキュメントは、Next.js開発サーバーにおけるToastメッセージの設計について記載する。開発中の軽微な通知をToast形式でブラウザに表示する通知機能である。

### 本通知の処理概要

Toastメッセージは、ブラウザ画面の端に一時的なメッセージを表示する汎用的な通知コンポーネントである。Dev Overlay内で使用され、軽微な情報やステータス変更を開発者に伝える。

**業務上の目的・背景**：開発中に発生する軽微なイベント（エラー数の表示、接続状態の変化など）をフルスクリーンのオーバーレイダイアログではなく、控えめなToast形式で通知することで、開発者の作業を中断させずに情報を提供する。ユーザー体験を損なわない形での非侵入的な通知を実現するためのコンポーネントである。

**通知の送信タイミング**：Dev Overlay内の各種機能がToastコンポーネントを使用するタイミングで表示される。具体的には、ランタイムエラーが存在する場合のエラー数表示などに使用される。

**通知の受信者**：開発中のアプリケーションをブラウザで表示している開発者。

**通知内容の概要**：Toastコンポーネント自体は汎用的なコンテナであり、children propに渡された任意のReactノードをToast形式で表示する。スタイリングは`nextjs-toast` CSSクラスで制御される。クリックイベントハンドラにより、Toast内のリンク以外の部分をクリックした場合にカスタムアクション（例：エラーオーバーレイの展開）を実行できる。

**期待されるアクション**：開発者はToastメッセージの内容を確認する。クリック可能な場合はクリックして詳細情報（例：エラーオーバーレイ）を表示する。

## 通知種別

ブラウザUI / Dev Overlay（Toast通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Reactコンポーネント描画） |
| 優先度 | 低（非侵入的な通知） |
| リトライ | 無し |

### 送信先決定ロジック

Toastコンポーネントは汎用コンテナとして設計されており、親コンポーネントがchildren propとonClick propを渡すことで表示内容とクリック時の動作を制御する。

## 通知テンプレート

### ブラウザUI表示の場合

| 項目 | 内容 |
|-----|------|
| CSSクラス | nextjs-toast（追加のclassNameも適用可能） |
| クリック挙動 | リンク（`<a>`タグ）以外のクリックでonClickコールバックを実行 |
| 形式 | 画面端の小さなバナー |

### 本文テンプレート

Toast自体はテンプレートを持たない。childrenに渡されたReactノードがそのまま表示される。

使用例（エラー数表示）：
```
⨯ {errorCount} error(s)
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| children | Toast内に表示するReactノード | 親コンポーネントから渡される | No |
| onClick | クリック時のコールバック関数 | 親コンポーネントから渡される | No |
| className | 追加のCSSクラス名 | 親コンポーネントから渡される | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンポーネント描画 | 親コンポーネントによる描画 | 親コンポーネントが表示を決定した場合 | Toastコンポーネント自体はトリガー制御を行わない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 親コンポーネントがToastを描画しない場合 | Toast表示の制御は親コンポーネントに委ねられている |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[親コンポーネントがToast描画を決定] --> B[Toast コンポーネント描画]
    B --> C[children を div 内に表示]
    C --> D{ユーザークリック?}
    D -->|Yes| E{クリック先はリンク?}
    E -->|Yes| F[リンクのデフォルト動作]
    E -->|No| G[e.preventDefault + onClick実行]
    D -->|No| H[表示を維持]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| onClick未定義 | onClickが渡されていない場合 | オプショナルチェーン（`onClick?.()`）により安全にスキップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（開発サーバー稼働中は常時表示可能）

## セキュリティ考慮事項

- Toastはdev-overlay内の汎用コンテナであり、childrenの内容は呼び出し元が制御する
- Dev Overlayは本番ビルドには含まれない
- クリックハンドラ内で`e.target`の`closest('a')`チェックにより、リンクの通常動作を妨げない設計になっている

## 備考

- Toastコンポーネントは`React.forwardRef`を使用しており、親コンポーネントからrefを通じてDOM要素にアクセスできる
- `cx()`ユーティリティで`nextjs-toast`と追加のclassNameを結合する
- Toastのスタイル（位置、サイズ、アニメーション等）はerrors.tsxの`styles`内に定義されている（`.nextjs-toast-errors-parent`, `.nextjs-toast-errors`等）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Toastコンポーネントのprops型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | toast.tsx | `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` | `ToastProps`型定義（3-7行目）。`HTMLProps<HTMLDivElement>`を拡張し、`children`, `onClick`, `className`を持つ |

**読解のコツ**: Toastは非常にシンプルなコンポーネントであり、状態管理を持たない。表示制御は完全に親コンポーネントに委ねられている。

#### Step 2: コンポーネント実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | toast.tsx | `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` | `Toast`コンポーネント（9-27行目）。`React.forwardRef`で定義。クリックハンドラのロジック |

**主要処理フロー**:
1. **9行目**: `React.forwardRef`で外部からのref受け取りを可能にする
2. **15-16行目**: クリックイベントで`closest('a')`チェック。リンク内クリックの場合はpreventDefaultしない
3. **19行目**: `onClick?.()`でオプショナルにコールバックを実行
4. **21行目**: `cx('nextjs-toast', className)`でCSSクラスを結合

### プログラム呼び出し階層図

```
親コンポーネント（例: ErrorOverlay内）
    |
    +-- Toast [toast.tsx:9]
           +-- React.forwardRef
           +-- cx('nextjs-toast', className) [utils/cx]
           +-- onClick handler
                  +-- closest('a') チェック
                  +-- onClick?.() コールバック
```

### データフロー図

```
[入力]                       [処理]                              [出力]

親コンポーネント            Toast コンポーネント               ブラウザ
(children,         ------>  div.nextjs-toast 描画        ----> 画面端の
 onClick,                   クリックイベント処理                Toast バナー
 className)                                                    (children表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| toast.tsx | `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` | ソース | Toastコンポーネント本体 |
| errors.tsx | `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` | ソース | Toast関連のCSSスタイル定義（.nextjs-toast-errors-parent等） |
