# 通知設計書 4-Turbopack未対応設定警告

## 概要

本ドキュメントは、Turbopack使用時にサポートされていないnext.config.jsの設定オプションが検出された場合にコンソールへ出力される警告通知の設計を記載する。

### 本通知の処理概要

Turbopackビルド使用時に、next.config.jsで設定されたオプションのうちTurbopackが未サポートの項目を検出し、該当項目を無視する旨の警告とTurbopack設定ドキュメントへのリンクをコンソールに出力する。

**業務上の目的・背景**：Next.jsはWebpackからTurbopackへのバンドラー移行を進めているが、一部の設定オプションはTurbopackでは未サポートである。開発者が意図せず無視される設定を使用していることを早期に検出し、設定の見直しやTurbopack向けの代替設定への移行を促すことが目的である。

**通知の送信タイミング**：開発サーバー起動時（`start-server.ts`内、`getRequestHandlers`完了後）およびTurbopackビルド時（`turbopack-build/impl.ts`、`turbopack-analyze/index.ts`）に`validateTurboNextConfig`関数が呼び出された際に出力される。

**通知の受信者**：Turbopackを使用してNext.jsを起動またはビルドする開発者。ターミナル/コンソールを通じて情報を受け取る。

**通知内容の概要**：未サポートのnext.config.jsオプションの一覧（赤色表示）と、Turbopack設定ドキュメントへのURL。

**期待されるアクション**：開発者は警告された設定項目を確認し、Turbopack向けの代替設定に移行するか、該当設定が不要であれば削除する。

## 通知種別

コンソール出力（標準エラー出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

Turbopackが有効な環境（`process.env.TURBOPACK`が設定）で、未サポート設定が検出された場合に自動出力される。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | Next.jsサーバープロセス |
| 出力先 | `Log.error` / `Log.warn`（標準エラー出力） |
| 形式 | ANSIカラー付きテキスト |

### 本文テンプレート

```
⨯ You are using configuration and/or tools that are not yet
supported by Next.js with Turbopack:

- Unsupported Next.js configuration option(s) (next.config.js)
  Turbopack will ignore the following configuration options:
    - {unsupportedOption1}
    - {unsupportedOption2}

⚠ Learn more about how to configure Turbopack with Next.js:
https://nextjs.org/docs/app/api-reference/config/next-config-js/turbopack
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| unsupportedOptions | 未サポート設定項目リスト | next.config.jsの解析結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー起動 | 開発サーバー起動時 | `process.env.TURBOPACK && isDev` | start-server.ts行478-483 |
| ビルド実行 | Turbopackビルド時 | Turbopack使用時 | turbopack-build/impl.ts行31 |
| ビルド解析 | Turbopack解析時 | Turbopack使用時 | turbopack-analyze/index.ts行28 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 未サポート設定なし | `unsupportedConfig`配列が空の場合、警告は出力されない |
| Turbopack未使用 | Turbopackが有効でない場合、関数自体が呼び出されない |
| デフォルト値と同一 | 設定値がデフォルト値と同一の場合、未サポートとみなさない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[validateTurboNextConfig呼び出し] --> B[rawNextConfig読み込み]
    B --> C[設定キーをフラット化]
    C --> D[各キーをループ]
    D --> E{unsupportedTurbopackNextConfigOptionsに含まれる?}
    E -->|Yes| F{デフォルト値と異なる?}
    F -->|Yes| G[unsupportedConfigに追加]
    F -->|No| D
    E -->|No| D
    G --> D
    D --> H{unsupportedConfig非空?}
    H -->|Yes| I[Log.errorで未サポート設定を出力]
    I --> J[Log.warnでドキュメントURLを出力]
    H -->|No| K[終了]
    J --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定読み込みエラー | next.config.jsの解析に失敗 | `Log.error('Unexpected error occurred while checking config', e)`を出力し処理続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（起動/ビルド時に1回のみ） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- 設定のキー名のみが出力され、設定値は出力されない
- next.config.jsのパス情報等の機密情報は含まれない

## 備考

- 未サポートオプションのリストは`unsupportedTurbopackNextConfigOptions`配列（turbopack-warning.ts行5-39）にハードコードされている
- `flattenKeys`関数でネストされた設定を`.`区切りのフラットなキーに展開している
- 設定値がデフォルト値と同じ場合は未サポートとみなさない設計（行134）
- この通知はプロセスを終了させない（No.5のWebpack設定エラーとは異なる）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | turbopack-warning.ts | `packages/next/src/lib/turbopack-warning.ts` | `unsupportedTurbopackNextConfigOptions`配列（行5-39）で未サポート項目のリストを把握 |

**読解のコツ**: コメントアウトされた項目はかつて未サポートだったが現在はサポート済み、または実装予定の項目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | start-server.ts | `packages/next/src/server/lib/start-server.ts` | 行478-483で開発モードかつTurbopack時に呼び出し |
| 2-2 | impl.ts | `packages/next/src/build/turbopack-build/impl.ts` | 行31でビルド時に呼び出し |

**主要処理フロー**:
1. **行478**: `process.env.TURBOPACK && isDev`の条件判定
2. **行479-482**: `validateTurboNextConfig`に`dir`と`configPhase`を渡す

#### Step 3: 検証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | turbopack-warning.ts | `packages/next/src/lib/turbopack-warning.ts` | `validateTurboNextConfig`関数（行42-191）全体のフロー |

**主要処理フロー**:
- **行64-69**: `loadConfig`でrawNextConfigを読み込み
- **行79-102**: `flattenKeys`でネスト設定をフラット化
- **行104-112**: `getDeepValue`でネスト値を取得するヘルパー
- **行114-139**: 各キーについて未サポートリストとの照合、デフォルト値との比較
- **行169-175**: 未サポート設定がある場合にエラーメッセージを構築
- **行177-188**: `Log.error`と`Log.warn`で出力

### プログラム呼び出し階層図

```
startServer (start-server.ts:479)
    │
    └─ validateTurboNextConfig({dir, configPhase}) (turbopack-warning.ts:42)
           ├─ loadConfig(configPhase, dir, {rawConfig: true}) (行66)
           ├─ flattenKeys(rawNextConfig) (行114)
           ├─ [loop] unsupportedTurbopackNextConfigOptions照合 (行116-139)
           ├─ Log.error() - 未サポート設定リスト出力 (行178-179)
           └─ Log.warn() - ドキュメントURL出力 (行182-188)
```

### データフロー図

```
[入力]                              [処理]                              [出力]

next.config.js ──────────────┐
                              ├── validateTurboNextConfig() ───▶ console.error (stderr)
defaultConfig ────────────────┤
                              │
unsupportedTurbopack...[] ────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| turbopack-warning.ts | `packages/next/src/lib/turbopack-warning.ts` | ソース | 検証ロジックと警告出力の実装 |
| start-server.ts | `packages/next/src/server/lib/start-server.ts` | ソース | 開発サーバーからの呼び出し元 |
| impl.ts | `packages/next/src/build/turbopack-build/impl.ts` | ソース | Turbopackビルドからの呼び出し元 |
| index.ts | `packages/next/src/build/turbopack-analyze/index.ts` | ソース | Turbopack解析からの呼び出し元 |
| config-shared.ts | `packages/next/src/server/config-shared.ts` | ソース | defaultConfigの提供 |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
