# 通知設計書 44-DevIndicator状態通知

## 概要

本ドキュメントは、Next.jsの開発サーバーにおけるDevIndicator状態通知の設計について記述する。開発インジケーター（Dev Indicator）の状態情報をサーバーからブラウザへWebSocket経由でHMRメッセージ（`DEV_INDICATOR`相当の情報を`SYNC`メッセージに含める形式）で送信し、ブラウザ側のDev Overlayにおける開発インジケーターの表示/非表示状態を制御する仕組みを定義する。

### 本通知の処理概要

DevIndicator状態通知は、開発サーバーの`devIndicatorServerState`（無効化タイムスタンプ）をブラウザに伝達するためのHMR通知である。この通知はSYNCメッセージの`devIndicator`フィールドに含まれる形で送信される。ブラウザ側のDev Overlayは受信した状態情報に基づき、開発インジケーター（Next.jsロゴアイコン）の表示/非表示を制御する。ユーザーがDev Indicatorを一時的に非表示にした場合、サーバー側で`disabledUntil`タイムスタンプが設定され、クールダウン期間（デフォルト24時間）中はインジケーターが非表示になる。

**業務上の目的・背景**：Next.js開発モードではブラウザ画面にDev Indicator（Next.jsロゴ）が表示され、開発ツールへのアクセスポイントとなる。しかし、UIの確認やスクリーンショット撮影時にインジケーターが邪魔になる場合がある。本通知は、ユーザーがインジケーターを一時的に非表示にした状態をサーバーサイドで管理し、ページリロードやHMR更新後も非表示状態を維持するために必要である。`next.config.js`の`devIndicators: false`による恒久的な無効化とは別に、ランタイムでの一時的な非表示を実現する。

**通知の送信タイミング**：コンパイル完了時のSYNC/BUILTメッセージに`devIndicator`フィールドとして含まれて送信される。SYNCメッセージは初回接続時およびコンパイル完了時に送信されるため、ブラウザが接続するたびに最新のDevIndicator状態が伝達される。

**通知の受信者**：WebSocket経由で開発サーバーに接続されているすべてのブラウザセッション。App RouterとPages Routerの両方で処理される。

**通知内容の概要**：`DevIndicatorServerState`オブジェクトが含まれ、`disabledUntil`フィールド（number型）により無効化の期限を示す。値が0の場合はインジケーターが有効、0より大きくかつ現在時刻以降の場合はインジケーターが無効化されていることを示す。

**期待されるアクション**：ブラウザ側のDev Overlayは、受信した`devIndicator`情報を`ACTION_DEV_INDICATOR`アクションとしてリデューサーにディスパッチする。リデューサーは`showIndicator: true`を設定し、`disableDevIndicator`フラグを`disabledUntil`の値と環境変数`__NEXT_DEV_INDICATOR`の設定に基づいて決定する。

## 通知種別

WebSocket HMRメッセージ（開発サーバー → ブラウザ、SYNCメッセージのフィールドとして送信、JSON形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket HMR経由、SYNCメッセージに含まれて送信） |
| 優先度 | 中（UI制御用途） |
| リトライ | 無（次回SYNC送信時に再送される） |

### 送信先決定ロジック

SYNCメッセージのブロードキャストに含まれるため、開発サーバーに現在WebSocket接続されているすべてのブラウザセッションに自動的に配信される。個別のフィルタリングは行わない。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではない。WebSocket HMRメッセージのフィールドである。

### 本文テンプレート

SYNCメッセージの一部として送信される:

```json
{
  "type": "sync",
  "hash": "{compilationHash}",
  "errors": [],
  "warnings": [],
  "versionInfo": { "installed": "x.x.x", "staleness": "..." },
  "devIndicator": {
    "disabledUntil": 0
  },
  "devToolsConfig": { ... }
}
```

`devIndicator`フィールドの値:
- `disabledUntil: 0` - インジケーター有効
- `disabledUntil: {timestamp}` - 指定時刻まで無効化

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| devIndicator | DevIndicator状態オブジェクト | devIndicatorServerState | Yes |
| devIndicator.disabledUntil | 無効化期限タイムスタンプ（0=有効） | devIndicatorServerState.disabledUntil | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 自動 | コンパイル完了（SYNC送信時） | 常に含まれる | SYNCメッセージの必須フィールド |
| 画面操作 | ユーザーがDev Indicatorを非表示にした | POST /__nextjs_disable_dev_indicator | disabledUntilが更新される |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | SYNCメッセージに常に含まれるため個別の抑止条件はない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンパイル完了] --> B[SYNCメッセージ構築]
    B --> C[devIndicatorServerState参照]
    C --> D[devIndicatorフィールド追加]
    D --> E[WebSocket経由でブロードキャスト]
    E --> F[ブラウザ受信]
    F --> G[dispatcher.onDevIndicator呼び出し]
    G --> H[ACTION_DEV_INDICATOR dispatch]
    H --> I{shouldDisableDevIndicator?}
    I -->|Yes| J[disableDevIndicator = true]
    I -->|No| K{disabledUntil > 0?}
    K -->|Yes| L[disableDevIndicator = true]
    K -->|No| M[disableDevIndicator = false]
    J --> N[showIndicator = true]
    L --> N
    M --> N
    N --> O[Dev Overlay表示/非表示更新]
```

### ユーザーによる非表示操作フロー

```mermaid
flowchart TD
    A[ユーザーがDev Indicator非表示操作] --> B[POST /__nextjs_disable_dev_indicator]
    B --> C[disableDevIndicatorMiddleware処理]
    C --> D[devIndicatorServerState.disabledUntil = Date.now + COOLDOWN_TIME_MS]
    D --> E[204 No Content応答]
    E --> F[次回SYNC時にブラウザへ反映]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。本通知はメモリ内の状態管理のみで動作する。

### 更新テーブル一覧

該当なし。`devIndicatorServerState`はプロセスメモリ内のオブジェクトとして管理される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ミドルウェアエラー | POST /__nextjs_disable_dev_indicatorの処理中に例外発生 | 500 Internal Server Errorを返却、Log.errorでログ出力 |
| 不正メソッド | GET等のPOST以外のHTTPメソッドでアクセス | 405 Method Not Allowedを返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（次回SYNC時に状態が再送される） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（SYNC送信頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。開発サーバーが稼働中であればいつでも利用可能。

### クールダウン設定

| 項目 | 内容 |
|-----|------|
| デフォルトクールダウン時間 | 24時間（1000 * 60 * 60 * 24 ms） |
| カスタム設定 | 環境変数`__NEXT_DEV_INDICATOR_COOLDOWN_MS`で変更可能 |

## セキュリティ考慮事項

- 本通知は開発環境でのみ動作し、本番環境では利用不可
- `/__nextjs_disable_dev_indicator`エンドポイントは認証なしでアクセス可能だが、開発サーバー（localhost）限定のため問題なし
- `devIndicatorServerState`はプロセスメモリに保持されるため、サーバー再起動で状態がリセットされる
- 環境変数`__NEXT_DEV_INDICATOR`による恒久的無効化はビルド時に決定され、ランタイムで変更不可

## 備考

- `COOLDOWN_TIME_MS`のデフォルトは24時間（86,400,000ms）で、環境変数`__NEXT_DEV_INDICATOR_COOLDOWN_MS`で上書き可能
- `next.config.js`の`devIndicators: false`設定は環境変数`__NEXT_DEV_INDICATOR`として伝播し、`shouldDisableDevIndicator`定数で評価される
- Dev IndicatorのデフォルトUI位置は環境変数`__NEXT_DEV_INDICATOR_POSITION`（デフォルト: `bottom-left`）で設定される
- `showIndicator`フラグは初回のDEV_INDICATORアクション受信時に`true`に設定され、フリッカー防止のため初期値は`false`
- App RouterとPages Routerの両方のhot-reloaderでdevIndicatorメッセージが処理される（app: 行313-314、pages: 行304-305）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DevIndicatorServerStateの構造とHMRメッセージでの配置を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dev-indicator-server-state.ts | `packages/next/src/server/dev/dev-indicator-server-state.ts` | `DevIndicatorServerState`型定義と`devIndicatorServerState`オブジェクト（行1-5） |
| 1-2 | hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | `SyncMessage`インターフェースの`devIndicator`フィールド（行83）、`DEV_INDICATOR`定数（行36） |

**読解のコツ**: `devIndicatorServerState`は単純なオブジェクトで`disabledUntil: number`のみを持つ。値が0の場合は有効、Date.now() + COOLDOWN_TIME_MSの値が設定されている場合は無効化中。

#### Step 2: サーバー側の状態管理を理解する

ユーザー操作によるDevIndicator無効化のエンドポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dev-indicator-middleware.ts | `packages/next/src/next-devtools/server/dev-indicator-middleware.ts` | ミドルウェア実装（行13-41）、COOLDOWN_TIME_MS定義（行8-11）、disabledUntil更新（行30） |

**主要処理フロー**:
1. **行20**: URLパスの解析（`/__nextjs_disable_dev_indicator`プレフィックスチェック）
2. **行26**: HTTPメソッドチェック（POSTのみ許可）
3. **行30**: `devIndicatorServerState.disabledUntil = Date.now() + COOLDOWN_TIME_MS`
4. **行32**: 204 No Content応答

#### Step 3: ブラウザ側の状態更新を理解する（App Router）

App RouterのHot ReloaderでのdevIndicatorメッセージ処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hot-reloader-app.tsx | `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` | SYNCメッセージハンドラ内のdevIndicator処理（行313-314） |

**主要処理フロー**:
- **行313**: `'devIndicator' in message` - devIndicatorフィールドの存在チェック
- **行314**: `dispatcher.onDevIndicator(message.devIndicator)` - ディスパッチャー呼び出し

#### Step 4: ブラウザ側の状態更新を理解する（Pages Router）

Pages RouterのHot ReloaderでのdevIndicatorメッセージ処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | hot-reloader-pages.ts | `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` | SYNCメッセージハンドラ内のdevIndicator処理（行304-305） |

#### Step 5: Dev Overlayのリデューサーを理解する

OverlayStateの更新ロジック（ACTION_DEV_INDICATOR）を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | `ACTION_DEV_INDICATOR`定数（行87）、リデューサーの処理（行435-441）、`shouldDisableDevIndicator`定数（行260-261） |

**主要処理フロー**:
- **行260-261**: `shouldDisableDevIndicator`定数の評価（`__NEXT_DEV_INDICATOR === 'false'`）
- **行435-441**: リデューサーの`ACTION_DEV_INDICATOR`ケース
  - `showIndicator: true`を設定
  - `disableDevIndicator`を`shouldDisableDevIndicator || !!action.devIndicator.disabledUntil`で決定

#### Step 6: ディスパッチャーを理解する

Dev Overlayのディスパッチャーでの`onDevIndicator`メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | dev-overlay.browser.tsx | `packages/next/src/next-devtools/dev-overlay.browser.tsx` | `onDevIndicator`メソッド定義（行169-172）、`ACTION_DEV_INDICATOR`ディスパッチ（行171） |

### プログラム呼び出し階層図

```
[SYNCメッセージ送信フロー]
コンパイル完了
    │
    ├─ SyncMessage構築
    │      └─ devIndicator: devIndicatorServerState [hot-reloader-types.ts:83]
    │
    └─ send(action) → WebSocket ブロードキャスト

[ブラウザ受信フロー - App Router]
hot-reloader-app.tsx ハンドラ [行299]
    │
    ├─ SYNC case処理
    │      └─ dispatcher.onDevIndicator(message.devIndicator) [行314]
    │             └─ dispatch({ type: ACTION_DEV_INDICATOR, devIndicator }) [行171]
    │                    └─ shared.ts リデューサー [行435-441]
    │                           ├─ showIndicator = true
    │                           └─ disableDevIndicator = shouldDisableDevIndicator || !!disabledUntil
    │
    └─ Dev Overlay UI更新

[ユーザー非表示操作フロー]
POST /__nextjs_disable_dev_indicator
    │
    └─ disableDevIndicatorMiddleware [dev-indicator-middleware.ts:14]
           └─ devIndicatorServerState.disabledUntil = Date.now() + COOLDOWN_TIME_MS [行30]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

devIndicatorServerState ──▶ SYNCメッセージに含める ──▶ WebSocket送信
  { disabledUntil: 0 }                                      │
                                                             ▼
                                                    ブラウザ Hot Reloader
                                                    dispatcher.onDevIndicator()
                                                             │
                                                             ▼
                                                    ACTION_DEV_INDICATOR
                                                    リデューサー処理
                                                             │
                                                    ┌────────┴────────┐
                                                    ▼                 ▼
                                              showIndicator    disableDevIndicator
                                              = true           = 環境変数 || disabledUntil
                                                    │                 │
                                                    └────────┬────────┘
                                                             ▼
                                                    Dev Overlay UI
                                                    表示/非表示制御

[ユーザー非表示操作]
POST リクエスト ──▶ dev-indicator-middleware ──▶ disabledUntil更新
                                                      │
                                                      ▼
                                              次回SYNC時にブラウザ反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dev-indicator-server-state.ts | `packages/next/src/server/dev/dev-indicator-server-state.ts` | ソース | サーバー側DevIndicator状態定義 |
| dev-indicator-middleware.ts | `packages/next/src/next-devtools/server/dev-indicator-middleware.ts` | ソース | 非表示操作エンドポイントミドルウェア |
| hot-reloader-types.ts | `packages/next/src/server/dev/hot-reloader-types.ts` | ソース | HMRメッセージ型定義（SyncMessage.devIndicator） |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | OverlayState型定義、リデューサー（ACTION_DEV_INDICATOR処理） |
| dev-overlay.browser.tsx | `packages/next/src/next-devtools/dev-overlay.browser.tsx` | ソース | ディスパッチャー（onDevIndicatorメソッド） |
| hot-reloader-app.tsx | `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` | ソース | App Router側SYNCメッセージハンドラ |
| hot-reloader-pages.ts | `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` | ソース | Pages Router側SYNCメッセージハンドラ |
| define-env.ts | `packages/next/src/build/define-env.ts` | ソース | __NEXT_DEV_INDICATOR環境変数の定義 |
