# 通知設計書 5-Webpack設定存在・Turbopack未設定エラー

## 概要

本ドキュメントは、TurbopackがデフォルトビルドとしてWebpack設定が存在するがTurbopack設定がない場合にエラーを出力しプロセスを終了する通知の設計を記載する。

### 本通知の処理概要

Next.js 16以降、Turbopackがデフォルトのバンドラーとなったが、既存プロジェクトにwebpack設定がありTurbopack設定が未設定の場合、設定がサイレントに無視されることを防ぐためにエラーを出力してプロセスを終了する。

**業務上の目的・背景**：Next.js 16ではTurbopackがデフォルトバンドラーとなり、既存のWebpack設定が暗黙的に無視される可能性がある。開発者が意図せず設定が適用されない状態でアプリケーションを実行するリスクを排除するため、明示的にエラーを出力してプロセスを停止し、設定の移行を促す。Webpack設定はプラグインによって追加されている場合もある点を注意喚起する。

**通知の送信タイミング**：`validateTurboNextConfig`関数内で、next.config.jsの解析後にWebpack設定の有無とTurbopack設定の有無をチェックした際に出力される。`process.env.TURBOPACK === 'auto'`（Turbopackが自動選択された場合）にのみ発動する。

**通知の受信者**：Next.jsを起動またはビルドする開発者。ターミナル/コンソールを通じてエラーメッセージを受け取る。

**通知内容の概要**：TurbopackビルドでWebpack設定があるがTurbopack設定がない旨、Next.js 16でのTurbopackデフォルト化の説明、Turbopack設定ドキュメントURL、解決方法（`--turbopack`/`--webpack`フラグの明示的指定、または空のturbopack設定の追加）。

**期待されるアクション**：開発者はWebpack設定をTurbopack向けに移行するか、明示的に`--webpack`フラグを使用するか、空のturbopack設定（`turbopack: {}`）を追加して通知を抑止する。

## 通知種別

コンソール出力（標準エラー出力） + プロセス終了

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（致命的エラー） |
| リトライ | なし（プロセス終了） |

### 送信先決定ロジック

以下のすべての条件を満たす場合に出力される：
1. `process.env.TURBOPACK === 'auto'`（自動選択によるTurbopack使用）
2. `rawNextConfig.webpack`が存在（Webpack設定あり）
3. `rawNextConfig.turbopack`が未設定かつ`experimental.turbo`系のキーもなし

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | Next.jsサーバープロセス |
| 出力先 | `Log.error`（標準エラー出力） |
| 形式 | プレーンテキスト |

### 本文テンプレート

```
⨯ ERROR: This build is using Turbopack, with a `webpack` config and no `turbopack` config.
   This may be a mistake.

   As of Next.js 16 Turbopack is enabled by default and
   custom webpack configurations may need to be migrated to Turbopack.

   NOTE: your `webpack` config may have been added by a configuration plugin.

   To configure Turbopack, see https://nextjs.org/docs/app/api-reference/next-config-js/turbopack

   TIP: Many applications work fine under Turbopack with no configuration,
   if that is the case for you, you can silence this error by passing the
   `--turbopack` or `--webpack` flag explicitly or simply setting an
   empty turbopack config in {configFile} (e.g. `turbopack: {}`).
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| configFile | 設定ファイル名 | `rawNextConfig.configFileName` | No（デフォルト: "your Next config file"） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー起動/ビルド | validateTurboNextConfig実行 | TURBOPACK=auto + webpack設定あり + turbopack設定なし | turbopack-warning.ts行147-167 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| TURBOPACK !== 'auto' | `--turbopack`フラグで明示的に指定された場合は発動しない |
| webpack設定なし | `rawNextConfig.webpack`がfalsyの場合 |
| turbopack設定あり | `rawNextConfig.turbopack`がtruthy、または`experimental.turbo`系のキーが存在する場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[validateTurboNextConfig] --> B[rawNextConfig読み込み]
    B --> C{TURBOPACK === 'auto'?}
    C -->|No| D[このエラーはスキップ]
    C -->|Yes| E{hasWebpackConfig?}
    E -->|No| D
    E -->|Yes| F{hasTurboConfig?}
    F -->|Yes| D
    F -->|No| G[Log.errorでエラーメッセージ出力]
    G --> H[process.exit 1 でプロセス終了]
    D --> I[後続処理へ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 致命的エラー | Webpack設定ありかつTurbopack設定なし | `process.exit(1)`でプロセス終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（プロセス終了のためリトライ不可） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（プロセス終了前の1回のみ） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- 設定ファイル名が出力される可能性があるが、機密情報は含まれない
- プロセスが終了コード1で終了するため、CI/CDパイプラインでは失敗として扱われる

## 備考

- `process.env.TURBOPACK === 'auto'`は、Next.js 16でユーザーが明示的にバンドラーを指定しなかった場合に設定される値
- `--turbopack`フラグで明示指定した場合は`TURBOPACK`が`'auto'`以外となり、このエラーは発動しない
- `--webpack`フラグを明示指定することでTurbopackを無効化することもできる
- `experimental.turbo`で始まるキーもTurbopack設定として認識される（行117-119）
- No.4の未サポート設定警告とは異なり、このエラーはプロセスを終了させる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | turbopack-warning.ts | `packages/next/src/lib/turbopack-warning.ts` | `hasWebpackConfig`（行76）と`hasTurboConfig`（行77）の判定変数 |

**読解のコツ**: `hasTurboConfig`は`rawNextConfig.turbopack`だけでなく、`experimental.turbo`で始まるキーでもtrueになる（行117-119）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | start-server.ts | `packages/next/src/server/lib/start-server.ts` | 行478-483で呼び出し |

**主要処理フロー**:
1. **行478**: `process.env.TURBOPACK && isDev`の条件判定
2. **行479-482**: `validateTurboNextConfig`呼び出し

#### Step 3: エラー判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | turbopack-warning.ts | `packages/next/src/lib/turbopack-warning.ts` | 行147-167のエラー判定・出力・プロセス終了ロジック |

**主要処理フロー**:
- **行76**: `hasWebpackConfig = Boolean(rawNextConfig.webpack)`
- **行77**: `hasTurboConfig = Boolean(rawNextConfig.turbopack)`
- **行117-119**: `experimental.turbo`で始まるキーの検出でも`hasTurboConfig = true`
- **行147**: `process.env.TURBOPACK === 'auto' && hasWebpackConfig && !hasTurboConfig`の3条件
- **行148**: `rawNextConfig.configFileName`で設定ファイル名を取得
- **行149-163**: `Log.error`でエラーメッセージ出力
- **行166**: `process.exit(1)`でプロセス終了

### プログラム呼び出し階層図

```
startServer (start-server.ts:479)
    │
    └─ validateTurboNextConfig({dir, configPhase}) (turbopack-warning.ts:42)
           ├─ loadConfig() (行66)
           ├─ hasWebpackConfig / hasTurboConfig 判定 (行76-77)
           ├─ flattenKeys + experimental.turbo検出 (行117-119)
           ├─ Log.error() - エラーメッセージ出力 (行149-163)
           └─ process.exit(1) (行166)
```

### データフロー図

```
[入力]                              [処理]                           [出力]

next.config.js ──────────────┐
  webpack: {...} ─────────────┤
  turbopack: undefined ───────┼── validateTurboNextConfig() ──▶ console.error (stderr)
                              │                                       │
process.env.TURBOPACK ────────┘                                       ▼
                                                              process.exit(1)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| turbopack-warning.ts | `packages/next/src/lib/turbopack-warning.ts` | ソース | エラー判定・出力の実装 |
| start-server.ts | `packages/next/src/server/lib/start-server.ts` | ソース | 開発サーバーからの呼び出し元 |
| impl.ts | `packages/next/src/build/turbopack-build/impl.ts` | ソース | Turbopackビルドからの呼び出し元 |
| config-shared.ts | `packages/next/src/server/config-shared.ts` | ソース | defaultConfigの提供 |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
