# 通知設計書 6-nextモジュール直接インポート警告

## 概要

本ドキュメントは、"next"パッケージを直接インポートした場合にコンソールへ出力される警告通知の設計を記載する。

### 本通知の処理概要

ユーザーのコードが"next"パッケージのメインエントリーポイントを直接インポートした場合に、それが意図しない動作である可能性を警告する。

**業務上の目的・背景**：Next.jsは`next/link`、`next/image`、`next/router`等のサブモジュールを通じて機能を提供する設計であり、`import next from 'next'`のようにメインパッケージを直接インポートすることは通常意図されない。誤ったインポートにより予期しない副作用やランタイムエラーが発生するリスクを防ぐため、警告を出力する。

**通知の送信タイミング**：`import 'next'`または`require('next')`が実行された時点で即座に出力される。モジュール読み込み時にスクリプトとして実行されるため、コンポーネントのレンダリングや関数呼び出しを待たずに発動する。

**通知の受信者**："next"モジュールを直接インポートしたコードを実行している開発者。ターミナル/コンソールを通じて警告を受け取る。

**通知内容の概要**："next"を直接インポートすべきでないこと、インポート元のファイルパス（`module.parent?.filename`）、詳細情報のURL。

**期待されるアクション**：開発者はインポート元のファイルを特定し、`next/link`等の適切なサブモジュールのインポートに修正する。

## 通知種別

コンソール出力（標準エラー出力、Log.warn使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

"next"パッケージのメインエントリーポイントが読み込まれた時点で無条件に出力される。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | import-next-warning.ts（モジュール読み込み時） |
| 出力先 | `Log.warn`（標準エラー出力） |
| 形式 | プレーンテキスト |

### 本文テンプレート

```
⚠ "next" should not be imported directly, imported in {filename}
See more info here: https://nextjs.org/docs/messages/import-next
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| filename | インポート元ファイルパス | `module.parent?.filename` | No（undefinedの場合あり） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モジュール読み込み | `import 'next'`または`require('next')` | 無条件 | スクリプト実行時に即座に発動 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | モジュールが読み込まれれば必ず出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["import 'next' / require('next')"] --> B[import-next-warning.ts実行]
    B --> C[Log.warn呼び出し]
    C --> D[警告メッセージ出力]
    D --> E[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| module.parent未定義 | ESモジュール等の場合 | filenameがundefinedとして出力される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | Node.jsのモジュールキャッシュにより同一プロセス内では1回のみ |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- インポート元のファイルパスが出力されるが、ローカル開発環境の情報であるためリスクは低い

## 備考

- このファイルは5行のみの極めてシンプルな実装
- Node.jsの`module.parent`はESモジュールでは利用できない場合があり、その場合filenameはundefinedとなる
- `module.parent`はNode.js v14以降で非推奨だが、Next.jsでは互換性のために使用されている
- メッセージURLは`https://nextjs.org/docs/messages/import-next`で、詳細な説明と対処法が記載されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | log.ts | `packages/next/src/build/output/log.ts` | `warn`関数（行57-59）。prefixedLogを呼び出し、`⚠`記号付きで`console.warn`に出力 |

**読解のコツ**: `Log.warn`は内部的に`console.warn`を使用するため、標準エラー出力に書き込まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | import-next-warning.ts | `packages/next/src/lib/import-next-warning.ts` | ファイル全体（行1-5）。モジュールのトップレベルでLog.warnが実行される |

**主要処理フロー**:
1. **行1**: `log.ts`から`Log`をインポート
2. **行3-5**: `Log.warn`で警告メッセージを出力。`module.parent?.filename`でインポート元を表示

### プログラム呼び出し階層図

```
require('next') / import 'next'
    │
    └─ import-next-warning.ts (モジュールトップレベル実行)
           └─ Log.warn() (log.ts:57)
                  └─ prefixedLog('warn', ...) (log.ts:20)
                         └─ console.warn() (標準エラー出力)
```

### データフロー図

```
[入力]                        [処理]                     [出力]

module.parent?.filename ──▶ Log.warn() ──▶ console.warn (stderr)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| import-next-warning.ts | `packages/next/src/lib/import-next-warning.ts` | ソース | 警告出力の実装（メインファイル） |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
