# 通知設計書 7-Partytown依存パッケージ不足エラー

## 概要

本ドキュメントは、next/scriptでPartytownを使用しようとしているが必要なパッケージがインストールされていない場合に出力されるエラー通知の設計を記載する。

### 本通知の処理概要

Next.jsの`nextScriptWorkers`実験的機能を有効化してPartytownを使用する際に、必須の`@builder.io/partytown`パッケージがインストールされていない場合にエラーを出力してビルドプロセスを停止する。

**業務上の目的・背景**：PartytownはサードパーティスクリプトをWeb Workerで実行するライブラリであり、Next.jsではnext/scriptコンポーネントの`strategy="worker"`で利用できる。この機能は`@builder.io/partytown`パッケージに依存しているため、パッケージが未インストールの場合に明確なエラーメッセージとインストールコマンドを提示し、開発者の迅速な対応を支援する。

**通知の送信タイミング**：`verifyPartytownSetup`関数が呼び出された際に、`hasNecessaryDependencies`で依存関係チェックを行い、不足が検出された時点で`missingDependencyError`関数がFatalErrorを投げる。

**通知の受信者**：Next.jsのビルドまたは開発サーバー起動を実行する開発者。ターミナル/コンソールを通じてエラーを受け取る。

**通知内容の概要**：Partytownパッケージが不足している旨のエラーメッセージ、パッケージマネージャー（npm/yarn/pnpm）に応じたインストールコマンド、Partytownを使用しない場合の設定無効化方法。

**期待されるアクション**：開発者は表示されたインストールコマンドを実行して`@builder.io/partytown`をインストールするか、`nextScriptWorkers`フラグを無効化する。

## 通知種別

コンソール出力（標準エラー出力、FatalError経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（致命的エラー） |
| リトライ | なし（プロセス停止） |

### 送信先決定ロジック

`@builder.io/partytown`パッケージがプロジェクトの依存関係に存在しない場合に自動出力される。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | verify-partytown-setup.ts |
| 出力先 | `console.error`（FatalError経由） |
| 形式 | ANSIカラー付きテキスト |

### 本文テンプレート

```
It looks like you're trying to use Partytown with next/script but do not have the required package(s) installed.

Please install Partytown by running:

	npm install --save-dev @builder.io/partytown

If you are not trying to use Partytown, please disable the experimental "nextScriptWorkers" flag in next.config.js.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| installCommand | パッケージマネージャーに応じたインストールコマンド | `getPkgManager(dir)`の結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 依存関係チェック | verifyPartytownSetup呼び出し | @builder.io/partytownが未インストール | verify-partytown-setup.ts行77-78 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| パッケージインストール済み | `@builder.io/partytown`がnode_modulesに存在する場合 |
| nextScriptWorkers無効 | 実験的機能が無効の場合、verifyPartytownSetup自体が呼ばれない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[verifyPartytownSetup呼び出し] --> B[hasNecessaryDependencies実行]
    B --> C{@builder.io/partytown存在?}
    C -->|Yes| D[copyPartytownStaticFiles]
    C -->|No| E[missingDependencyError呼び出し]
    E --> F[FatalError throw]
    F --> G{呼び出し元でcatch}
    G --> H[console.errorで出力]
    H --> I[throw errで再スロー]
    D --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| FatalError | @builder.io/partytownが未インストール | エラーメッセージ表示後、例外を再スロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（致命的エラーのためリトライ不可） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- プロジェクトのパッケージマネージャー情報が出力されるが、機密情報は含まれない

## 備考

- `getPkgManager`でyarn/pnpm/npmを自動検出し、適切なインストールコマンドを表示する
- yarn: `yarn add --dev @builder.io/partytown`
- pnpm: `pnpm install --save-dev @builder.io/partytown`
- npm: `npm install --save-dev @builder.io/partytown`
- `FatalError`クラスはスタックトレースなしでエラーメッセージのみを表示するための仕組み
- `verifyPartytownSetup`のcatchブロック（行90-98）でFatalError判定し、console.errorでメッセージ出力後に再スロー

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fatal-error.ts | `packages/next/src/lib/fatal-error.ts` | FatalErrorクラスの構造。スタックトレースなしのエラー表示用 |
| 1-2 | has-necessary-dependencies.ts | `packages/next/src/lib/has-necessary-dependencies.ts` | NecessaryDependencies型。missing配列で不足パッケージを管理 |

**読解のコツ**: `FatalError`はエラーメッセージのみを表示し、スタックトレースを出さないための特殊な例外クラス。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | verify-partytown-setup.ts | `packages/next/src/lib/verify-partytown-setup.ts` | `verifyPartytownSetup`関数（行64-99）のメインフロー |

**主要処理フロー**:
1. **行69-75**: `hasNecessaryDependencies`で`@builder.io/partytown`の存在をチェック
2. **行77**: `partytownDeps.missing?.length > 0`で不足判定
3. **行78**: `missingDependencyError(dir)`呼び出し
4. **行90-98**: FatalErrorのcatch処理。console.errorで出力後に再スロー

#### Step 3: エラーメッセージ構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | verify-partytown-setup.ts | `packages/next/src/lib/verify-partytown-setup.ts` | `missingDependencyError`関数（行12-41）のメッセージ構築 |

**主要処理フロー**:
- **行13**: `getPkgManager(dir)`でパッケージマネージャーを検出
- **行15-40**: FatalErrorをthrow。メッセージにインストールコマンドと無効化方法を含む
- **行24-32**: パッケージマネージャーに応じたコマンド分岐（yarn/pnpm/npm）

### プログラム呼び出し階層図

```
verifyPartytownSetup(dir, targetDir) (verify-partytown-setup.ts:64)
    │
    ├─ hasNecessaryDependencies(dir, [...]) (行69-75)
    │
    ├─ missingDependencyError(dir) (行78, verify-partytown-setup.ts:12)
    │      ├─ getPkgManager(dir) (行13)
    │      └─ throw new FatalError(...) (行15)
    │
    └─ catch (err) (行90)
           ├─ console.error(err.message) (行93)
           └─ throw err (行95)
```

### データフロー図

```
[入力]                           [処理]                          [出力]

dir (プロジェクトルート) ──┐
                          ├── verifyPartytownSetup() ──▶ console.error (stderr)
targetDir ────────────────┘                                     │
                                                                ▼
node_modules/@builder.io/  ──▶ hasNecessaryDependencies()  FatalError throw
partytown の有無チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| verify-partytown-setup.ts | `packages/next/src/lib/verify-partytown-setup.ts` | ソース | Partytownセットアップ検証の実装 |
| has-necessary-dependencies.ts | `packages/next/src/lib/has-necessary-dependencies.ts` | ソース | 依存関係チェックユーティリティ |
| fatal-error.ts | `packages/next/src/lib/fatal-error.ts` | ソース | FatalErrorクラス定義 |
| get-pkg-manager.ts | `packages/next/src/lib/helpers/get-pkg-manager.ts` | ソース | パッケージマネージャー検出 |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
