# 通知設計書 8-Partytownライブラリコピー失敗警告

## 概要

本ドキュメントは、Partytownのライブラリファイルをstaticディレクトリにコピーできなかった場合にコンソールへ出力される警告通知の設計を記載する。

### 本通知の処理概要

Partytownのセットアップ処理において、`@builder.io/partytown`パッケージのライブラリファイルをプロジェクトのstaticディレクトリ（`~partytown`）にコピーする際にエラーが発生した場合、警告メッセージをコンソールに出力する。

**業務上の目的・背景**：PartytownはWeb Worker内でサードパーティスクリプトを実行するために、専用のライブラリファイル群をstaticディレクトリに配置する必要がある。コピー処理が失敗するとPartytownが正常に動作しないため、開発者に問題を通知し、`@builder.io/partytown`パッケージが正しくインストールされているか確認を促す。ただし、致命的エラーとはせず警告に留める設計である。

**通知の送信タイミング**：`verifyPartytownSetup`関数内で`copyPartytownStaticFiles`関数がエラーをスローした際にcatchブロック内で出力される。パッケージ自体はインストール済みだがコピー処理が失敗した場合に発動する。

**通知の受信者**：Next.jsのビルドまたは開発サーバー起動を実行する開発者。ターミナル/コンソールを通じて警告を受け取る。

**通知内容の概要**：ライブラリファイルのコピーに失敗した旨と、`@builder.io/partytown`が依存関係として正しくインストールされているか確認するよう促すメッセージ。

**期待されるアクション**：開発者は`@builder.io/partytown`パッケージを再インストールするか、node_modulesを削除してから依存関係を再インストールする。ファイルシステムの権限問題がないか確認する。

## 通知種別

コンソール出力（標準エラー出力、Log.warn使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中（警告） |
| リトライ | なし |

### 送信先決定ロジック

`@builder.io/partytown`パッケージがインストール済みだが、ライブラリファイルのコピー中にエラーが発生した場合に出力される。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 送信元 | verify-partytown-setup.ts |
| 出力先 | `Log.warn`（標準エラー出力） |
| 形式 | ANSIカラー付きテキスト |

### 本文テンプレート

```
⚠ Partytown library files could not be copied to the static directory. Please ensure that @builder.io/partytown is installed as a dependency.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ファイルコピーエラー | copyPartytownStaticFiles失敗 | catch内で発動 | verify-partytown-setup.ts行82-88 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| コピー成功 | ファイルコピーが正常に完了した場合 |
| パッケージ未インストール | No.7のエラーが先に発動するためこの警告は到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[verifyPartytownSetup] --> B{パッケージインストール済み?}
    B -->|No| C[No.7 FatalError]
    B -->|Yes| D[copyPartytownStaticFiles呼び出し]
    D --> E{コピー成功?}
    E -->|Yes| F[正常終了]
    E -->|No| G[Log.warnで警告出力]
    G --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。データベースは使用しない。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイルコピー失敗 | ディレクトリ権限不足、パッケージ破損等 | Log.warnで警告出力。プロセスは継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- パッケージ名のみが出力され、ファイルシステムの詳細パスやエラー詳細は出力されない
- コピー先はpublicディレクトリ配下であるため、静的ファイルとして公開される点に注意

## 備考

- No.7（パッケージ不足エラー）とは異なり、この通知はプロセスを停止しない（警告のみ）
- コピー先は`{staticDir}/~partytown`ディレクトリ
- コピー処理は既存の`~partytown`ディレクトリを削除してから再作成する（行53-55）
- `@builder.io/partytown`の`utils`モジュールから`copyLibFiles`関数を使用してコピーを実行
- `@builder.io/partytown`のパッケージ名は太字cyanカラーで強調表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | has-necessary-dependencies.ts | `packages/next/src/lib/has-necessary-dependencies.ts` | `NecessaryDependencies`型。resolvedマップでパッケージパスを管理 |

**読解のコツ**: `deps.resolved`はMapオブジェクトで、パッケージ名からインストール先パスへのマッピングを保持している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | verify-partytown-setup.ts | `packages/next/src/lib/verify-partytown-setup.ts` | `verifyPartytownSetup`関数（行64-99）のメインフロー |

**主要処理フロー**:
1. **行69-75**: `hasNecessaryDependencies`でパッケージの存在確認
2. **行79**: パッケージ存在確認後のelseブロック
3. **行80-81**: `copyPartytownStaticFiles`呼び出し（try内）
4. **行82-88**: catchブロックで`Log.warn`出力

#### Step 3: コピー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | verify-partytown-setup.ts | `packages/next/src/lib/verify-partytown-setup.ts` | `copyPartytownStaticFiles`関数（行43-62）のコピーロジック |

**主要処理フロー**:
- **行47**: コピー先を`{staticDir}/~partytown`に設定
- **行48-51**: 既存ディレクトリの存在チェック
- **行53-55**: 既存ディレクトリを再帰的に削除
- **行57-59**: `@builder.io/partytown`のutilsモジュールからcopyLibFilesを取得
- **行61**: `copyLibFiles(partytownLibDir)`でコピー実行

### プログラム呼び出し階層図

```
verifyPartytownSetup(dir, targetDir) (verify-partytown-setup.ts:64)
    │
    ├─ hasNecessaryDependencies(dir, [...]) (行69-75)
    │
    └─ [パッケージ存在時]
           ├─ copyPartytownStaticFiles(deps, targetDir) (行81, verify-partytown-setup.ts:43)
           │      ├─ fileExists(partytownLibDir) (行48)
           │      ├─ promises.rm(partytownLibDir, ...) (行54)
           │      ├─ require(...utils).copyLibFiles (行57-59)
           │      └─ copyLibFiles(partytownLibDir) (行61)
           │
           └─ [コピー失敗時] catch (err) (行82)
                  └─ Log.warn(...) (行83-87)
```

### データフロー図

```
[入力]                              [処理]                         [出力]

node_modules/@builder.io/  ──┐
partytown/lib/ ───────────────┼── copyPartytownStaticFiles() ──▶ {staticDir}/~partytown/
                              │           │
staticDir ────────────────────┘           │ [失敗時]
                                          ▼
                                    Log.warn() ──▶ console.warn (stderr)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| verify-partytown-setup.ts | `packages/next/src/lib/verify-partytown-setup.ts` | ソース | Partytownセットアップ検証とコピー処理の実装 |
| has-necessary-dependencies.ts | `packages/next/src/lib/has-necessary-dependencies.ts` | ソース | 依存関係チェックユーティリティ |
| file-exists.ts | `packages/next/src/lib/file-exists.ts` | ソース | ファイル/ディレクトリ存在チェック |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力基盤 |
