---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-サーバー起動情報通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/lib/app-info-log.ts` - logStartInfo関数（行15-64）
- E-02: `packages/next/src/server/lib/app-info-log.ts` - logExperimentalInfo関数（行70-114）
- E-03: `packages/next/src/server/lib/app-info-log.ts` - getEnvInfo関数（行119-122）
- E-04: `packages/next/src/server/lib/start-server.ts` - startServer内のlogStartInfo呼び出し（行362）
- E-05: `packages/next/src/build/output/log.ts` - bootstrap関数（行45-47）
- E-06: `packages/next/src/build/index.ts` - ビルド時のlogStartInfo呼び出し（行1163）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | logStartInfoはバージョン番号をprocess.env.__NEXT_VERSIONから取得する | E-01（行45） | ○ |
| C-02 | バンドラー判定はTURBOPACK, NEXT_RSPACK環境変数で行われる | E-01（行30-36） | ○ |
| C-03 | appUrlが存在する場合のみローカルURL出力 | E-01（行48-50） | ○ |
| C-04 | networkUrlが存在する場合のみネットワークURL出力 | E-01（行51-53） | ○ |
| C-05 | inspector.url()が存在する場合にデバッガポートを出力 | E-01（行54-62） | ○ |
| C-06 | 環境ファイル情報はenvInfoが存在する場合に出力 | E-01（行63） | ○ |
| C-07 | logStartInfoは設定読み込み前に呼び出される | E-04（行361-367, 450） | ○ |
| C-08 | Log.bootstrapはconsole.logを直接呼び出す | E-05（行45-47） | ○ |
| C-09 | ビルド時にもlogStartInfoが呼び出される | E-06（行1163） | ○ |
| C-10 | getEnvInfoはloadEnvConfigを使用して環境ファイルを検出する | E-03（行120-121） | ○ |
| C-11 | logBundlerがtrueの場合のみバンドラー名が表示される | E-01（行29-41） | ○ |
| C-12 | 開発モードとプロダクションモードの両方で起動情報が出力される | E-04, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] `app-info-log.ts`の`logStartInfo`関数の出力フォーマットが設計書と一致するか確認
- [ ] `start-server.ts`での呼び出し順序（設定読み込み前）が正しいか確認
