---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-ページリロード通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 105-108行目 - ReloadPageMessage型定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 18-22行目 - HMR_MESSAGE_SENT_TO_BROWSER.RELOAD_PAGE定義
- E-03: `packages/next/src/server/dev/turbopack-utils.ts` 300-316行目 - _document変更サブスクリプション
- E-04: `packages/next/src/server/dev/turbopack-utils.ts` 262-298行目 - ページdata/htmlサブスクリプションエラー処理
- E-05: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 620-628行目 - HMRサブスクリプションエラー処理
- E-06: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 454-461行目 - sendToClient関数
- E-07: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 509-519行目 - sendHmr関数
- E-08: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 463-506行目 - sendEnqueuedMessages関数
- E-09: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 436-447行目 - App RouterでのRELOAD_PAGE処理
- E-10: `packages/next/src/client/page-bootstrap.ts` 37-40行目 - Pages RouterでのRELOAD_PAGE処理
- E-11: `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` 87-89行目 - TurbopackHmr.onReloadPage()
- E-12: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 626行目 - エラー時のclient.close()
- E-13: `packages/next/src/server/dev/turbopack-utils.ts` 357-380行目 - app-pageサブスクリプションエラー処理
- E-14: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 384-391行目 - Pages Router processMessageでのRELOAD_PAGE処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReloadPageMessageはtype(RELOAD_PAGE)とdata(string)フィールドを持つ | E-01 | ○ |
| C-02 | RELOAD_PAGEの値は文字列`reloadPage` | E-02 | ○ |
| C-03 | _document.jsの変更時にRELOAD_PAGEが送信される | E-03 | ○ |
| C-04 | ページdata/htmlサブスクリプションエラー時にRELOAD_PAGEが送信される | E-04 | ○ |
| C-05 | HMRイベントサブスクリプションエラー時にRELOAD_PAGEが送信される | E-05 | ○ |
| C-06 | sendToClient関数はJSONメッセージをclient.sendで送信する | E-06 | ○ |
| C-07 | sendHmr関数は全クライアントのメッセージキューにメッセージを追加する | E-07 | ○ |
| C-08 | sendEnqueuedMessagesはコンパイルエラー中はメッセージ送信を保留する | E-08 | ○ |
| C-09 | App RouterではRELOAD_PAGE受信時にwindow.location.reload()を実行する | E-09 | ○ |
| C-10 | Pages RouterではRELOAD_PAGE受信時にwindow.location.reload()を実行する | E-10 | ○ |
| C-11 | TurbopackHmrのonReloadPage()はHMRラテンシ計測用の更新処理を行う | E-11 | ○ |
| C-12 | HMRサブスクリプションエラー時にclient.close()が呼ばれる | E-12 | ○ |
| C-13 | app-pageサブスクリプションエラー時にもRELOAD_PAGEが送信される | E-13 | ○ |
| C-14 | reloadingフラグにより重複リロードが防止される | E-09, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張にソースコードの根拠がある。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ReloadPageMessage型定義がhot-reloader-types.tsの記載と一致するか確認
- [ ] _document変更時のサブスクリプション登録箇所（turbopack-utils.ts 300-316行目）が正確か確認
- [ ] クライアント側のリロード処理が記載通りに実装されているか確認
