---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-サーバーコンポーネント変更通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 110-113行目 - ServerComponentChangesMessage型定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 23行目 - SERVER_COMPONENT_CHANGES enum値
- E-03: `packages/next/src/server/dev/turbopack-utils.ts` 357-380行目 - app-page rscEndpointサブスクリプション
- E-04: `packages/next/src/server/dev/turbopack-utils.ts` 362行目 - エラーチェックロジック
- E-05: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1270-1284行目 - invalidateメソッド
- E-06: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 399-435行目 - App Router受信処理
- E-07: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 411行目 - Cookie設定
- E-08: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 422-425行目 - hmrRefresh呼び出し
- E-09: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 342-348行目 - Pages Router受信処理
- E-10: `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` 83-85行目 - onServerComponentChanges()
- E-11: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 413-420行目 - ランタイムエラー/エラーページ時のフルリロード
- E-12: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1275-1279行目 - invalidation時のキャッシュクリア

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServerComponentChangesMessageはtypeとhashフィールドを持つ | E-01 | ○ |
| C-02 | SERVER_COMPONENT_CHANGESの値は`serverComponentChanges` | E-02 | ○ |
| C-03 | app-pageルートのrscEndpointで変更検出時に送信される | E-03 | ○ |
| C-04 | severity=errorのissueがある場合はメッセージ生成がスキップされる | E-04 | ○ |
| C-05 | invalidation時にreloadAfterInvalidation=trueで送信される | E-05 | ○ |
| C-06 | App Routerではhash値をCookieに保存する | E-07 | ○ |
| C-07 | App RouterではhmrRefresh()を呼び出す | E-08 | ○ |
| C-08 | ランタイムエラー時はフルリロードを実行する | E-11 | ○ |
| C-09 | Pages Routerではエラー時のみリロードする | E-09 | ○ |
| C-10 | TurbopackHmrのonServerComponentChanges()が呼び出される | E-10 | ○ |
| C-11 | invalidation時にclearAllModuleContexts()が実行される | E-12 | ○ |
| C-12 | hmrRefresh()はstartTransition内で呼び出される | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] rscEndpointのサブスクリプション登録箇所が正確か確認
- [ ] App Routerでのhash Cookie設定ロジックが正確か確認
- [ ] Pages Routerでのエラー条件分岐が正確か確認
