---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-クライアント変更通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 119-121行目 - ClientChangesMessage型
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 25行目 - CLIENT_CHANGES enum
- E-03: `packages/next/src/server/dev/turbopack-utils.ts` 283-298行目 - htmlEndpointサブスクリプション
- E-04: `packages/next/src/client/page-bootstrap.ts` 58-69行目 - CLIENT_CHANGES受信処理
- E-05: `packages/next/src/client/page-bootstrap.ts` 60行目 - エラーページ判定
- E-06: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 537-541行目 - App Router委譲
- E-07: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 400-404行目 - Pages Router委譲
- E-08: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 509-519行目 - sendHmr

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClientChangesMessageはtypeフィールドのみ | E-01 | ○ |
| C-02 | CLIENT_CHANGESの値は`clientChanges` | E-02 | ○ |
| C-03 | Pages RouterのhtmlEndpoint変更時に送信される | E-03 | ○ |
| C-04 | エラーページ表示中にフルリロードが実行される | E-04, E-05 | ○ |
| C-05 | エラーページ判定は`window.next.router.pathname === '/_error'` | E-05 | ○ |
| C-06 | App RouterではCLIENT_CHANGESをpage-bootstrap.tsに委譲 | E-06 | ○ |
| C-07 | Pages RouterでもCLIENT_CHANGESをpage-bootstrap.tsに委譲 | E-07 | ○ |
| C-08 | sendHmrで全クライアントのキューに追加される | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] htmlEndpointサブスクリプション登録箇所を確認
- [ ] エラーページ判定ロジックが正確か確認
