---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-サーバーのみ変更通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 123-126行目 - ServerOnlyChangesMessage型
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 26行目 - SERVER_ONLY_CHANGES enum
- E-03: `packages/next/src/server/dev/turbopack-utils.ts` 264-282行目 - dataEndpointサブスクリプション
- E-04: `packages/next/src/server/dev/turbopack-utils.ts` 270行目 - readyIds.delete(pathname)
- E-05: `packages/next/src/client/page-bootstrap.ts` 71-112行目 - SERVER_ONLY_CHANGES受信処理
- E-06: `packages/next/src/client/page-bootstrap.ts` 72-75行目 - ランタイムエラーチェック
- E-07: `packages/next/src/client/page-bootstrap.ts` 82-84行目 - APIルート判定
- E-08: `packages/next/src/client/page-bootstrap.ts` 86-109行目 - router.replaceによるデータ再取得
- E-09: `packages/next/src/client/page-bootstrap.ts` 104-107行目 - 失敗時のfallbackリロード
- E-10: `packages/next/src/client/page-bootstrap.ts` 88-89行目 - building indicator表示

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServerOnlyChangesMessageはtypeとpages配列を持つ | E-01 | ○ |
| C-02 | SERVER_ONLY_CHANGESの値は`serverOnlyChanges` | E-02 | ○ |
| C-03 | dataEndpoint変更時に送信される | E-03 | ○ |
| C-04 | readyIds.deleteで再コンパイルマークされる | E-04 | ○ |
| C-05 | ランタイムエラー時はperformFullReload | E-06 | ○ |
| C-06 | APIルートの場合はwindow.location.reload() | E-07 | ○ |
| C-07 | 該当ページ表示中はrouter.replace()でデータ再取得 | E-08 | ○ |
| C-08 | データ再取得失敗時はlocation.reload() | E-09 | ○ |
| C-09 | データ再取得中はbuilding indicator表示 | E-10 | ○ |
| C-10 | サブスクリプションエラー時はRELOAD_PAGEにフォールバック | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] dataEndpointサブスクリプション登録箇所を確認
- [ ] クライアント側のrouter.replace()ロジックが正確か確認
- [ ] エラーフォールバックの動作を確認
