---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-ビルド中通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 63-65行目 - BuildingMessage型
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 29行目 - BUILDING enum
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1477-1482行目 - Turbopack送信
- E-04: `packages/next/src/server/dev/hot-middleware.ts` 106-111行目 - Webpack送信
- E-05: `packages/next/src/server/dev/hot-middleware.ts` 107行目 - サーバーエラーチェック
- E-06: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 286-297行目 - App Router処理
- E-07: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 282-292行目 - Pages Router処理
- E-08: `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` 54-67行目 - onBuilding遅延
- E-09: `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` 12行目 - TURBOPACK_HMR_START_DELAY_MS = 100
- E-10: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 287行目 - buildingIndicatorShow()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildingMessageはtypeフィールドのみ | E-01 | ○ |
| C-02 | BUILDINGの値は`building` | E-02 | ○ |
| C-03 | TurbopackではupdateType startで送信 | E-03 | ○ |
| C-04 | Webpackではclientコンパイラinvalidフックで送信 | E-04 | ○ |
| C-05 | Webpackサーバーエラー時は送信しない | E-05 | ○ |
| C-06 | App Routerでビルドインジケーター表示 | E-06, E-10 | ○ |
| C-07 | Pages Routerでも同様に処理 | E-07 | ○ |
| C-08 | Turbopackでは100ms遅延でコンソール出力 | E-08, E-09 | ○ |
| C-09 | Webpackでは即座にコンソール出力 | E-06 | ○ |
| C-10 | BUILTまたはSYNC受信でインジケーター非表示 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] Turbopackのstart/endイベントの送受信が正確か確認
- [ ] Webpackのinvalidフックの発火タイミングを確認
- [ ] TurbopackHmrの遅延ロジックが100msであることを確認
